/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.BlockPocketManagerBlockEntity;
import net.geforcemods.securitycraft.inventory.BlockPocketManagerMenu;
import net.geforcemods.securitycraft.network.server.AssembleBlockPocket;
import net.geforcemods.securitycraft.network.server.SyncBlockPocketManager;
import net.geforcemods.securitycraft.network.server.ToggleBlockPocketManager;
import net.geforcemods.securitycraft.screen.components.CallbackSlider;
import net.geforcemods.securitycraft.screen.components.ColorChooser;
import net.geforcemods.securitycraft.screen.components.ColorChooserButton;
import net.geforcemods.securitycraft.screen.components.StackHoverChecker;
import net.geforcemods.securitycraft.screen.components.ToggleComponentButton;
import net.geforcemods.securitycraft.util.IHasExtraAreas;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.network.PacketDistributor;
import org.apache.commons.lang3.ArrayUtils;

public class BlockPocketManagerScreen
extends AbstractContainerScreen<BlockPocketManagerMenu>
implements IHasExtraAreas {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft:textures/gui/container/block_pocket_manager.png");
    private static final ResourceLocation TEXTURE_STORAGE = new ResourceLocation("securitycraft:textures/gui/container/block_pocket_manager_storage.png");
    private static final ItemStack BLOCK_POCKET_WALL = new ItemStack((ItemLike)SCContent.BLOCK_POCKET_WALL.get());
    private static final ItemStack REINFORCED_CHISELED_CRYSTAL_QUARTZ = new ItemStack((ItemLike)SCContent.REINFORCED_CHISELED_CRYSTAL_QUARTZ.get());
    private static final ItemStack REINFORCED_CRYSTAL_QUARTZ_PILLAR = new ItemStack((ItemLike)SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get());
    private static final int CHISELED_NEEDED_OVERALL = 8;
    private final Component youNeed = Utils.localize("gui.securitycraft:blockPocketManager.youNeed", new Object[0]);
    private final boolean hasStorageModule;
    private final boolean isOwner;
    private final int[] materialCounts = new int[3];
    public final BlockPocketManagerBlockEntity be;
    private int size = 5;
    private final int[] allowedSizes = new int[]{5, 9, 13, 17, 21, 25};
    private Button assembleButton;
    private Button outlineButton;
    private CallbackSlider offsetSlider;
    private StackHoverChecker[] hoverCheckers = new StackHoverChecker[3];
    private ColorChooser colorChooser;
    private int wallsNeededOverall = (this.size - 2) * (this.size - 2) * 6;
    private int pillarsNeededOverall = (this.size - 2) * 12 - 1;
    private int wallsStillNeeded;
    private int pillarsStillNeeded;
    private int chiseledStillNeeded;
    private final int previousColor;

    public BlockPocketManagerScreen(BlockPocketManagerMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
        this.be = menu.be;
        this.size = this.be.getSize();
        this.isOwner = menu.isOwner;
        this.hasStorageModule = menu.hasStorageModule;
        if (this.hasStorageModule) {
            this.f_97726_ = 256;
        }
        this.f_97727_ = !this.hasStorageModule ? 194 : 240;
        this.previousColor = this.be.getColor();
    }

    public void m_7856_() {
        int[] nArray;
        super.m_7856_();
        int guiWidth = this.hasStorageModule ? 123 : this.f_97726_;
        int widgetWidth = this.hasStorageModule ? 110 : 120;
        int widgetOffset = widgetWidth / 2;
        if (this.hasStorageModule) {
            int[] nArray2 = new int[5];
            nArray2[0] = -76;
            nArray2[1] = -100;
            nArray2[2] = -52;
            nArray2[3] = -28;
            nArray = nArray2;
            nArray2[4] = -4;
        } else {
            int[] nArray3 = new int[5];
            nArray3[0] = -40;
            nArray3[1] = -70;
            nArray3[2] = 23;
            nArray3[3] = 47;
            nArray = nArray3;
            nArray3[4] = 71;
        }
        int[] yOffset = nArray;
        int outlineY = this.f_97736_ + this.f_97727_ / 2 + yOffset[2];
        int colorChooserButtonX = this.f_97735_ + guiWidth / 2 - widgetOffset + (this.hasStorageModule ? 0 : widgetWidth + 3);
        int outlineButtonX = colorChooserButtonX + (this.hasStorageModule ? 23 : -widgetWidth - 3);
        int outlineButtonWidth = widgetWidth - (this.hasStorageModule ? 23 : 0);
        int colorChooserX = colorChooserButtonX + (this.hasStorageModule ? -145 : 20);
        Button toggleButton = (Button)this.m_142416_((GuiEventListener)new Button(this.f_97735_ + guiWidth / 2 - widgetOffset, this.f_97736_ + this.f_97727_ / 2 + yOffset[0], widgetWidth, 20, (Component)Utils.localize("gui.securitycraft:blockPocketManager." + (!this.be.isEnabled() ? "activate" : "deactivate"), new Object[0]), this::toggleButtonClicked, Button.f_252438_));
        Button sizeButton = (Button)this.m_142416_((GuiEventListener)new ToggleComponentButton(this.f_97735_ + guiWidth / 2 - widgetOffset, this.f_97736_ + this.f_97727_ / 2 + yOffset[1], widgetWidth, 20, this::updateSizeButtonText, ArrayUtils.indexOf((int[])this.allowedSizes, (int)this.size), this.allowedSizes.length, this::sizeButtonClicked));
        this.outlineButton = (Button)this.m_142416_((GuiEventListener)new Button(outlineButtonX, outlineY, outlineButtonWidth, 20, (Component)Utils.localize("gui.securitycraft:blockPocketManager.outline." + (!this.be.showsOutline() ? "show" : "hide"), new Object[0]), this::outlineButtonClicked, Button.f_252438_));
        this.assembleButton = (Button)this.m_142416_((GuiEventListener)new Button(this.f_97735_ + guiWidth / 2 - widgetOffset, this.f_97736_ + this.f_97727_ / 2 + yOffset[3], widgetWidth, 20, (Component)Utils.localize("gui.securitycraft:blockPocketManager.assemble", new Object[0]), this::assembleButtonClicked, Button.f_252438_));
        this.offsetSlider = (CallbackSlider)this.m_142416_((GuiEventListener)new CallbackSlider(this.f_97735_ + guiWidth / 2 - widgetOffset, this.f_97736_ + this.f_97727_ / 2 + yOffset[4], widgetWidth, 20, (Component)Utils.localize("gui.securitycraft:projector.offset", ""), (Component)Component.m_237119_(), (-this.size + 2) / 2, (this.size - 2) / 2, this.be.getAutoBuildOffset(), true, this::offsetSliderReleased));
        this.colorChooser = (ColorChooser)this.m_142416_(new ColorChooser((Component)Component.m_237119_(), colorChooserX, outlineY, this.be.getColor()){

            @Override
            public void onColorChange() {
                BlockPocketManagerScreen.this.be.setColor(this.getRGBColor());
            }
        });
        this.colorChooser.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
        Button colorChooserButton = (Button)this.m_142416_((GuiEventListener)new ColorChooserButton(colorChooserButtonX, outlineY, 20, 20, this.colorChooser));
        if (!this.be.isOwnedBy((Entity)Minecraft.m_91087_().f_91074_)) {
            colorChooserButton.f_93623_ = false;
            this.offsetSlider.f_93623_ = false;
            this.outlineButton.f_93623_ = false;
            this.assembleButton.f_93623_ = false;
            toggleButton.f_93623_ = false;
            sizeButton.f_93623_ = false;
        } else {
            this.updateMaterialInformation(true);
            this.offsetSlider.f_93623_ = !this.be.isEnabled();
            sizeButton.f_93623_ = this.offsetSlider.f_93623_;
        }
        if (!this.hasStorageModule) {
            this.hoverCheckers[0] = new StackHoverChecker(BLOCK_POCKET_WALL, this.f_97736_ + 93, this.f_97736_ + 113, this.f_97735_ + 23, this.f_97735_ + 43);
            this.hoverCheckers[1] = new StackHoverChecker(REINFORCED_CRYSTAL_QUARTZ_PILLAR, this.f_97736_ + 93, this.f_97736_ + 113, this.f_97735_ + 75, this.f_97735_ + 95);
            this.hoverCheckers[2] = new StackHoverChecker(REINFORCED_CHISELED_CRYSTAL_QUARTZ, this.f_97736_ + 93, this.f_97736_ + 113, this.f_97735_ + 128, this.f_97735_ + 148);
        } else {
            this.hoverCheckers[0] = new StackHoverChecker(BLOCK_POCKET_WALL, this.f_97736_ + this.f_97727_ - 73, this.f_97736_ + this.f_97727_ - 54, this.f_97735_ + 174, this.f_97735_ + 191);
            this.hoverCheckers[1] = new StackHoverChecker(REINFORCED_CRYSTAL_QUARTZ_PILLAR, this.f_97736_ + this.f_97727_ - 50, this.f_97736_ + this.f_97727_ - 31, this.f_97735_ + 174, this.f_97735_ + 191);
            this.hoverCheckers[2] = new StackHoverChecker(REINFORCED_CHISELED_CRYSTAL_QUARTZ, this.f_97736_ + this.f_97727_ - 27, this.f_97736_ + this.f_97727_ - 9, this.f_97735_ + 174, this.f_97735_ + 191);
        }
        this.updateAssembleButtonTooltip();
        colorChooserButton.m_257544_(Tooltip.m_257550_((Component)Utils.localize("gui.securitycraft:choose_outline_color_tooltip", new Object[0])));
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.m_280614_(this.f_96547_, this.f_96539_, (this.hasStorageModule ? 123 : this.f_97726_) / 2 - this.f_96547_.m_92852_((FormattedText)this.f_96539_) / 2, 6, 0x404040, false);
        if (this.hasStorageModule) {
            guiGraphics.m_280614_(this.f_96547_, this.f_169604_, 8, this.f_97727_ - 94, 0x404040, false);
        }
        if (!this.be.isEnabled() && this.isOwner) {
            if (!this.hasStorageModule) {
                guiGraphics.m_280614_(this.f_96547_, this.youNeed, this.f_97726_ / 2 - this.f_96547_.m_92852_((FormattedText)this.youNeed) / 2, 83, 0x404040, false);
                guiGraphics.m_280056_(this.f_96547_, "" + this.wallsNeededOverall, 42, 100, 0x404040, false);
                guiGraphics.m_280480_(BLOCK_POCKET_WALL, 25, 96);
                guiGraphics.m_280056_(this.f_96547_, "" + this.pillarsNeededOverall, 94, 100, 0x404040, false);
                guiGraphics.m_280480_(REINFORCED_CRYSTAL_QUARTZ_PILLAR, 77, 96);
                guiGraphics.m_280056_(this.f_96547_, "8", 147, 100, 0x404040, false);
                guiGraphics.m_280480_(REINFORCED_CHISELED_CRYSTAL_QUARTZ, 130, 96);
            } else {
                guiGraphics.m_280614_(this.f_96547_, this.youNeed, 212 - this.f_96547_.m_92852_((FormattedText)this.youNeed) / 2, this.f_97727_ - 83, 0x404040, false);
                guiGraphics.m_280056_(this.f_96547_, "" + Math.max(0, this.wallsStillNeeded), 192, this.f_97727_ - 66, 0x404040, false);
                guiGraphics.m_280480_(BLOCK_POCKET_WALL, 175, this.f_97727_ - 70);
                guiGraphics.m_280056_(this.f_96547_, "" + Math.max(0, this.pillarsStillNeeded), 192, this.f_97727_ - 44, 0x404040, false);
                guiGraphics.m_280480_(REINFORCED_CRYSTAL_QUARTZ_PILLAR, 175, this.f_97727_ - 48);
                guiGraphics.m_280056_(this.f_96547_, "" + Math.max(0, this.chiseledStillNeeded), 192, this.f_97727_ - 22, 0x404040, false);
                guiGraphics.m_280480_(REINFORCED_CHISELED_CRYSTAL_QUARTZ, 175, this.f_97727_ - 26);
            }
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.hasStorageModule) {
            this.m_280072_(guiGraphics, mouseX, mouseY);
        }
        if (!this.be.isEnabled() && this.isOwner) {
            for (StackHoverChecker shc : this.hoverCheckers) {
                if (!shc.checkHover(mouseX, mouseY)) continue;
                guiGraphics.m_280153_(this.f_96547_, shc.getStack(), mouseX, mouseY);
                break;
            }
        }
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        this.m_280273_(guiGraphics);
        guiGraphics.m_280218_(this.hasStorageModule ? TEXTURE_STORAGE : TEXTURE, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
    }

    protected void m_181908_() {
        if (this.colorChooser != null) {
            this.colorChooser.m_86600_();
        }
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.colorChooser != null) {
            this.colorChooser.m_7979_(mouseX, mouseY, button, dragX, dragY);
        }
        return this.m_7222_() != null && this.m_7282_() && button == 0 && this.m_7222_().m_7979_(mouseX, mouseY, button, dragX, dragY) || super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.colorChooser != null) {
            this.colorChooser.m_7933_(keyCode, scanCode, modifiers);
            if (!this.colorChooser.getRgbHexBox().m_93696_()) {
                return super.m_7933_(keyCode, scanCode, modifiers);
            }
        }
        return true;
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (this.colorChooser != null && this.colorChooser.m_5534_(codePoint, modifiers)) {
            return true;
        }
        return super.m_5534_(codePoint, modifiers);
    }

    protected void m_6597_(Slot slot, int slotId, int mouseButton, ClickType type) {
        super.m_6597_(slot, slotId, mouseButton, type);
        this.updateMaterialInformation(true);
    }

    @Override
    public List<Rect2i> getExtraAreas() {
        if (this.colorChooser != null) {
            return this.colorChooser.getGuiExtraAreas();
        }
        return List.of();
    }

    public void m_7379_() {
        super.m_7379_();
        if (this.previousColor != this.be.getColor()) {
            this.sync();
        }
    }

    private void updateMaterialInformation(boolean recalculateStoredStacks) {
        if (recalculateStoredStacks) {
            this.materialCounts[2] = 0;
            this.materialCounts[1] = 0;
            this.materialCounts[0] = 0;
            this.be.getStorageHandler().ifPresent(handler -> {
                for (int i = 0; i < handler.getSlots(); ++i) {
                    ItemStack stack = handler.getStackInSlot(i);
                    Item patt12641$temp = stack.m_41720_();
                    if (!(patt12641$temp instanceof BlockItem)) continue;
                    BlockItem blockItem = (BlockItem)patt12641$temp;
                    Block block = blockItem.m_40614_();
                    if (block == SCContent.BLOCK_POCKET_WALL.get()) {
                        this.materialCounts[0] = this.materialCounts[0] + stack.m_41613_();
                        continue;
                    }
                    if (block == SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get()) {
                        this.materialCounts[1] = this.materialCounts[1] + stack.m_41613_();
                        continue;
                    }
                    if (block != SCContent.REINFORCED_CHISELED_CRYSTAL_QUARTZ.get()) continue;
                    this.materialCounts[2] = this.materialCounts[2] + stack.m_41613_();
                }
            });
        }
        this.wallsNeededOverall = (this.size - 2) * (this.size - 2) * 6;
        this.pillarsNeededOverall = (this.size - 2) * 12 - 1;
        this.wallsStillNeeded = this.wallsNeededOverall - this.materialCounts[0];
        this.pillarsStillNeeded = this.pillarsNeededOverall - this.materialCounts[1];
        this.chiseledStillNeeded = 8 - this.materialCounts[2];
        this.assembleButton.f_93623_ = this.isOwner && (this.f_96541_.f_91074_.m_7500_() || !this.be.isEnabled() && this.hasStorageModule && this.wallsStillNeeded <= 0 && this.pillarsStillNeeded <= 0 && this.chiseledStillNeeded <= 0);
        this.updateAssembleButtonTooltip();
    }

    public void toggleButtonClicked(Button button) {
        this.be.setSize(this.size);
        this.be.setEnabled(!this.be.isEnabled());
        SecurityCraft.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new ToggleBlockPocketManager(this.be, this.be.isEnabled()));
        Minecraft.m_91087_().f_91074_.m_6915_();
    }

    public void sizeButtonClicked(Button button) {
        this.size = this.allowedSizes[((ToggleComponentButton)button).getCurrentIndex()];
        int newMin = (-this.size + 2) / 2;
        int newMax = (this.size - 2) / 2;
        int newOffset = this.be.getAutoBuildOffset() > 0 ? Math.min(this.be.getAutoBuildOffset(), newMax) : Math.max(this.be.getAutoBuildOffset(), newMin);
        this.updateMaterialInformation(false);
        this.be.setSize(this.size);
        this.offsetSlider.setMinValue(newMin);
        this.offsetSlider.setMaxValue(newMax);
        this.be.setAutoBuildOffset(newOffset);
        this.offsetSlider.m_93611_(newOffset);
        this.sync();
        ((ToggleComponentButton)button).onValueChange();
    }

    public Component updateSizeButtonText(int index) {
        return Utils.localize("gui.securitycraft:blockPocketManager.size", this.size, this.size, this.size);
    }

    public void assembleButtonClicked(Button button) {
        this.be.setSize(this.size);
        SecurityCraft.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new AssembleBlockPocket(this.be));
        Minecraft.m_91087_().f_91074_.m_6915_();
    }

    public void updateAssembleButtonTooltip() {
        if (!this.assembleButton.m_142518_()) {
            this.assembleButton.m_257544_(Tooltip.m_257550_((Component)(!this.hasStorageModule ? Utils.localize("gui.securitycraft:blockPocketManager.needStorageModule", new Object[0]) : Utils.localize("messages.securitycraft:blockpocket.notEnoughItems", new Object[0]))));
        } else {
            this.assembleButton.m_257544_(null);
        }
    }

    public void outlineButtonClicked(Button button) {
        this.be.toggleOutline();
        this.outlineButton.m_93666_((Component)Utils.localize("gui.securitycraft:blockPocketManager.outline." + (!this.be.showsOutline() ? "show" : "hide"), new Object[0]));
        this.sync();
    }

    public void offsetSliderReleased(CallbackSlider slider) {
        this.be.setAutoBuildOffset(slider.getValueInt());
        this.sync();
    }

    private void sync() {
        SecurityCraft.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new SyncBlockPocketManager(this.be.m_58899_(), this.be.getSize(), this.be.showsOutline(), this.be.getAutoBuildOffset(), this.be.getColor()));
    }
}

