/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.entity.camera.SecurityCamera;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class SetDefaultCameraViewingDirection {
    private int id;
    private float initialXRotation;
    private float initialYRotation;
    private float initialZoom;

    public SetDefaultCameraViewingDirection() {
    }

    public SetDefaultCameraViewingDirection(SecurityCamera cam) {
        this.id = cam.m_19879_();
        this.initialXRotation = cam.m_146909_();
        this.initialYRotation = cam.m_146908_();
        this.initialZoom = cam.getZoomAmount();
    }

    public SetDefaultCameraViewingDirection(FriendlyByteBuf buf) {
        this.id = buf.m_130242_();
        this.initialXRotation = buf.readFloat();
        this.initialYRotation = buf.readFloat();
        this.initialZoom = buf.readFloat();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130130_(this.id);
        buf.writeFloat(this.initialXRotation);
        buf.writeFloat(this.initialYRotation);
        buf.writeFloat(this.initialZoom);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        SecurityCamera camera;
        Entity entity;
        ServerPlayer player = ctx.get().getSender();
        if (!player.m_5833_() && (entity = player.m_8954_()) instanceof SecurityCamera && (camera = (SecurityCamera)entity).m_19879_() == this.id && (entity = camera.m_9236_().m_7702_(camera.m_20183_())) instanceof SecurityCameraBlockEntity) {
            SecurityCameraBlockEntity be = (SecurityCameraBlockEntity)entity;
            if (!be.isOwnedBy((Entity)player)) {
                player.m_5661_((Component)Utils.localize("messages.securitycraft:security_camera.no_permission", new Object[0]), true);
                return;
            }
            if (be.isModuleEnabled(ModuleType.SMART)) {
                be.setDefaultViewingDirection(this.initialXRotation, this.initialYRotation, this.initialZoom);
                player.m_5661_((Component)Utils.localize("messages.securitycraft:security_camera.direction_set", new Object[0]), true);
            } else {
                player.m_5661_((Component)Utils.localize("messages.securitycraft:security_camera.smart_module_needed", new Object[0]), true);
            }
        }
    }
}

