/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.entity.camera;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.function.Consumer;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.compat.sodium.SodiumCompat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundLevelChunkPacketData;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.eventbus.api.Event;

public class CameraClientChunkCacheExtension {
    private static final Long2ObjectOpenHashMap<LevelChunk> CHUNK_MAP = new Long2ObjectOpenHashMap();
    private static final Long2ObjectOpenHashMap<LevelChunk> CHUNK_MAP_OTHER_THREADS = new Long2ObjectOpenHashMap();

    private CameraClientChunkCacheExtension() {
    }

    public static void drop(ClientLevel level, ChunkPos chunkPos) {
        long chunkPosLong;
        LevelChunk chunk;
        if (Minecraft.m_91087_().m_18695_() && (chunk = (LevelChunk)CHUNK_MAP.get(chunkPosLong = chunkPos.m_45588_())) != null) {
            CameraClientChunkCacheExtension.modifyChunkMaps(map -> map.remove(chunkPosLong));
            MinecraftForge.EVENT_BUS.post((Event)new ChunkEvent.Unload((ChunkAccess)chunk));
            level.m_104665_(chunk);
            if (SecurityCraft.IS_A_SODIUM_MOD_INSTALLED) {
                SodiumCompat.onChunkStatusRemoved(level, chunkPos.f_45578_, chunkPos.f_45579_);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LevelChunk getChunk(int x, int z) {
        long chunkPos = ChunkPos.m_45589_((int)x, (int)z);
        if (Minecraft.m_91087_().m_18695_()) {
            return (LevelChunk)CHUNK_MAP.get(chunkPos);
        }
        Long2ObjectOpenHashMap<LevelChunk> long2ObjectOpenHashMap = CHUNK_MAP_OTHER_THREADS;
        synchronized (long2ObjectOpenHashMap) {
            return (LevelChunk)CHUNK_MAP_OTHER_THREADS.get(chunkPos);
        }
    }

    public static LevelChunk replaceWithPacketData(ClientLevel level, int x, int z, FriendlyByteBuf packetData, CompoundTag chunkTag, Consumer<ClientboundLevelChunkPacketData.BlockEntityTagOutput> tagOutput) {
        if (!Minecraft.m_91087_().m_18695_()) {
            throw new UnsupportedOperationException("replaceWithPacketData called off-thread, this shouldn't happen!");
        }
        ChunkPos chunkPos = new ChunkPos(x, z);
        long longChunkPos = chunkPos.m_45588_();
        LevelChunk chunk = (LevelChunk)CHUNK_MAP.get(longChunkPos);
        if (chunk == null) {
            LevelChunk newChunk;
            chunk = newChunk = new LevelChunk((Level)level, chunkPos);
            chunk.m_187971_(packetData, chunkTag, tagOutput);
            CameraClientChunkCacheExtension.modifyChunkMaps(map -> map.put(longChunkPos, (Object)newChunk));
        }
        level.m_171649_(chunkPos);
        if (SecurityCraft.IS_A_SODIUM_MOD_INSTALLED) {
            SodiumCompat.onChunkStatusAdded(level, x, z);
        }
        MinecraftForge.EVENT_BUS.post((Event)new ChunkEvent.Load((ChunkAccess)chunk, false));
        return chunk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void modifyChunkMaps(Consumer<Long2ObjectOpenHashMap<LevelChunk>> operation) {
        operation.accept(CHUNK_MAP);
        Long2ObjectOpenHashMap<LevelChunk> long2ObjectOpenHashMap = CHUNK_MAP_OTHER_THREADS;
        synchronized (long2ObjectOpenHashMap) {
            operation.accept(CHUNK_MAP_OTHER_THREADS);
        }
    }

    public static void clear() {
        CHUNK_MAP.clear();
        CHUNK_MAP_OTHER_THREADS.clear();
    }
}

