/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.blockentities.ReinforcedDropperBlockEntity;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedDispenserBlock;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.BlockSourceImpl;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.VanillaInventoryCodeHooks;

public class ReinforcedDropperBlock
extends ReinforcedDispenserBlock {
    private static final DispenseItemBehavior DISPENSE_BEHAVIOUR = new DefaultDispenseItemBehavior();

    public ReinforcedDropperBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public float m_5880_(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        return BlockUtils.getDestroyProgress((x$0, x$1, x$2, x$3) -> super.m_5880_(x$0, x$1, x$2, x$3), state, player, level, pos);
    }

    @Override
    public boolean canHarvestBlock(BlockState state, BlockGetter level, BlockPos pos, Player player) {
        return (Boolean)ConfigHandler.SERVER.alwaysDrop.get() != false || super.canHarvestBlock(state, level, pos, player);
    }

    public DispenseItemBehavior m_7216_(ItemStack stack) {
        return DISPENSE_BEHAVIOUR;
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ReinforcedDropperBlockEntity(pos, state);
    }

    @Override
    protected void m_5824_(ServerLevel level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ReinforcedDropperBlockEntity) {
            ReinforcedDropperBlockEntity be = (ReinforcedDropperBlockEntity)blockEntity;
            BlockSourceImpl source = new BlockSourceImpl(level, pos);
            int randomSlot = be.m_222761_(level.f_46441_);
            if (randomSlot < 0) {
                level.m_46796_(1001, pos, 0);
            } else {
                ItemStack dispenseStack = be.m_8020_(randomSlot);
                if (!dispenseStack.m_41619_() && VanillaInventoryCodeHooks.dropperInsertHook((Level)level, (BlockPos)pos, (DispenserBlockEntity)be, (int)randomSlot, (ItemStack)dispenseStack)) {
                    ItemStack afterDispenseStack;
                    Direction direction = (Direction)level.m_8055_(pos).m_61143_((Property)f_52659_);
                    Container container = HopperBlockEntity.m_59390_((Level)level, (BlockPos)pos.m_121945_(direction));
                    if (container == null) {
                        afterDispenseStack = DISPENSE_BEHAVIOUR.m_6115_((BlockSource)source, dispenseStack);
                    } else {
                        afterDispenseStack = HopperBlockEntity.m_59326_((Container)be, (Container)container, (ItemStack)dispenseStack.m_41777_().m_41620_(1), (Direction)direction.m_122424_());
                        if (afterDispenseStack.m_41619_()) {
                            afterDispenseStack = dispenseStack.m_41777_();
                            afterDispenseStack.m_41774_(1);
                        } else {
                            afterDispenseStack = dispenseStack.m_41777_();
                        }
                    }
                    be.m_6836_(randomSlot, afterDispenseStack);
                }
            }
        }
    }

    @Override
    public Block getVanillaBlock() {
        return Blocks.f_50286_;
    }
}

