/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.OwnableBlockEntity;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blockentities.ReinforcedDoorBlockEntity;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ReinforcedDoorBlock
extends OwnableBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    public static final EnumProperty<DoorHingeSide> HINGE = BlockStateProperties.f_61394_;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    protected static final VoxelShape SOUTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    protected static final VoxelShape NORTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_AABB = Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);

    public ReinforcedDoorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_(HINGE, (Comparable)DoorHingeSide.LEFT)).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        boolean isNotOpen = (Boolean)state.m_61143_((Property)OPEN) == false;
        boolean isHingeRight = state.m_61143_(HINGE) == DoorHingeSide.RIGHT;
        return switch (facing) {
            case Direction.EAST -> {
                if (isNotOpen) {
                    yield EAST_AABB;
                }
                if (isHingeRight) {
                    yield NORTH_AABB;
                }
                yield SOUTH_AABB;
            }
            case Direction.SOUTH -> {
                if (isNotOpen) {
                    yield SOUTH_AABB;
                }
                if (isHingeRight) {
                    yield EAST_AABB;
                }
                yield WEST_AABB;
            }
            case Direction.WEST -> {
                if (isNotOpen) {
                    yield WEST_AABB;
                }
                if (isHingeRight) {
                    yield SOUTH_AABB;
                }
                yield NORTH_AABB;
            }
            case Direction.NORTH -> {
                if (isNotOpen) {
                    yield NORTH_AABB;
                }
                if (isHingeRight) {
                    yield WEST_AABB;
                }
                yield EAST_AABB;
            }
            default -> isNotOpen ? EAST_AABB : (isHingeRight ? NORTH_AABB : SOUTH_AABB);
        };
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        DoubleBlockHalf doorHalf = (DoubleBlockHalf)state.m_61143_(HALF);
        if (facing.m_122434_() == Direction.Axis.Y && doorHalf == DoubleBlockHalf.LOWER == (facing == Direction.UP)) {
            return facingState.m_60734_() == this && facingState.m_61143_(HALF) != doorHalf ? (BlockState)((BlockState)((BlockState)state.m_61124_((Property)FACING, (Comparable)((Direction)facingState.m_61143_((Property)FACING)))).m_61124_((Property)OPEN, (Comparable)((Boolean)facingState.m_61143_((Property)OPEN)))).m_61124_(HINGE, (Comparable)((DoorHingeSide)facingState.m_61143_(HINGE))) : Blocks.f_50016_.m_49966_();
        }
        return doorHalf == DoubleBlockHalf.LOWER && facing == Direction.DOWN && !state.m_60710_((LevelReader)level, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    public void m_6240_(Level level, Player player, BlockPos pos, BlockState state, BlockEntity be, ItemStack stack) {
        super.m_6240_(level, player, pos, Blocks.f_50016_.m_49966_(), be, stack);
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockPos posBelow;
        BlockState stateBelow;
        DoubleBlockHalf doorHalf;
        if (!level.f_46443_ && player.m_7500_() && (doorHalf = (DoubleBlockHalf)state.m_61143_(HALF)) == DoubleBlockHalf.UPPER && (stateBelow = level.m_8055_(posBelow = pos.m_7495_())).m_60734_() == state.m_60734_() && stateBelow.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            level.m_7731_(posBelow, Blocks.f_50016_.m_49966_(), 35);
            level.m_5898_(player, 2001, posBelow, Block.m_49956_((BlockState)stateBelow));
        }
        super.m_5707_(level, pos, state, player);
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return switch (type) {
            case PathComputationType.LAND -> (Boolean)state.m_61143_((Property)OPEN);
            case PathComputationType.AIR -> (Boolean)state.m_61143_((Property)OPEN);
            default -> false;
        };
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        Level level = context.m_43725_();
        if (pos.m_123342_() < level.m_151558_() - 1 && level.m_8055_(pos.m_7494_()).m_60629_(context)) {
            boolean hasActiveSCBlock = BlockUtils.hasActiveSCBlockNextTo(level, pos) || BlockUtils.hasActiveSCBlockNextTo(level, pos.m_7494_());
            return (BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_())).m_61124_(HINGE, (Comparable)this.getHingeSide(context))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(hasActiveSCBlock))).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER);
        }
        return null;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean flag) {
        this.onNeighborChanged(level, pos, fromPos);
    }

    @Override
    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        level.m_7731_(pos.m_7494_(), (BlockState)state.m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    private DoorHingeSide getHingeSide(BlockPlaceContext ctx) {
        boolean isCWLower;
        Level level = ctx.m_43725_();
        BlockPos clickedPos = ctx.m_8083_();
        Direction horizontalDirection = ctx.m_8125_();
        BlockPos posAbove = clickedPos.m_7494_();
        Direction horizontalCCW = horizontalDirection.m_122428_();
        BlockPos clickedPosCCW = clickedPos.m_121945_(horizontalCCW);
        BlockState stateCCW = level.m_8055_(clickedPosCCW);
        BlockPos posAboveCCW = posAbove.m_121945_(horizontalCCW);
        BlockState stateAboveCCW = level.m_8055_(posAboveCCW);
        Direction horizontalCW = horizontalDirection.m_122427_();
        BlockPos clickedPosCW = clickedPos.m_121945_(horizontalCW);
        BlockState stateCW = level.m_8055_(clickedPosCW);
        BlockPos posAboveCW = posAbove.m_121945_(horizontalCW);
        BlockState stateAboveCW = level.m_8055_(posAboveCW);
        int i = (stateCCW.m_60838_((BlockGetter)level, clickedPosCCW) ? -1 : 0) + (stateAboveCCW.m_60838_((BlockGetter)level, posAboveCCW) ? -1 : 0) + (stateCW.m_60838_((BlockGetter)level, clickedPosCW) ? 1 : 0) + (stateAboveCW.m_60838_((BlockGetter)level, posAboveCW) ? 1 : 0);
        boolean isCCWLower = stateCCW.m_60734_() == this && stateCCW.m_61143_(HALF) == DoubleBlockHalf.LOWER;
        boolean bl = isCWLower = stateCW.m_60734_() == this && stateCW.m_61143_(HALF) == DoubleBlockHalf.LOWER;
        if ((!isCCWLower || isCWLower) && i <= 0) {
            if ((!isCWLower || isCCWLower) && i >= 0) {
                int stepX = horizontalDirection.m_122429_();
                int stepY = horizontalDirection.m_122431_();
                Vec3 clickLocation = ctx.m_43720_();
                double clickedX = clickLocation.f_82479_ - (double)clickedPos.m_123341_();
                double clickedY = clickLocation.f_82481_ - (double)clickedPos.m_123343_();
                return !(stepX < 0 && !(clickedY >= 0.5) || stepX > 0 && !(clickedY <= 0.5) || stepY < 0 && !(clickedX <= 0.5) || stepY > 0 && !(clickedX >= 0.5)) ? DoorHingeSide.LEFT : DoorHingeSide.RIGHT;
            }
            return DoorHingeSide.LEFT;
        }
        return DoorHingeSide.RIGHT;
    }

    public void onNeighborChanged(Level level, BlockPos firstDoorPos, BlockPos neighbor) {
        BlockEntity blockEntity;
        BlockState firstDoorState = level.m_8055_(firstDoorPos);
        Block neighborBlock = level.m_8055_(neighbor).m_60734_();
        Owner previousOwner = null;
        BlockEntity blockEntity2 = level.m_7702_(firstDoorPos);
        if (blockEntity2 instanceof OwnableBlockEntity) {
            OwnableBlockEntity ownable = (OwnableBlockEntity)blockEntity2;
            previousOwner = ownable.getOwner();
        }
        if (firstDoorState.m_61143_(HALF) == DoubleBlockHalf.UPPER) {
            BlockPos blockBelow = firstDoorPos.m_7495_();
            BlockState stateBelow = level.m_8055_(blockBelow);
            if (stateBelow.m_60734_() != this) {
                level.m_46961_(firstDoorPos, false);
            } else if (neighborBlock != this) {
                this.onNeighborChanged(level, blockBelow, neighbor);
            }
        } else {
            boolean drop = false;
            BlockPos blockAbove = firstDoorPos.m_7494_();
            BlockState stateAbove = level.m_8055_(blockAbove);
            if (stateAbove.m_60734_() != this) {
                level.m_46961_(firstDoorPos, false);
                drop = true;
            }
            if (!BlockUtils.isSideSolid((LevelReader)level, firstDoorPos.m_7495_(), Direction.UP)) {
                level.m_46961_(firstDoorPos, false);
                drop = true;
                if (stateAbove.m_60734_() == this) {
                    level.m_46961_(firstDoorPos, false);
                }
            }
            if (drop) {
                if (!level.f_46443_) {
                    level.m_46961_(firstDoorPos, false);
                    Block.m_49840_((Level)level, (BlockPos)firstDoorPos, (ItemStack)new ItemStack((ItemLike)SCContent.REINFORCED_DOOR_ITEM.get()));
                }
            } else if (neighborBlock != this) {
                boolean shouldBeOpen;
                boolean hasActiveSCBlock = BlockUtils.hasActiveSCBlockNextTo(level, firstDoorPos) || BlockUtils.hasActiveSCBlockNextTo(level, firstDoorPos.m_7494_());
                Direction directionToCheck = ((Direction)firstDoorState.m_61143_((Property)FACING)).m_122427_();
                BlockPos secondDoorPos = firstDoorPos.m_121945_(directionToCheck);
                BlockState secondDoorState = level.m_8055_(secondDoorPos);
                if (!(secondDoorState != null && secondDoorState.m_60734_() == SCContent.REINFORCED_DOOR.get() && secondDoorState.m_61143_(HINGE) == DoorHingeSide.RIGHT && firstDoorState.m_61143_(HINGE) != secondDoorState.m_61143_(HINGE) || (secondDoorState = level.m_8055_(secondDoorPos = firstDoorPos.m_121945_(directionToCheck.m_122424_()))) != null && secondDoorState.m_60734_() == SCContent.REINFORCED_DOOR.get() && secondDoorState.m_61143_(HINGE) == DoorHingeSide.LEFT && firstDoorState.m_61143_(HINGE) != secondDoorState.m_61143_(HINGE))) {
                    secondDoorPos = null;
                }
                boolean hasSecondDoorActiveSCBlock = secondDoorPos != null && (BlockUtils.hasActiveSCBlockNextTo(level, secondDoorPos) || BlockUtils.hasActiveSCBlockNextTo(level, secondDoorPos.m_7494_()));
                boolean bl = shouldBeOpen = hasActiveSCBlock != hasSecondDoorActiveSCBlock || hasActiveSCBlock;
                if (shouldBeOpen != (Boolean)firstDoorState.m_61143_((Property)OPEN)) {
                    this.setDoorState(level, firstDoorPos, firstDoorState, shouldBeOpen);
                }
                if (secondDoorPos != null && shouldBeOpen != (Boolean)secondDoorState.m_61143_((Property)OPEN)) {
                    this.setDoorState(level, secondDoorPos, secondDoorState, shouldBeOpen);
                }
            }
        }
        if (previousOwner != null && (blockEntity = level.m_7702_(firstDoorPos)) instanceof OwnableBlockEntity) {
            OwnableBlockEntity thisBe = (OwnableBlockEntity)blockEntity;
            blockEntity = level.m_7702_(firstDoorPos.m_7494_());
            if (blockEntity instanceof OwnableBlockEntity) {
                OwnableBlockEntity aboveBe = (OwnableBlockEntity)blockEntity;
                thisBe.setOwner(previousOwner.getUUID(), previousOwner.getName());
                aboveBe.setOwner(previousOwner.getUUID(), previousOwner.getName());
            }
        }
    }

    public void setDoorState(Level level, BlockPos pos, BlockState state, boolean open) {
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(open)), 2);
        level.m_5594_(null, pos, open ? SoundEvents.f_12056_ : SoundEvents.f_12055_, SoundSource.BLOCKS, 1.0f, 1.0f);
        level.m_142346_(null, open ? GameEvent.f_157796_ : GameEvent.f_157793_, pos);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos posBelow = pos.m_7495_();
        BlockState stateBelow = level.m_8055_(posBelow);
        if (state.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            return stateBelow.m_60783_((BlockGetter)level, posBelow, Direction.UP);
        }
        return stateBelow.m_60713_((Block)this);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return mirror == Mirror.NONE ? state : (BlockState)state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING))).m_61122_(HINGE);
    }

    public long m_7799_(BlockState state, BlockPos pos) {
        return Mth.m_14130_((int)pos.m_123341_(), (int)pos.m_6625_(state.m_61143_(HALF) == DoubleBlockHalf.LOWER ? 0 : 1).m_123342_(), (int)pos.m_123343_());
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)SCContent.REINFORCED_DOOR_ITEM.get());
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ReinforcedDoorBlockEntity(pos, state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HALF, FACING, OPEN, HINGE});
    }
}

