/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.CustomizableBlockEntity;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.mines.BouncingBettyBlock;
import net.geforcemods.securitycraft.blocks.mines.IMSBlock;
import net.geforcemods.securitycraft.entity.IMSBomb;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.TargetingMode;
import net.geforcemods.securitycraft.util.ITickingBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.ForgeCapabilities;

public class IMSBlockEntity
extends CustomizableBlockEntity
implements ITickingBlockEntity {
    private Option.IntOption range = new Option.IntOption("range", 15, 1, 30, 1);
    private Option.DisabledOption disabled = new Option.DisabledOption(false);
    private Option.IgnoreOwnerOption ignoreOwner = new Option.IgnoreOwnerOption(true);
    private Option.TargetingModeOption targetingMode = new Option.TargetingModeOption(TargetingMode.PLAYERS_AND_MOBS);
    private Option.RespectInvisibilityOption respectInvisibility = new Option.RespectInvisibilityOption();
    private int bombsRemaining = 4;
    private boolean updateBombCount = false;
    private int attackTime = this.getAttackInterval();

    public IMSBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.IMS_BLOCK_ENTITY.get(), pos, state);
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state) {
        if (!level.f_46443_ && this.updateBombCount) {
            int mineCount = (Integer)state.m_61143_((Property)IMSBlock.MINES);
            if (mineCount != this.bombsRemaining) {
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)IMSBlock.MINES, (Comparable)Integer.valueOf(this.bombsRemaining)));
            }
            if (this.bombsRemaining < 4) {
                BlockEntity be = level.m_7702_(pos.m_7495_());
                if (be != null) {
                    be.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.UP).ifPresent(handler -> {
                        for (int i = 0; i < handler.getSlots(); ++i) {
                            if (handler.getStackInSlot(i).m_41720_() != ((BouncingBettyBlock)SCContent.BOUNCING_BETTY.get()).m_5456_()) continue;
                            handler.extractItem(i, 1, false);
                            ++this.bombsRemaining;
                            return;
                        }
                    });
                }
            } else {
                this.updateBombCount = false;
            }
        }
        if (!this.isDisabled() && this.attackTime-- == 0) {
            this.attackTime = this.getAttackInterval();
            this.launchMine(level, pos);
        }
    }

    private void launchMine(Level level, BlockPos pos) {
        if (this.bombsRemaining > 0) {
            AABB area = new AABB(pos).m_82400_((double)((Integer)this.range.get()).intValue());
            TargetingMode mode = this.getTargetingMode();
            level.m_6443_(LivingEntity.class, area, e -> {
                if (!(e instanceof Player)) {
                    if (!(e instanceof Monster)) return false;
                }
                if (!mode.canAttackEntity((LivingEntity)e, this, this.respectInvisibility::isConsideredInvisible)) return false;
                return true;
            }).stream().findFirst().ifPresent(e -> {
                double addToX = this.bombsRemaining == 4 || this.bombsRemaining == 3 ? 0.84375 : 0.0;
                double addToZ = this.bombsRemaining == 4 || this.bombsRemaining == 2 ? 0.84375 : 0.0;
                int launchHeight = this.getLaunchHeight();
                double accelerationX = e.m_20185_() - (double)pos.m_123341_();
                double accelerationY = e.m_20191_().f_82289_ + (double)(e.m_20206_() / 2.0f) - (double)pos.m_123342_() - (double)launchHeight;
                double accelerationZ = e.m_20189_() - (double)pos.m_123343_();
                if (!level.f_46443_) {
                    level.m_7967_((Entity)new IMSBomb(level, (double)pos.m_123341_() + addToX, pos.m_123342_(), (double)pos.m_123343_() + addToZ, accelerationX, accelerationY, accelerationZ, launchHeight, this));
                    level.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                --this.bombsRemaining;
                this.updateBombCount = true;
                this.m_6596_();
            });
        }
    }

    private int getLaunchHeight() {
        BlockState state;
        int height;
        for (height = 1; height <= 9 && ((state = this.m_58904_().m_8055_(this.m_58899_().m_6630_(height))) == null || state.m_60795_()); ++height) {
        }
        return height;
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("bombsRemaining", this.bombsRemaining);
        tag.m_128379_("updateBombCount", this.updateBombCount);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.bombsRemaining = tag.m_128451_("bombsRemaining");
        this.updateBombCount = tag.m_128471_("updateBombCount");
        if (tag.m_128441_("targetingOption")) {
            this.targetingMode.setValue(TargetingMode.values()[tag.m_128451_("targetingOption")]);
        }
    }

    public void setBombsRemaining(int bombsRemaining) {
        this.bombsRemaining = bombsRemaining;
        this.m_6596_();
    }

    public TargetingMode getTargetingMode() {
        return (TargetingMode)((Object)this.targetingMode.get());
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.SPEED};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.range, this.disabled, this.ignoreOwner, this.targetingMode, this.respectInvisibility};
    }

    public int getAttackInterval() {
        return this.isModuleEnabled(ModuleType.SPEED) ? 40 : 80;
    }

    public boolean isDisabled() {
        return (Boolean)this.disabled.get();
    }

    @Override
    public boolean ignoresOwner() {
        return (Boolean)this.ignoreOwner.get();
    }
}

