/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.blockentities.BlockChangeDetectorBlockEntity;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.geforcemods.securitycraft.entity.camera.CameraViewAreaExtension;
import net.geforcemods.securitycraft.misc.BlockEntityTracker;
import net.geforcemods.securitycraft.misc.CameraRedstoneModuleState;
import net.geforcemods.securitycraft.misc.KeyBindings;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="securitycraft", value={Dist.CLIENT})
public class SCClientEventHandler {
    public static final ResourceLocation CAMERA_DASHBOARD = new ResourceLocation("securitycraft:textures/gui/camera/camera_dashboard.png");
    public static final ResourceLocation BEACON_GUI = new ResourceLocation("textures/gui/container/beacon.png");
    public static final ResourceLocation NIGHT_VISION = new ResourceLocation("textures/mob_effect/night_vision.png");
    public static final ItemStack REDSTONE = new ItemStack((ItemLike)Items.f_42451_);
    private static final Component REDSTONE_NOTE = Utils.localize("gui.securitycraft:camera.toggleRedstoneNote", new Object[0]);
    private static final Component SMART_MODULE_NOTE = Utils.localize("gui.securitycraft:camera.smartModuleNote", new Object[0]);
    private static final CameraKeyInfoEntry[] CAMERA_KEY_INFO_LIST;
    private static float cameraInfoMessageTime;

    private SCClientEventHandler() {
    }

    @SubscribeEvent
    public static void onClientTickPost(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && cameraInfoMessageTime >= 0.0f) {
            cameraInfoMessageTime -= 1.0f;
        }
    }

    @SubscribeEvent
    public static void onRenderLevelStage(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_TRIPWIRE_BLOCKS) {
            Vec3 camPos = event.getCamera().m_90583_();
            PoseStack pose = event.getPoseStack();
            Minecraft mc = Minecraft.m_91087_();
            ClientLevel level = mc.f_91073_;
            for (BlockPos bcdPos : BlockEntityTracker.BLOCK_CHANGE_DETECTOR.getTrackedBlockEntities((Level)level)) {
                BlockChangeDetectorBlockEntity bcd;
                BlockEntity be = level.m_7702_(bcdPos);
                if (!(be instanceof BlockChangeDetectorBlockEntity) || !(bcd = (BlockChangeDetectorBlockEntity)be).isShowingHighlights() || !bcd.isOwnedBy((Entity)mc.f_91074_)) continue;
                int packedColor = bcd.getColor();
                float r = (float)FastColor.ARGB32.m_13665_((int)packedColor) / 255.0f;
                float g = (float)FastColor.ARGB32.m_13667_((int)packedColor) / 255.0f;
                float b = (float)FastColor.ARGB32.m_13669_((int)packedColor) / 255.0f;
                for (BlockChangeDetectorBlockEntity.ChangeEntry changeEntry : bcd.getFilteredEntries()) {
                    BlockPos pos = changeEntry.pos();
                    pose.m_85836_();
                    pose.m_85837_((double)pos.m_123341_() - camPos.f_82479_, (double)pos.m_123342_() - camPos.f_82480_, (double)pos.m_123343_() - camPos.f_82481_);
                    LevelRenderer.m_109608_((PoseStack)pose, (VertexConsumer)BCDBuffer.INSTANCE.m_6299_(RenderType.m_110504_()), (double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0, (float)r, (float)g, (float)b, (float)1.0f);
                    pose.m_85849_();
                }
            }
            mc.m_91269_().m_110104_().m_109911_();
        }
    }

    @SubscribeEvent
    public static void renderHandEvent(RenderHandEvent event) {
        if (ClientHandler.isPlayerMountedOnCamera()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onClickInput(InputEvent.InteractionKeyMappingTriggered event) {
        if (ClientHandler.isPlayerMountedOnCamera()) {
            Minecraft mc = Minecraft.m_91087_();
            InteractionHand hand = event.getHand();
            if (mc.f_91074_.m_21120_(hand).m_150930_((Item)SCContent.CAMERA_MONITOR.get()) && event.isUseItem()) {
                ((Item)SCContent.CAMERA_MONITOR.get()).m_7203_((Level)mc.f_91073_, (Player)mc.f_91074_, hand);
            }
            event.setCanceled(true);
            event.setSwingHand(false);
        }
    }

    @SubscribeEvent
    public static void onChunkUnload(ChunkEvent.Unload event) {
        if (event.getLevel().m_5776_()) {
            ChunkPos pos = event.getChunk().m_7697_();
            CameraViewAreaExtension.onChunkUnload(pos.f_45578_, pos.f_45579_);
        }
    }

    public static void cameraOverlay(ForgeGui gui, GuiGraphics guiGraphics, float partialTicks, int width, int height) {
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel level = mc.f_91073_;
        BlockPos pos = mc.f_91075_.m_20183_();
        Window window = mc.m_91268_();
        int scaledWidth = window.m_85445_();
        int scaledHeight = window.m_85446_();
        if (mc.f_91066_.f_92063_) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof SecurityCameraBlockEntity)) {
            return;
        }
        SecurityCameraBlockEntity be = (SecurityCameraBlockEntity)blockEntity;
        Font font = Minecraft.m_91087_().f_91062_;
        Options options = Minecraft.m_91087_().f_91066_;
        BlockState state = level.m_8055_(pos);
        long dayTime = Minecraft.m_91087_().f_91073_.m_46468_();
        int hours24 = (int)((float)dayTime / 1000.0f + 6.0f) % 24;
        int hours = hours24 % 12;
        int minutes = (int)((float)dayTime / 16.666666f % 60.0f);
        String time = String.format("%02d:%02d %s", hours < 1 ? 12 : hours, minutes, hours24 < 12 ? "AM" : "PM");
        int timeY = 25;
        if (be.m_8077_()) {
            Component cameraName = be.m_7770_();
            guiGraphics.m_280614_(font, cameraName, scaledWidth - font.m_92852_((FormattedText)cameraName) - 8, 25, 0xFFFFFF, true);
            timeY += 10;
        }
        guiGraphics.m_280056_(font, time, scaledWidth - font.m_92895_(time) - 4, timeY, 0xFFFFFF, true);
        if (cameraInfoMessageTime >= 0.0f) {
            float fadeOutPartialTick = Math.max(cameraInfoMessageTime + 1.0f - partialTicks, 1.0f);
            int alpha = (int)Math.ceil(255.0f * Math.min(20.0f, fadeOutPartialTick) / 20.0f);
            int heightOffset = 10;
            for (int i = CAMERA_KEY_INFO_LIST.length - 1; i >= 0; --i) {
                CameraKeyInfoEntry entry = CAMERA_KEY_INFO_LIST[i];
                if (!entry.enabled().get().booleanValue()) continue;
                entry.drawString(options, guiGraphics, font, scaledWidth, scaledHeight, heightOffset, be, alpha);
                heightOffset += 10;
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280218_(CAMERA_DASHBOARD, 5, 0, 0, 0, 90, 20);
        guiGraphics.m_280218_(CAMERA_DASHBOARD, window.m_85445_() - 70, 5, 190, 0, 65, 30);
        if (!mc.f_91074_.m_21023_(MobEffects.f_19611_)) {
            guiGraphics.m_280218_(CAMERA_DASHBOARD, 28, 4, 90, 12, 16, 11);
        } else {
            guiGraphics.m_280163_(NIGHT_VISION, 27, -1, 0.0f, 0.0f, 18, 18, 18, 18);
        }
        if (state.m_60746_((BlockGetter)level, pos, (Direction)state.m_61143_((Property)SecurityCameraBlock.FACING)) == 0) {
            if (!be.isModuleEnabled(ModuleType.REDSTONE)) {
                CameraRedstoneModuleState.NOT_INSTALLED.render(guiGraphics, 12, 2);
            } else {
                CameraRedstoneModuleState.DEACTIVATED.render(guiGraphics, 12, 2);
            }
        } else {
            CameraRedstoneModuleState.ACTIVATED.render(guiGraphics, 12, 2);
        }
    }

    public static void resetCameraInfoMessageTime() {
        cameraInfoMessageTime = 200.0f;
    }

    static {
        CameraKeyInfoEntry[] cameraKeyInfoEntryArray = new CameraKeyInfoEntry[8];
        cameraKeyInfoEntryArray[0] = new CameraKeyInfoEntry(() -> true, options -> Utils.localize("gui.securitycraft:camera.lookAround", options.f_92085_.m_90863_(), options.f_92086_.m_90863_(), options.f_92087_.m_90863_(), options.f_92088_.m_90863_()), $ -> true);
        cameraKeyInfoEntryArray[1] = new CameraKeyInfoEntry(() -> true, options -> Utils.localize("gui.securitycraft:camera.exit", options.f_92090_.m_90863_()), $ -> true);
        cameraKeyInfoEntryArray[2] = new CameraKeyInfoEntry(() -> true, $ -> Utils.localize("gui.securitycraft:camera.zoom", KeyBindings.cameraZoomIn.m_90863_(), KeyBindings.cameraZoomOut.m_90863_()), $ -> true);
        cameraKeyInfoEntryArray[3] = new CameraKeyInfoEntry(() -> ((ForgeConfigSpec.BooleanValue)ConfigHandler.SERVER.allowCameraNightVision).get(), $ -> Utils.localize("gui.securitycraft:camera.activateNightVision", KeyBindings.cameraActivateNightVision.m_90863_()), $ -> true);
        cameraKeyInfoEntryArray[4] = new CameraKeyInfoEntry(() -> true, $ -> Utils.localize("gui.securitycraft:camera.toggleRedstone", KeyBindings.cameraEmitRedstone.m_90863_()), be -> be.isModuleEnabled(ModuleType.REDSTONE));
        cameraKeyInfoEntryArray[5] = new CameraKeyInfoEntry(() -> true, $ -> REDSTONE_NOTE, be -> be.isModuleEnabled(ModuleType.REDSTONE));
        cameraKeyInfoEntryArray[6] = new CameraKeyInfoEntry(() -> true, $ -> Utils.localize("gui.securitycraft:camera.setDefaultViewingDirection", KeyBindings.setDefaultViewingDirection.m_90863_()), be -> be.isModuleEnabled(ModuleType.SMART));
        cameraKeyInfoEntryArray[7] = new CameraKeyInfoEntry(() -> true, $ -> SMART_MODULE_NOTE, be -> be.isModuleEnabled(ModuleType.SMART));
        CAMERA_KEY_INFO_LIST = cameraKeyInfoEntryArray;
    }

    private static enum BCDBuffer implements MultiBufferSource
    {
        INSTANCE;

        private final RenderType overlayLines = new OverlayLines(RenderType.m_110504_());

        public VertexConsumer m_6299_(RenderType renderType) {
            return Minecraft.m_91087_().m_91269_().m_110104_().m_6299_(this.overlayLines);
        }

        private static class OverlayLines
        extends RenderType {
            private final RenderType normalLines;

            private OverlayLines(RenderType normalLines) {
                super("overlay_lines", normalLines.m_110508_(), normalLines.m_173186_(), normalLines.m_110507_(), normalLines.m_110405_(), normalLines.f_110393_, () -> ((RenderType)normalLines).m_110185_(), () -> ((RenderType)normalLines).m_110188_());
                this.normalLines = normalLines;
            }

            public void m_110185_() {
                this.normalLines.m_110185_();
                RenderTarget renderTarget = Minecraft.m_91087_().f_91060_.m_109827_();
                if (renderTarget != null) {
                    renderTarget.m_83947_(false);
                }
            }

            public void m_110188_() {
                Minecraft.m_91087_().m_91385_().m_83947_(false);
                this.normalLines.m_110188_();
            }
        }
    }

    public record CameraKeyInfoEntry(Supplier<Boolean> enabled, Function<Options, Component> text, Predicate<SecurityCameraBlockEntity> whiteText) {
        public void drawString(Options options, GuiGraphics guiGraphics, Font font, int scaledWidth, int scaledHeight, int heightOffset, SecurityCameraBlockEntity be, int alpha) {
            Component text = this.text().apply(options);
            int textColor = this.whiteText().test(be) ? 0xFFFFFF : 0xFF3377;
            guiGraphics.m_280614_(font, text, scaledWidth - font.m_92852_((FormattedText)text) - 8, scaledHeight - heightOffset, textColor + (alpha << 24), true);
        }
    }
}

