/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.mtrscripting.util;

import com.lx862.jcm.mapping.LoaderImpl;
import com.mojang.text2speech.Narrator;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.ClientPlayerEntity;
import org.mtr.mapping.holder.ClientWorld;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.Text;
import org.mtr.mapping.holder.Vector3f;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mapping.mapper.WorldHelper;
import org.mtr.mapping.tool.HolderBase;

public class MinecraftClientUtil {
    public static boolean worldIsRaining() {
        return MinecraftClient.getInstance().getWorldMapped() != null && MinecraftClient.getInstance().getWorldMapped().isRaining();
    }

    public static boolean worldIsThundering() {
        return MinecraftClient.getInstance().getWorldMapped() != null && MinecraftClient.getInstance().getWorldMapped().isThundering();
    }

    public static boolean worldIsRainingAt(Vector3f pos) {
        return MinecraftClient.getInstance().getWorldMapped() != null && LoaderImpl.isRainingAt(World.cast((HolderBase)MinecraftClient.getInstance().getWorldMapped()), new BlockPos((int)pos.getX(), (int)pos.getY(), (int)pos.getZ()));
    }

    public static int worldDayTime() {
        return MinecraftClient.getInstance().getWorldMapped() != null ? (int)WorldHelper.getTimeOfDay((ClientWorld)MinecraftClient.getInstance().getWorldMapped()) : 0;
    }

    public static boolean isEmittingRedstonePower(BlockPos pos) {
        for (Direction direction : Direction.values()) {
            if (!MinecraftClientUtil.isEmittingRedstonePower(pos, direction)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmittingRedstonePower(BlockPos pos, Direction direction) {
        return MinecraftClient.getInstance().getWorldMapped() != null && MinecraftClient.getInstance().getWorldMapped().isEmittingRedstonePower(pos, direction);
    }

    public static void narrate(String message) {
        MinecraftClient.getInstance().execute(() -> Narrator.getNarrator().say(message, true));
    }

    public static void displayMessage(String message, boolean actionBar) {
        ClientPlayerEntity player = MinecraftClient.getInstance().getPlayerMapped();
        if (player != null) {
            MinecraftClient.getInstance().execute(() -> player.sendMessage(Text.cast((HolderBase)TextHelper.literal((String)message)), actionBar));
        }
    }
}

