/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.mtrscripting.core;

import com.lx862.mtrscripting.ScriptManager;
import com.lx862.mtrscripting.core.ScriptInstance;
import com.lx862.mtrscripting.data.ScriptContent;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.Context;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.Function;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.ImporterTopLevel;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.NativeJavaClass;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.NativeJavaMethod;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.Scriptable;
import com.lx862.mtrscripting.util.CycleTracker;
import com.lx862.mtrscripting.util.FilesUtil;
import com.lx862.mtrscripting.util.GraphicsTexture;
import com.lx862.mtrscripting.util.Matrices;
import com.lx862.mtrscripting.util.MinecraftClientUtil;
import com.lx862.mtrscripting.util.NetworkingUtil;
import com.lx862.mtrscripting.util.RateLimit;
import com.lx862.mtrscripting.util.ScriptResourceUtil;
import com.lx862.mtrscripting.util.StateTracker;
import com.lx862.mtrscripting.util.TimingUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import org.mtr.mapping.holder.Identifier;

public class ParsedScript {
    private static final int SCRIPT_RESET_TIME = 4000;
    private final String displayName;
    private final List<Function> createFunctions;
    private final List<Function> renderFunctions;
    private final List<Function> disposeFunctions;
    private final ScriptManager scriptManager;
    private final Scriptable scope;
    private Exception capturedScriptException = null;
    private long lastFailedTime = -1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParsedScript(ScriptManager scriptManager, String displayName, String contextName, List<ScriptContent> scripts) throws Exception {
        this.displayName = displayName;
        this.scriptManager = scriptManager;
        this.createFunctions = new ArrayList<Function>();
        this.renderFunctions = new ArrayList<Function>();
        this.disposeFunctions = new ArrayList<Function>();
        try {
            Context cx = Context.enter();
            cx.setLanguageVersion(200);
            cx.setClassShutter(scriptManager.getClassShutter());
            this.scope = new ImporterTopLevel(cx);
            this.scope.put("include", this.scope, (Object)new NativeJavaMethod(ScriptResourceUtil.class.getMethod("includeScript", Object.class), "includeScript"));
            this.scope.put("print", this.scope, (Object)new NativeJavaMethod(ScriptResourceUtil.class.getMethod("print", Object[].class), "print"));
            this.scope.put("Resources", this.scope, (Object)new NativeJavaClass(this.scope, ScriptResourceUtil.class));
            this.scope.put("GraphicsTexture", this.scope, (Object)new NativeJavaClass(this.scope, GraphicsTexture.class));
            this.scope.put("Timing", this.scope, (Object)new NativeJavaClass(this.scope, TimingUtil.class));
            this.scope.put("StateTracker", this.scope, (Object)new NativeJavaClass(this.scope, StateTracker.class));
            this.scope.put("CycleTracker", this.scope, (Object)new NativeJavaClass(this.scope, CycleTracker.class));
            this.scope.put("RateLimit", this.scope, (Object)new NativeJavaClass(this.scope, RateLimit.class));
            this.scope.put("Networking", this.scope, (Object)new NativeJavaClass(this.scope, NetworkingUtil.class));
            this.scope.put("Files", this.scope, (Object)new NativeJavaClass(this.scope, FilesUtil.class));
            this.scope.put("Matrices", this.scope, (Object)new NativeJavaClass(this.scope, Matrices.class));
            this.scope.put("MinecraftClient", this.scope, (Object)new NativeJavaClass(this.scope, MinecraftClientUtil.class));
            scriptManager.onParseScript(contextName, cx, this.scope);
            cx.evaluateString(this.scope, "\"use strict\";", "", 1, null);
            ScriptResourceUtil.activeContext = cx;
            ScriptResourceUtil.activeScope = this.scope;
            for (ScriptContent scriptEntry : scripts) {
                Identifier scriptLocation = scriptEntry.getLocation();
                String scriptContent = scriptEntry.getContent();
                ScriptResourceUtil.executeScript(cx, this.scope, scriptLocation, scriptContent);
                this.tryAndAddFunction("create", this.scope, this.createFunctions);
                this.tryAndAddFunction("render", this.scope, this.renderFunctions);
                this.tryAndAddFunction("dispose", this.scope, this.disposeFunctions);
                this.tryAndAddFunction("create" + contextName, this.scope, this.createFunctions);
                this.tryAndAddFunction("render" + contextName, this.scope, this.renderFunctions);
                this.tryAndAddFunction("dispose" + contextName, this.scope, this.disposeFunctions);
                ScriptManager.LOGGER.info("[Scripting] Loaded script: {}:{}", (Object)scriptLocation.getNamespace(), (Object)scriptLocation.getPath());
            }
        }
        finally {
            ScriptResourceUtil.activeContext = null;
            ScriptResourceUtil.activeScope = null;
            Context.exit();
        }
    }

    private void tryAndAddFunction(String name, Scriptable scope, List<Function> listToAdd) {
        Object func = scope.get(name, scope);
        if (func != Scriptable.NOT_FOUND) {
            if (func instanceof Function) {
                listToAdd.add((Function)func);
            }
            scope.delete(name);
        }
    }

    public Future<?> invokeFunctions(ScriptInstance<?> scriptInstance, List<Function> functions, Runnable finishCallback) {
        if (this.duringFailCooldown()) {
            return null;
        }
        return this.scriptManager.submitScriptTask(() -> {
            if (this.duringFailCooldown()) {
                return;
            }
            TimingUtil.prepareForScript(scriptInstance);
            try {
                Scriptable scope = this.getScope();
                Context cx = Context.enter();
                cx.setLanguageVersion(200);
                cx.setClassShutter(this.scriptManager.getClassShutter());
                if (scriptInstance.state == null) {
                    scriptInstance.state = cx.newObject(scope);
                }
                long startTime = System.nanoTime();
                for (Function func : functions) {
                    func.call(cx, scope, scope, new Object[]{scriptInstance.getScriptContext(), scriptInstance.state, scriptInstance.getWrapperObject()});
                }
                scriptInstance.setLastExecutionDurationMs(System.nanoTime() - startTime);
            }
            catch (Exception e) {
                ScriptManager.LOGGER.error("[Scripting] Error executing script {}!", (Object)this.displayName, (Object)e);
                this.lastFailedTime = System.currentTimeMillis();
                this.capturedScriptException = e;
            }
            finally {
                Context.exit();
            }
            finishCallback.run();
        });
    }

    public Future<?> invokeCreateFunctions(ScriptInstance<?> instance, Runnable finishCallback) {
        return this.invokeFunctions(instance, this.createFunctions, () -> {
            instance.setCreateFunctionInvoked();
            finishCallback.run();
        });
    }

    public void invokeRenderFunctions(ScriptInstance<?> instance, Runnable finishCallback) {
        if (instance.shouldInvalidate() || instance.scriptTask != null && !instance.scriptTask.isDone()) {
            return;
        }
        instance.scriptTask = instance.isCreateFunctionInvoked() ? this.invokeFunctions(instance, this.renderFunctions, finishCallback) : this.invokeCreateFunctions(instance, () -> {});
    }

    public void invokeDisposeFunctions(ScriptInstance<?> instance, Runnable finishCallback) {
        this.invokeFunctions(instance, this.disposeFunctions, finishCallback);
    }

    public boolean duringFailCooldown() {
        return this.lastFailedTime != -1L && System.currentTimeMillis() - this.lastFailedTime <= 4000L;
    }

    public Exception getCapturedScriptException() {
        return this.capturedScriptException;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Scriptable getScope() {
        return this.scope;
    }
}

