/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.jcm.mod.render.text;

import com.lx862.jcm.mod.render.text.TextInfo;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;

public interface MCTextHelper {
    public static Int2IntArrayMap getColorCodeMap(TextInfo textInfo) {
        String text = textInfo.getContent();
        Int2IntArrayMap colorCodeMap = new Int2IntArrayMap();
        boolean hadSectionSign = false;
        if (!MCTextHelper.haveColorCode(text)) {
            return colorCodeMap;
        }
        int trueCharCount = 0;
        for (int i = 0; i < text.length(); ++i) {
            char currentChar = text.charAt(i);
            if (hadSectionSign) {
                int decodedColor;
                int newColorCode = Character.getNumericValue(currentChar);
                if (newColorCode != -1 && (decodedColor = MCTextHelper.getColorCodeColor(newColorCode)) != -1) {
                    colorCodeMap.put(trueCharCount, decodedColor);
                }
                if (currentChar == 'r') {
                    colorCodeMap.put(i, textInfo.getTextColor());
                }
                hadSectionSign = false;
                continue;
            }
            boolean bl = hadSectionSign = currentChar == '\u00a7';
            if (hadSectionSign) continue;
            ++trueCharCount;
        }
        return colorCodeMap;
    }

    public static String removeColorCode(String text) {
        return !MCTextHelper.haveColorCode(text) ? text : text.replace("\u00a70", "").replace("\u00a71", "").replace("\u00a72", "").replace("\u00a73", "").replace("\u00a74", "").replace("\u00a75", "").replace("\u00a76", "").replace("\u00a77", "").replace("\u00a78", "").replace("\u00a79", "").replace("\u00a7a", "").replace("\u00a7b", "").replace("\u00a7c", "").replace("\u00a7d", "").replace("\u00a7e", "").replace("\u00a7f", "").replace("\u00a7r", "");
    }

    public static int getColorCodeColor(int code) {
        switch (code) {
            case 0: {
                return 0;
            }
            case 1: {
                return 170;
            }
            case 2: {
                return 43520;
            }
            case 3: {
                return 0xAAAA00;
            }
            case 4: {
                return 0xAA0000;
            }
            case 5: {
                return 0xAA00AA;
            }
            case 6: {
                return 0xFFAA00;
            }
            case 7: {
                return 0xAAAAAA;
            }
            case 8: {
                return 0x555555;
            }
            case 9: {
                return 0x5555FF;
            }
            case 10: {
                return 0x55FF55;
            }
            case 11: {
                return 0x55FFFF;
            }
            case 12: {
                return 0xFF5555;
            }
            case 13: {
                return 0xFF55FF;
            }
            case 14: {
                return 0xFFFF55;
            }
            case 15: {
                return 0xFFFFFF;
            }
        }
        return -1;
    }

    public static boolean haveColorCode(String str) {
        return str.contains("\u00a7");
    }
}

