/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.jcm.mod.render.gui;

import com.google.common.base.Splitter;
import com.lx862.jcm.mod.JCMClient;
import com.lx862.jcm.mod.data.Pair;
import com.lx862.jcm.mod.scripting.jcm.JCMScripting;
import com.lx862.jcm.mod.scripting.mtr.MTRScripting;
import com.lx862.jcm.mod.util.TextUtil;
import com.lx862.mtrscripting.core.ScriptInstance;
import com.lx862.mtrscripting.data.UniqueKey;
import com.lx862.mtrscripting.util.GraphicsTexture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.TextFormatting;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.GuiDrawing;

public class ScriptDebugOverlay {
    private static final double IDEAL_FRAMERATE = 60.0;
    private static final int COLOR_RED = -30584;
    private static final int COLOR_BLUE = -3355393;
    private static final int COLOR_YELLOW = -256;
    private static final int COLOR_WHITE = -1;

    public static void render(GraphicsHolder graphicsHolder) {
        if (!JCMClient.getConfig().debug) {
            return;
        }
        if (MinecraftClient.getInstance().getCurrentScreenMapped() != null) {
            return;
        }
        GuiDrawing guiDrawing = new GuiDrawing(graphicsHolder);
        graphicsHolder.translate(10.0, 10.0, 0.0);
        Map<String, List<Pair<UniqueKey, ScriptInstance>>> nameToInstances = ScriptDebugOverlay.getInstancesGroupedByName();
        for (Map.Entry<String, List<Pair<UniqueKey, ScriptInstance>>> group : nameToInstances.entrySet()) {
            MutableText title = TextUtil.literal(group.getKey()).formatted(TextFormatting.UNDERLINE);
            graphicsHolder.drawText(title, 0, 0, -3355393, true, 0xF000F0);
            graphicsHolder.translate(0.0, 12.0, 0.0);
            graphicsHolder.translate(10.0, 0.0, 0.0);
            int i = 0;
            for (Pair<UniqueKey, ScriptInstance> scriptInstancePair : group.getValue()) {
                String keyName = scriptInstancePair.getLeft().toString();
                ScriptInstance scriptInstance = scriptInstancePair.getRight();
                if (i >= 6) {
                    graphicsHolder.drawText(String.format("... and %d more script instance(s)", group.getValue().size() - i), 0, 0, -3355393, true, 0xF000F0);
                    graphicsHolder.translate(0.0, 10.0, 0.0);
                    break;
                }
                double executionMs = scriptInstance.getLastExecutionDurationMs();
                if (scriptInstance.getScript().duringFailCooldown()) {
                    graphicsHolder.drawText(String.format("%s FAILED", keyName), 0, 0, -30584, true, 0xF000F0);
                    for (String exLine : Splitter.fixedLength((int)60).split((CharSequence)scriptInstance.getScript().getCapturedScriptException().getMessage())) {
                        graphicsHolder.translate(0.0, 10.0, 0.0);
                        graphicsHolder.drawText(String.format(exLine, new Object[0]), 5, 0, -30584, true, 0xF000F0);
                    }
                } else {
                    graphicsHolder.drawText(String.format("%s (%.2f ms)", keyName, executionMs), 0, 0, ScriptDebugOverlay.getColor(executionMs), true, 0xF000F0);
                }
                graphicsHolder.translate(0.0, 10.0, 0.0);
                graphicsHolder.translate(10.0, 0.0, 0.0);
                ScriptDebugOverlay.drawScriptDebugInfo(graphicsHolder, guiDrawing, scriptInstance);
                graphicsHolder.translate(-10.0, 0.0, 0.0);
                ++i;
            }
            graphicsHolder.translate(-10.0, 0.0, 0.0);
        }
    }

    private static Map<String, List<Pair<UniqueKey, ScriptInstance>>> getInstancesGroupedByName() {
        List existingInstances;
        HashMap<String, List<Pair<UniqueKey, ScriptInstance>>> groupedMap = new HashMap<String, List<Pair<UniqueKey, ScriptInstance>>>();
        for (Map.Entry<UniqueKey, ScriptInstance> map : JCMScripting.getScriptManager().getInstanceManager().getInstances().entrySet()) {
            existingInstances = groupedMap.getOrDefault(map.getValue().getScript().getDisplayName(), new ArrayList());
            if (!map.getValue().shouldInvalidate()) {
                existingInstances.add(new Pair<UniqueKey, ScriptInstance>(map.getKey(), map.getValue()));
            }
            groupedMap.put(map.getValue().getScript().getDisplayName(), existingInstances);
        }
        for (Map.Entry<UniqueKey, ScriptInstance> map : MTRScripting.getScriptManager().getInstanceManager().getInstances().entrySet()) {
            existingInstances = groupedMap.getOrDefault(map.getValue().getScript().getDisplayName(), new ArrayList());
            if (!map.getValue().shouldInvalidate()) {
                existingInstances.add(new Pair<UniqueKey, ScriptInstance>(map.getKey(), map.getValue()));
            }
            groupedMap.put(map.getValue().getScript().getDisplayName(), existingInstances);
        }
        for (List instances : groupedMap.values()) {
            instances.sort((e, f) -> Double.compare(((ScriptInstance)f.getRight()).getLastExecutionDurationMs(), ((ScriptInstance)e.getRight()).getLastExecutionDurationMs()));
        }
        return groupedMap;
    }

    private static void drawScriptDebugInfo(GraphicsHolder graphicsHolder, GuiDrawing guiDrawing, ScriptInstance scriptInstance) {
        int maxTexWidth = MinecraftClient.getInstance().getWindow().getScaledWidth() - 10 - 10 - 10;
        int maxTexHeight = MinecraftClient.getInstance().getWindow().getScaledHeight() / 3;
        for (Map.Entry debugInfoEntry : scriptInstance.getScriptContext().getDebugInfo()) {
            String key = (String)debugInfoEntry.getKey();
            Object value = debugInfoEntry.getValue();
            graphicsHolder.drawText(String.format("%s: %s", key, value instanceof GraphicsTexture ? "" : value), 0, 0, -1, true, 0xF000F0);
            graphicsHolder.translate(0.0, 10.0, 0.0);
            if (!(value instanceof GraphicsTexture)) continue;
            GraphicsTexture texture = (GraphicsTexture)value;
            double scale = (double)maxTexWidth / (double)texture.width;
            int initialHeight = (int)((double)texture.height * scale);
            if (initialHeight >= maxTexHeight) {
                scale *= (double)maxTexHeight / (double)initialHeight;
            }
            int finalWidth = (int)((double)texture.width * scale);
            int finalHeight = (int)((double)texture.height * scale);
            guiDrawing.beginDrawingTexture(texture.identifier);
            guiDrawing.drawTexture(0.0, 0.0, (double)finalWidth, (double)finalHeight, 0.0f, 0.0f, 1.0f, 1.0f);
            guiDrawing.finishDrawingTexture();
            graphicsHolder.translate(0.0, (double)finalHeight, 0.0);
        }
    }

    private static int getColor(double executionMs) {
        if (executionMs > 33.333333333333336) {
            return -30584;
        }
        if (executionMs > 16.666666666666668) {
            return -256;
        }
        return -3355393;
    }
}

