/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.jcm.mod.network.block;

import com.lx862.jcm.mod.block.base.JCMBlock;
import com.lx862.jcm.mod.block.entity.SoundLooperBlockEntity;
import com.lx862.jcm.mod.util.BlockUtil;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.MinecraftServer;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.registry.PacketHandler;
import org.mtr.mapping.tool.PacketBufferReceiver;
import org.mtr.mapping.tool.PacketBufferSender;

public class SoundLooperUpdatePacket
extends PacketHandler {
    private final BlockPos blockPos;
    private final BlockPos corner1;
    private final BlockPos corner2;
    private final String soundId;
    private final int soundCategory;
    private final int interval;
    private final float soundVolume;
    private final boolean needRedstone;
    private final boolean limitRange;

    public SoundLooperUpdatePacket(PacketBufferReceiver packetBufferReceiver) {
        this.blockPos = BlockPos.fromLong((long)packetBufferReceiver.readLong());
        this.corner1 = BlockPos.fromLong((long)packetBufferReceiver.readLong());
        this.corner2 = BlockPos.fromLong((long)packetBufferReceiver.readLong());
        this.soundId = packetBufferReceiver.readString();
        this.soundCategory = packetBufferReceiver.readInt();
        this.interval = packetBufferReceiver.readInt();
        this.soundVolume = packetBufferReceiver.readFloat();
        this.needRedstone = packetBufferReceiver.readBoolean();
        this.limitRange = packetBufferReceiver.readBoolean();
    }

    public SoundLooperUpdatePacket(BlockPos blockPos, BlockPos corner1, BlockPos corner2, String soundId, int soundCategory, int interval, float soundVolume, boolean needRedstone, boolean limitRange) {
        this.blockPos = blockPos;
        this.corner1 = corner1;
        this.corner2 = corner2;
        this.soundId = soundId;
        this.soundCategory = soundCategory;
        this.interval = interval;
        this.soundVolume = soundVolume;
        this.needRedstone = needRedstone;
        this.limitRange = limitRange;
    }

    public void runServer(MinecraftServer minecraftServer, ServerPlayerEntity serverPlayerEntity) {
        World world = serverPlayerEntity.getEntityWorld();
        BlockState state = BlockUtil.getBlockState(world, this.blockPos);
        if (state == null || !(state.getBlock().data instanceof JCMBlock)) {
            return;
        }
        ((JCMBlock)((Object)state.getBlock().data)).loopStructure(state, world, this.blockPos, (bs, be) -> {
            if (be.data instanceof SoundLooperBlockEntity) {
                ((SoundLooperBlockEntity)((Object)((Object)be.data))).setData(this.soundId, this.soundCategory, this.interval, this.soundVolume, this.needRedstone, this.limitRange, this.corner1, this.corner2);
            }
        });
    }

    public void write(PacketBufferSender packetBufferSender) {
        packetBufferSender.writeLong(this.blockPos.asLong());
        packetBufferSender.writeLong(this.corner1.asLong());
        packetBufferSender.writeLong(this.corner2.asLong());
        packetBufferSender.writeString(this.soundId);
        packetBufferSender.writeInt(this.soundCategory);
        packetBufferSender.writeInt(this.interval);
        packetBufferSender.writeFloat(this.soundVolume);
        packetBufferSender.writeBoolean(this.needRedstone);
        packetBufferSender.writeBoolean(this.limitRange);
    }
}

