/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.jcm.mod.network.block;

import com.lx862.jcm.mod.block.entity.PIDSProjectorBlockEntity;
import com.lx862.jcm.mod.network.block.PIDSUpdatePacket;
import com.lx862.jcm.mod.util.BlockUtil;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongAVLTreeSet;
import org.mtr.mapping.holder.BlockEntity;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.MinecraftServer;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.tool.PacketBufferReceiver;
import org.mtr.mapping.tool.PacketBufferSender;

public class PIDSProjectorUpdatePacket
extends PIDSUpdatePacket {
    private final double x;
    private final double y;
    private final double z;
    private final double rotateX;
    private final double rotateY;
    private final double rotateZ;
    private final double scale;

    public PIDSProjectorUpdatePacket(PacketBufferReceiver packetBufferReceiver) {
        super(packetBufferReceiver);
        this.x = packetBufferReceiver.readDouble();
        this.y = packetBufferReceiver.readDouble();
        this.z = packetBufferReceiver.readDouble();
        this.rotateX = packetBufferReceiver.readDouble();
        this.rotateY = packetBufferReceiver.readDouble();
        this.rotateZ = packetBufferReceiver.readDouble();
        this.scale = packetBufferReceiver.readDouble();
    }

    public PIDSProjectorUpdatePacket(BlockPos blockPos, LongAVLTreeSet filteredPlatforms, String[] customMessages, boolean[] rowHidden, boolean hidePlatformNumber, String pidsPreset, double x, double y, double z, double rotateX, double rotateY, double rotateZ, double scale) {
        super(blockPos, filteredPlatforms, customMessages, rowHidden, hidePlatformNumber, pidsPreset);
        this.x = x;
        this.y = y;
        this.z = z;
        this.rotateX = rotateX;
        this.rotateY = rotateY;
        this.rotateZ = rotateZ;
        this.scale = scale;
    }

    @Override
    public void write(PacketBufferSender packetBufferSender) {
        super.write(packetBufferSender);
        packetBufferSender.writeDouble(this.x);
        packetBufferSender.writeDouble(this.y);
        packetBufferSender.writeDouble(this.z);
        packetBufferSender.writeDouble(this.rotateX);
        packetBufferSender.writeDouble(this.rotateY);
        packetBufferSender.writeDouble(this.rotateZ);
        packetBufferSender.writeDouble(this.scale);
    }

    @Override
    public void runServer(MinecraftServer minecraftServer, ServerPlayerEntity serverPlayerEntity) {
        World world = serverPlayerEntity.getEntityWorld();
        BlockEntity be = BlockUtil.getBlockEntityOrNull(world, this.blockPos);
        if (be != null && be.data instanceof PIDSProjectorBlockEntity) {
            ((PIDSProjectorBlockEntity)((Object)be.data)).setData(this.customMessages, this.filteredPlatforms, this.rowHidden, this.hidePlatformNumber, this.presetId, this.x, this.y, this.z, this.rotateX, this.rotateY, this.rotateZ, this.scale);
        }
    }
}

