/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.jcm.mod.block.entity;

import com.lx862.jcm.mod.block.entity.JCMBlockEntityBase;
import java.util.ArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongAVLTreeSet;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongCollection;
import org.mtr.mapping.holder.BlockEntityType;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.CompoundTag;

public abstract class PIDSBlockEntity
extends JCMBlockEntityBase {
    private final String[] customMessages;
    private final boolean[] rowHidden;
    private boolean hidePlatformNumber;
    private String pidsPresetId;
    private final LongAVLTreeSet platformIds = new LongAVLTreeSet();

    public PIDSBlockEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
        this.customMessages = new String[this.getRowAmount()];
        this.rowHidden = new boolean[this.getRowAmount()];
        this.pidsPresetId = this.getDefaultPresetId();
    }

    public void readCompoundTag(CompoundTag compoundTag) {
        long[] platformIdsArray;
        super.readCompoundTag(compoundTag);
        for (int i = 0; i < this.getRowAmount(); ++i) {
            this.customMessages[i] = compoundTag.getString("message" + i);
            this.rowHidden[i] = compoundTag.getBoolean("hide_arrival" + i);
        }
        this.platformIds.clear();
        for (long platformId : platformIdsArray = compoundTag.getLongArray("platform_ids")) {
            this.platformIds.add(platformId);
        }
        this.hidePlatformNumber = compoundTag.getBoolean("hide_platform_number");
        this.pidsPresetId = compoundTag.getString("preset_id");
    }

    public void writeCompoundTag(CompoundTag compoundTag) {
        super.writeCompoundTag(compoundTag);
        for (int i = 0; i < this.getRowAmount(); ++i) {
            String customMessage = this.customMessages[i] == null ? "" : this.customMessages[i];
            boolean rowHidden = this.rowHidden[i];
            compoundTag.putString("message" + i, customMessage);
            compoundTag.putBoolean("hide_arrival" + i, rowHidden);
        }
        compoundTag.putLongArray("platform_ids", new ArrayList(this.platformIds));
        compoundTag.putBoolean("hide_platform_number", this.hidePlatformNumber);
        compoundTag.putString("preset_id", this.pidsPresetId);
    }

    public String[] getCustomMessages() {
        return this.customMessages;
    }

    public LongAVLTreeSet getPlatformIds() {
        return this.platformIds;
    }

    public boolean[] getRowHidden() {
        return this.rowHidden;
    }

    public boolean platformNumberHidden() {
        return this.hidePlatformNumber;
    }

    public void setData(String[] customMessages, LongAVLTreeSet filteredPlatforms, boolean[] rowHidden, boolean hidePlatformNumber, String pidsPresetId) {
        System.arraycopy(customMessages, 0, this.customMessages, 0, customMessages.length);
        System.arraycopy(rowHidden, 0, this.rowHidden, 0, rowHidden.length);
        this.hidePlatformNumber = hidePlatformNumber;
        this.pidsPresetId = pidsPresetId;
        this.platformIds.clear();
        this.platformIds.addAll((LongCollection)filteredPlatforms);
        this.markDirty2();
    }

    public String getPresetId() {
        return this.pidsPresetId.isEmpty() ? this.getDefaultPresetId() : this.pidsPresetId;
    }

    public abstract String getPIDSType();

    public abstract String getDefaultPresetId();

    public abstract int getRowAmount();
}

