/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.jcm.mod.block.behavior;

import com.lx862.jcm.mod.data.EnquiryScreenType;
import com.lx862.jcm.mod.data.TransactionEntry;
import com.lx862.jcm.mod.data.TransactionLog;
import com.lx862.jcm.mod.network.gui.EnquiryUpdateGUIPacket;
import com.lx862.jcm.mod.registry.Networking;
import com.lx862.jcm.mod.util.TextUtil;
import java.util.List;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.SoundCategory;
import org.mtr.mapping.holder.Text;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.SoundEvents;
import org.mtr.mod.data.TicketSystem;

public interface EnquiryMachineBehavior {
    default public void enquiry(EnquiryScreenType type, BlockPos pos, World world, PlayerEntity player) {
        world.playSound(null, player.getBlockPos(), SoundEvents.TICKET_PROCESSOR_ENTRY.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
        if (type == EnquiryScreenType.NONE) {
            int score = TicketSystem.getBalance((World)world, (PlayerEntity)player);
            player.sendMessage(Text.cast((HolderBase)TextUtil.translatable("gui.mtr.balance", String.valueOf(score))), true);
        } else {
            List<TransactionEntry> entries = TransactionLog.readLog(player, player.getUuidAsString());
            Networking.sendPacketToClient(player, new EnquiryUpdateGUIPacket(type, pos, entries, TicketSystem.getBalance((World)world, (PlayerEntity)player)));
        }
    }
}

