/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.jcm.mod.block.base;

import com.lx862.jcm.mod.block.base.DirectionalBlock;
import com.lx862.jcm.mod.block.behavior.VerticalDoubleBlock;
import java.util.List;
import net.minecraft.world.level.block.state.properties.Property;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockSettings;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.Blocks;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.ItemPlacementContext;
import org.mtr.mapping.holder.ItemStack;
import org.mtr.mapping.holder.LivingEntity;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.holder.WorldAccess;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.block.IBlock;

public abstract class Vertical2Block
extends DirectionalBlock
implements VerticalDoubleBlock {
    public Vertical2Block(BlockSettings settings) {
        super(settings);
    }

    public void onPlaced2(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack itemStack) {
        VerticalDoubleBlock.placeBlock(world, pos, state);
    }

    @Override
    public BlockState getPlacementState2(ItemPlacementContext ctx) {
        BlockState superState = super.getPlacementState2(ctx);
        if (superState == null) {
            return null;
        }
        return VerticalDoubleBlock.canBePlaced(ctx.getWorld(), ctx.getBlockPos(), ctx) ? superState.with(new org.mtr.mapping.holder.Property((Property)Vertical2Block.HALF.data), (Comparable)IBlock.DoubleBlockHalf.LOWER) : null;
    }

    public BlockState getStateForNeighborUpdate2(BlockState state, Direction direction, BlockState neighborState, WorldAccess world, BlockPos pos, BlockPos neighborPos) {
        if (VerticalDoubleBlock.blockNotValid(new Block((net.minecraft.world.level.block.Block)this), world, pos, state)) {
            return Blocks.getAirMapped().getDefaultState();
        }
        return super.getStateForNeighborUpdate2(state, direction, neighborState, world, pos, neighborPos);
    }

    public void onBreak2(World world, BlockPos breakPos, BlockState breakState, PlayerEntity player) {
        this.breakWithoutDropIfCreative(world, breakPos, breakState, player, this, VerticalDoubleBlock::getLootDropPos);
        super.onBreak2(world, breakPos, breakState, player);
    }

    @Override
    public BlockPos[] getAllPos(BlockState state, WorldAccess world, BlockPos pos) {
        switch ((IBlock.DoubleBlockHalf)IBlock.getStatePropertySafe((BlockState)state, (org.mtr.mapping.holder.Property)new org.mtr.mapping.holder.Property((Property)Vertical2Block.HALF.data))) {
            case LOWER: {
                return new BlockPos[]{pos, pos.up()};
            }
            case UPPER: {
                return new BlockPos[]{pos.down(), pos};
            }
        }
        return super.getAllPos(state, world, pos);
    }

    @Override
    public void addBlockProperties(List<HolderBase<?>> properties) {
        super.addBlockProperties(properties);
        properties.add((HolderBase<?>)HALF);
    }
}

