/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosroadblocksmod.road;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.Vec3;

public class CurveUtil {
    public static List<BlockPos> sampleCatmullRomBlocks(List<BlockPos> pts) {
        List<Vec3> vecs = CurveUtil.sampleCatmullRomVec(pts);
        LinkedHashSet<BlockPos> unique = new LinkedHashSet<BlockPos>();
        for (Vec3 v : vecs) {
            unique.add(new BlockPos((int)Math.round(v.f_82479_), (int)Math.round(v.f_82480_), (int)Math.round(v.f_82481_)));
        }
        return new ArrayList<BlockPos>(unique);
    }

    public static List<Vec3> sampleCatmullRomVec(List<BlockPos> pts) {
        ArrayList<Vec3> out = new ArrayList<Vec3>();
        if (pts == null || pts.size() == 0) {
            return out;
        }
        if (pts.size() == 1) {
            BlockPos p = pts.get(0);
            out.add(CurveUtil.centerOf(p));
            return out;
        }
        if (pts.size() == 2) {
            Vec3 v1 = CurveUtil.centerOf(pts.get(0));
            Vec3 v2 = CurveUtil.centerOf(pts.get(1));
            double dist = v1.m_82554_(v2);
            int steps = Math.max(20, (int)(dist * 3.0));
            for (int s = 0; s <= steps; ++s) {
                double t = (double)s / (double)steps;
                Vec3 v = CurveUtil.lerp(v1, v2, t);
                out.add(v);
            }
            return out;
        }
        int n = pts.size();
        for (int i = 0; i < n - 1; ++i) {
            Vec3 p3;
            Vec3 p0;
            Vec3 p1 = CurveUtil.centerOf(pts.get(i));
            Vec3 p2 = CurveUtil.centerOf(pts.get(i + 1));
            if (i == 0) {
                Vec3 dir = p2.m_82546_(p1);
                p0 = p1.m_82546_(dir.m_82490_(0.5));
            } else {
                p0 = CurveUtil.centerOf(pts.get(i - 1));
            }
            if (i >= n - 2) {
                Vec3 dir = p2.m_82546_(p1);
                p3 = p2.m_82549_(dir.m_82490_(0.5));
            } else {
                p3 = CurveUtil.centerOf(pts.get(i + 2));
            }
            double segLen = p1.m_82554_(p2);
            int steps = Math.max(20, (int)(segLen * 3.0));
            for (int s = 0; s <= steps; ++s) {
                double t = (double)s / (double)steps;
                Vec3 v = CurveUtil.catmullRomUniform(p0, p1, p2, p3, t);
                out.add(v);
            }
        }
        return out;
    }

    private static Vec3 lerp(Vec3 a, Vec3 b, double t) {
        return new Vec3(a.f_82479_ + (b.f_82479_ - a.f_82479_) * t, a.f_82480_ + (b.f_82480_ - a.f_82480_) * t, a.f_82481_ + (b.f_82481_ - a.f_82481_) * t);
    }

    private static Vec3 catmullRomUniform(Vec3 p0, Vec3 p1, Vec3 p2, Vec3 p3, double t) {
        double t2 = t * t;
        double t3 = t2 * t;
        double x = 0.5 * (2.0 * p1.f_82479_ + (-p0.f_82479_ + p2.f_82479_) * t + (2.0 * p0.f_82479_ - 5.0 * p1.f_82479_ + 4.0 * p2.f_82479_ - p3.f_82479_) * t2 + (-p0.f_82479_ + 3.0 * p1.f_82479_ - 3.0 * p2.f_82479_ + p3.f_82479_) * t3);
        double y = 0.5 * (2.0 * p1.f_82480_ + (-p0.f_82480_ + p2.f_82480_) * t + (2.0 * p0.f_82480_ - 5.0 * p1.f_82480_ + 4.0 * p2.f_82480_ - p3.f_82480_) * t2 + (-p0.f_82480_ + 3.0 * p1.f_82480_ - 3.0 * p2.f_82480_ + p3.f_82480_) * t3);
        double z = 0.5 * (2.0 * p1.f_82481_ + (-p0.f_82481_ + p2.f_82481_) * t + (2.0 * p0.f_82481_ - 5.0 * p1.f_82481_ + 4.0 * p2.f_82481_ - p3.f_82481_) * t2 + (-p0.f_82481_ + 3.0 * p1.f_82481_ - 3.0 * p2.f_82481_ + p3.f_82481_) * t3);
        return new Vec3(x, y, z);
    }

    private static Vec3 centerOf(BlockPos p) {
        return new Vec3((double)p.m_123341_() + 0.5, (double)p.m_123342_(), (double)p.m_123343_() + 0.5);
    }
}

