/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosroadblocksmod.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SidewalkBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final EnumProperty<Variant> VARIANT = EnumProperty.m_61587_((String)"variant", Variant.class);

    public SidewalkBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_60913_(1.5f, 6.0f).m_60999_().m_284180_(MapColor.f_283818_));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(VARIANT, (Comparable)((Object)Variant.DEFAULT)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, VARIANT});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_(VARIANT, (Comparable)((Object)Variant.DEFAULT));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        int height = this.getHeightForVariant((Variant)((Object)state.m_61143_(VARIANT)));
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.NORTH -> SidewalkBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)height, (double)16.0);
            case Direction.EAST -> SidewalkBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)height, (double)16.0);
            case Direction.SOUTH -> SidewalkBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)height, (double)16.0);
            case Direction.WEST -> SidewalkBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)height, (double)16.0);
            default -> SidewalkBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)height, (double)16.0);
        };
    }

    private int getHeightForVariant(Variant variant) {
        return switch (variant) {
            case Variant.ONE -> 15;
            case Variant.TWO -> 14;
            case Variant.THREE -> 13;
            case Variant.FOUR -> 12;
            case Variant.FIVE -> 11;
            case Variant.SIX -> 10;
            case Variant.SEVEN -> 9;
            case Variant.EIGHT -> 8;
            case Variant.NINE -> 7;
            case Variant.TEN -> 6;
            case Variant.ELEVEN -> 5;
            case Variant.TWELVE -> 4;
            case Variant.THIRTEEN -> 3;
            case Variant.FOURTEEN -> 2;
            case Variant.FIFTEEN -> 1;
            default -> 16;
        };
    }

    private Variant getNextVariant(Variant current) {
        Variant[] variants = Variant.values();
        int currentIndex = current.ordinal();
        return variants[(currentIndex + 1) % variants.length];
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return state;
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state;
    }

    public static enum Variant implements StringRepresentable
    {
        DEFAULT("default"),
        ONE("1"),
        TWO("2"),
        THREE("3"),
        FOUR("4"),
        FIVE("5"),
        SIX("6"),
        SEVEN("7"),
        EIGHT("8"),
        NINE("9"),
        TEN("10"),
        ELEVEN("11"),
        TWELVE("12"),
        THIRTEEN("13"),
        FOURTEEN("14"),
        FIFTEEN("15");

        private final String name;

        private Variant(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

