/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.tileentities;

import com.dairymoose.modernlife.blocks.StoveBlock;
import com.dairymoose.modernlife.core.CustomBlocks;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StoveBlockEntity
extends BlockEntity
implements Container {
    public static final BlockEntityType<StoveBlockEntity> STOVE = BlockEntityType.Builder.m_155273_(StoveBlockEntity::new, (Block[])new Block[]{(Block)CustomBlocks.BLOCK_STOVE.get()}).m_58966_(null);
    private static final Logger LOGGER = LogManager.getLogger();
    public static final int STOVE_CONTAINER_SIZE = 8;
    private NonNullList<ItemStack> stoveStack = NonNullList.m_122780_((int)8, (Object)ItemStack.f_41583_);
    private int[] cookProgress = new int[8];
    private int[] cookTime = new int[8];
    public int tickCounter = 0;

    public int m_6893_() {
        return 1;
    }

    public boolean m_7013_(int flag, ItemStack itemStack) {
        Optional optional = this.f_58857_.m_7465_().m_44015_(RecipeType.f_44111_, (Container)new SimpleContainer(new ItemStack[]{itemStack}), this.f_58857_);
        return this.m_7983_() && optional.isPresent();
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        ContainerHelper.m_18973_((CompoundTag)nbt, this.stoveStack);
        return nbt;
    }

    public void handleUpdateTag(CompoundTag tag) {
        ContainerHelper.m_18980_((CompoundTag)tag, this.stoveStack);
        super.handleUpdateTag(tag);
    }

    public void m_142466_(CompoundTag p_230337_2_) {
        int[] data;
        super.m_142466_(p_230337_2_);
        ContainerHelper.m_18980_((CompoundTag)p_230337_2_, this.stoveStack);
        if (p_230337_2_.m_128441_("CookProgress")) {
            data = p_230337_2_.m_128465_("CookProgress");
            System.arraycopy(data, 0, this.cookProgress, 0, Math.min(this.cookProgress.length, data.length));
        }
        if (p_230337_2_.m_128441_("CookTime")) {
            data = p_230337_2_.m_128465_("CookTime");
            System.arraycopy(data, 0, this.cookTime, 0, Math.min(this.cookTime.length, data.length));
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection conn, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag tag = pkt.m_131708_();
        if (tag != null) {
            this.stoveStack.clear();
            ContainerHelper.m_18980_((CompoundTag)tag, this.stoveStack);
        }
    }

    protected void m_183515_(CompoundTag p_189515_1_) {
        ContainerHelper.m_18973_((CompoundTag)p_189515_1_, this.stoveStack);
        p_189515_1_.m_128385_("CookProgress", this.cookProgress);
        p_189515_1_.m_128385_("CookTime", this.cookTime);
    }

    public boolean isFull() {
        int count = 0;
        for (int i = 0; i < this.stoveStack.size(); ++i) {
            if (((ItemStack)this.stoveStack.get(i)).m_41619_()) continue;
            ++count;
        }
        return count == this.stoveStack.size();
    }

    public int getNextFreeSlot() {
        for (int i = 0; i < this.stoveStack.size(); ++i) {
            if (!((ItemStack)this.stoveStack.get(i)).m_41619_()) continue;
            return i;
        }
        return -1;
    }

    public int getNextOccupiedSlot() {
        for (int i = 0; i < this.stoveStack.size(); ++i) {
            if (((ItemStack)this.stoveStack.get(i)).m_41619_()) continue;
            return i;
        }
        return -1;
    }

    public void m_6211_() {
        for (int i = 0; i < this.stoveStack.size(); ++i) {
            this.stoveStack.set(i, (Object)ItemStack.f_41583_);
        }
    }

    public int m_6643_() {
        return 8;
    }

    public boolean m_7983_() {
        for (int i = 0; i < this.stoveStack.size(); ++i) {
            if (((ItemStack)this.stoveStack.get(i)).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int var1) {
        return (ItemStack)this.stoveStack.get(var1);
    }

    public ItemStack m_7407_(int var1, int var2) {
        return ContainerHelper.m_18969_(this.stoveStack, (int)var1, (int)var2);
    }

    public ItemStack m_8016_(int var1) {
        return ContainerHelper.m_18966_(this.stoveStack, (int)var1);
    }

    public void m_6836_(int var1, ItemStack itemStack) {
        if (itemStack.m_41619_()) {
            this.setItemInternal(var1, itemStack);
            return;
        }
        Optional optional = this.f_58857_.m_7465_().m_44015_(RecipeType.f_44111_, (Container)new SimpleContainer(new ItemStack[]{itemStack}), this.f_58857_);
        if (optional.isPresent()) {
            ItemStack oneItem = itemStack.m_41620_(1);
            this.cookItem(oneItem, StoveBlock.calculateTime(optional));
        }
        if (!this.f_58857_.f_46443_) {
            ((ServerLevel)this.m_58904_()).m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
        }
    }

    private void setItemInternal(int var1, ItemStack var2) {
        this.stoveStack.set(var1, (Object)var2);
    }

    public boolean m_6542_(Player p_70300_1_) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return p_70300_1_.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public StoveBlockEntity(BlockPos pos, BlockState state) {
        super(STOVE, pos, state);
    }

    public void cookItem(ItemStack itemStack, int cookTime) {
        int freeSlot = this.getNextFreeSlot();
        if (freeSlot != -1) {
            this.cookProgress[freeSlot] = 0;
            this.cookTime[freeSlot] = cookTime;
            this.setItemInternal(freeSlot, itemStack.m_41777_());
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, StoveBlockEntity entity) {
        entity.tick();
    }

    public void tick() {
        if (!this.f_58857_.f_46443_ && !this.m_7983_()) {
            for (int i = 0; i < 8; ++i) {
                BlockState oldState;
                if (this.cookTime[i] <= 0) continue;
                if (((Boolean)this.m_58900_().m_61143_((Property)StoveBlock.OPEN_DOOR)).booleanValue()) {
                    int n = i;
                    this.cookProgress[n] = this.cookProgress[n] - 1;
                    if (this.cookProgress[i] >= 0) continue;
                    this.cookProgress[i] = 0;
                    continue;
                }
                int n = i;
                this.cookProgress[n] = this.cookProgress[n] + 1;
                if (this.cookProgress[i] < this.cookTime[i]) continue;
                this.cookTime[i] = 0;
                ItemStack toCook = this.m_8020_(i);
                SimpleContainer container = new SimpleContainer(new ItemStack[]{toCook});
                ItemStack lvt_4_1_ = this.f_58857_.m_7465_().m_44015_(RecipeType.f_44111_, (Container)container, this.f_58857_).map(arg_0 -> this.lambda$tick$0((Container)container, arg_0)).orElse(toCook);
                BlockPos pos = this.m_58899_();
                double xMod = 0.0;
                double zMod = 0.0;
                double dropDistance = 0.6;
                Direction stoveFacing = (Direction)this.m_58900_().m_61143_((Property)StoveBlock.f_54117_);
                if (stoveFacing == Direction.NORTH) {
                    zMod += dropDistance;
                } else if (stoveFacing == Direction.EAST) {
                    xMod -= dropDistance;
                } else if (stoveFacing == Direction.WEST) {
                    xMod += dropDistance;
                } else if (stoveFacing == Direction.SOUTH) {
                    zMod -= dropDistance;
                }
                Containers.m_18992_((Level)this.f_58857_, (double)((double)pos.m_123341_() + 0.5 + xMod), (double)((double)pos.m_123342_() + 0.5), (double)((double)pos.m_123343_() + 0.5 + zMod), (ItemStack)lvt_4_1_);
                this.setItemInternal(i, ItemStack.f_41583_);
                BlockState newState = oldState = this.m_58900_();
                if (this.m_7983_()) {
                    newState = (BlockState)oldState.m_61124_((Property)StoveBlock.OPEN_DOOR, (Comparable)Boolean.valueOf(true));
                    this.m_58904_().m_46597_(pos, newState);
                }
                ((ServerLevel)this.m_58904_()).m_7260_(pos, oldState, newState, 2);
            }
        }
        if (this.f_58857_.f_46443_) {
            if (this.m_7983_()) {
                this.tickCounter = 0;
            } else if (!((Boolean)this.m_58900_().m_61143_((Property)StoveBlock.OPEN_DOOR)).booleanValue()) {
                ++this.tickCounter;
            }
        }
    }

    private /* synthetic */ ItemStack lambda$tick$0(Container container, CampfireCookingRecipe p_213979_1_) {
        return p_213979_1_.m_5874_(container, this.f_58857_.m_9598_());
    }
}

