/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.tileentities;

import com.dairymoose.modernlife.blocks.PhotonBlock;
import com.dairymoose.modernlife.core.CustomBlocks;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PhotonBlockEntity
extends BlockEntity {
    public static final BlockEntityType<PhotonBlockEntity> PHOTON = BlockEntityType.Builder.m_155273_(PhotonBlockEntity::new, (Block[])new Block[]{(Block)CustomBlocks.BLOCK_PHOTON.get()}).m_58966_(null);
    private static final Logger LOGGER = LogManager.getLogger();
    public static Map<Entity, BlockPos> photonPos = new HashMap<Entity, BlockPos>();
    public static Set<BlockPos> existingPhotons = new HashSet<BlockPos>();
    private boolean destroyed = false;
    private int tickCount = 0;
    private int extinguishTick = -1;
    private int destroyTick = -1;
    private static int TICKS_UNTIL_EXTINGUISHED = 2;
    private static double PERSIST_ENTITY_SECONDS = 0.0;
    private static int TICKS_PER_SECOND = 20;

    public PhotonBlockEntity(BlockPos pos, BlockState state) {
        super(PHOTON, pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, PhotonBlockEntity entity) {
        entity.tick();
    }

    public void tick() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (this.destroyed) {
            return;
        }
        if (this.extinguishTick == -1 && this.destroyTick == -1 && !existingPhotons.contains(this.m_58899_())) {
            this.extinguishTick = this.tickCount + TICKS_UNTIL_EXTINGUISHED;
        }
        if (this.extinguishTick != -1 && this.tickCount >= this.extinguishTick) {
            this.extinguishTick = -1;
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)PhotonBlock.EXTINGUISHED, (Comparable)Boolean.valueOf(true)), 3);
            this.destroyTick = this.tickCount + (int)(Math.random() * PERSIST_ENTITY_SECONDS * (double)TICKS_PER_SECOND) + 1;
        }
        if (this.destroyTick != -1 && this.tickCount >= this.destroyTick) {
            this.destroyTick = -1;
            BlockState state = this.f_58857_.m_8055_(this.m_58899_());
            if (state.m_60713_((Block)CustomBlocks.BLOCK_PHOTON.get()) && ((Boolean)state.m_61143_((Property)PhotonBlock.EXTINGUISHED)).booleanValue()) {
                this.f_58857_.m_7471_(this.m_58899_(), false);
                if (((Boolean)state.m_61143_((Property)PhotonBlock.WATERLOGGED)).booleanValue()) {
                    this.f_58857_.m_7731_(this.m_58899_(), state.m_60819_().m_76188_(), 2);
                }
                this.destroyed = true;
            }
        }
        ++this.tickCount;
    }
}

