/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.tileentities;

import com.dairymoose.modernlife.blocks.ModernBookshelfBlock;
import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.core.ModernLifeCommon;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModernBookshelfBlockEntity
extends BlockEntity
implements Container {
    public static final BlockEntityType<ModernBookshelfBlockEntity> MODERN_BOOKSHELF = BlockEntityType.Builder.m_155273_(ModernBookshelfBlockEntity::new, (Block[])new Block[]{(Block)CustomBlocks.BLOCK_MODERN_ACACIA_BOOKSHELF.get(), (Block)CustomBlocks.BLOCK_MODERN_BIRCH_BOOKSHELF.get(), (Block)CustomBlocks.BLOCK_MODERN_CRIMSON_BOOKSHELF.get(), (Block)CustomBlocks.BLOCK_MODERN_DARK_OAK_BOOKSHELF.get(), (Block)CustomBlocks.BLOCK_MODERN_JUNGLE_BOOKSHELF.get(), (Block)CustomBlocks.BLOCK_MODERN_OAK_BOOKSHELF.get(), (Block)CustomBlocks.BLOCK_MODERN_SPRUCE_BOOKSHELF.get(), (Block)CustomBlocks.BLOCK_MODERN_WARPED_BOOKSHELF.get()}).m_58966_(null);
    private static final Logger LOGGER = LogManager.getLogger();
    public static final int MODERN_BOOKSHELF_CONTAINER_SIZE = 16;
    private NonNullList<ItemStack> items = null;
    public NonNullList<String> bookNames = null;
    public List<Float> bookHeight;
    public int serverSideHitIndex = -1;
    public static final List<Double> itemPosX = new ArrayList<Double>();
    public static final List<Double> itemPosY = new ArrayList<Double>();
    public static final List<Double> itemPosZ = new ArrayList<Double>();
    public static final double X_POS_START = 0.0625;
    public static final double BOOK_WIDTH = 0.1;
    public static final double BOOK_GAP = 0.01;
    public static List<String> randomBookNames;

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public boolean m_7013_(int p_18952_, ItemStack p_18953_) {
        return false;
    }

    public int getHitIndex(Player player, HitResult hr) {
        int hitIndex = -1;
        BlockPos pos = null;
        if (hr instanceof BlockHitResult) {
            BlockHitResult bhr = (BlockHitResult)hr;
            pos = bhr.m_82425_();
            BlockState state = this.m_58904_().m_8055_(pos);
            Vec3 hitLocation = bhr.m_82450_();
            double leastDistance = 1000.0;
            if (player.m_20238_(hitLocation) <= 6.25) {
                for (int i = 0; i < 16; ++i) {
                    ItemStack itemStack = this.m_8020_(i);
                    if (itemStack.m_41619_()) continue;
                    double offsetX = itemPosX.get(i % itemPosX.size()) + 0.05;
                    double offsetY = itemPosY.get(i % itemPosY.size()) + 0.15;
                    double offsetZ = itemPosZ.get(i % itemPosZ.size());
                    double x = pos.m_123341_();
                    double y = pos.m_123342_();
                    double z = pos.m_123343_();
                    if (state.m_61143_((Property)ModernBookshelfBlock.FACING) == Direction.EAST) {
                        x += 1.0 - offsetZ;
                        y += offsetY;
                        z += 1.0 - offsetX;
                    } else if (state.m_61143_((Property)ModernBookshelfBlock.FACING) == Direction.NORTH) {
                        x += 1.0 - offsetX;
                        y += offsetY;
                        z += offsetZ;
                    } else if (state.m_61143_((Property)ModernBookshelfBlock.FACING) == Direction.WEST) {
                        x += offsetZ;
                        y += offsetY;
                        z += offsetX;
                    } else {
                        x += offsetX;
                        y += offsetY;
                        z += 1.0 - offsetZ;
                    }
                    double distSqr = hitLocation.m_82557_(new Vec3(x, y, z));
                    double distSqrWithoutY = hitLocation.m_193103_(Direction.Axis.Y, 0.0).m_82557_(new Vec3(x, 0.0, z));
                    double distY = hitLocation.f_82480_ - y;
                    if (!(distSqr < leastDistance) || !(distSqrWithoutY <= 0.01) || !(distY <= 0.15)) continue;
                    hitIndex = i;
                    leastDistance = distSqr;
                }
            }
        }
        return hitIndex;
    }

    public void initItems() {
        BlockEntityType type;
        if (this.items == null && (type = this.m_58903_()) != null && type == MODERN_BOOKSHELF) {
            ModernLifeCommon.LOGGER.debug("init with size = 16");
            this.items = NonNullList.m_122780_((int)16, (Object)ItemStack.f_41583_);
            this.bookNames = NonNullList.m_122780_((int)16, (Object)"");
            this.bookHeight = new ArrayList<Float>(16);
            for (int i = 0; i < 16; ++i) {
                this.bookHeight.add(Float.valueOf(1.0f));
            }
        }
    }

    public boolean isFull() {
        int count = 0;
        for (int i = 0; i < this.items.size(); ++i) {
            if (((ItemStack)this.items.get(i)).m_41619_()) continue;
            ++count;
        }
        return count == this.items.size();
    }

    public int getNextFreeSlot() {
        for (int i = 0; i < this.items.size(); ++i) {
            if (!((ItemStack)this.items.get(i)).m_41619_()) continue;
            return i;
        }
        return -1;
    }

    public int getNextOccupiedSlot() {
        for (int i = this.items.size() - 1; i >= 0; --i) {
            if (((ItemStack)this.items.get(i)).m_41619_()) continue;
            return i;
        }
        return -1;
    }

    public void placeItem(ItemStack itemStack) {
        int freeSlot = this.getNextFreeSlot();
        if (freeSlot != -1) {
            this.m_6836_(freeSlot, itemStack.m_41777_());
            float randValue = (float)Math.random() * 0.7f;
            float yScale = 0.7f + randValue;
            this.bookHeight.set(freeSlot, Float.valueOf(yScale));
            String displayText = itemStack.m_41786_().getString();
            if (displayText.equals("Book")) {
                displayText = randomBookNames.get((int)(Math.random() * (double)randomBookNames.size()));
            }
            this.bookNames.set(freeSlot, (Object)displayText);
        }
    }

    public ModernBookshelfBlockEntity(BlockPos pos, BlockState state) {
        super(MODERN_BOOKSHELF, pos, state);
        this.initItems();
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        ContainerHelper.m_18973_((CompoundTag)nbt, this.items);
        ListTag list = new ListTag();
        for (int i = 0; i < 16; ++i) {
            list.add((Object)StringTag.m_129297_((String)((String)this.bookNames.get(i))));
        }
        nbt.m_128365_("namelist", (Tag)list);
        return nbt;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.initItems();
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
        if (tag.m_128441_("namelist")) {
            ListTag list = (ListTag)tag.m_128423_("namelist");
            for (int i = 0; i < list.size(); ++i) {
                this.bookNames.set(i, (Object)list.m_128778_(i));
            }
        }
        super.handleUpdateTag(tag);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection conn, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag tag = pkt.m_131708_();
        if (tag != null) {
            this.initItems();
            this.items.clear();
            ContainerHelper.m_18980_((CompoundTag)tag, this.items);
            if (tag.m_128441_("namelist")) {
                ListTag list = (ListTag)tag.m_128423_("namelist");
                for (int i = 0; i < list.size(); ++i) {
                    this.bookNames.set(i, (Object)list.m_128778_(i));
                }
            }
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.initItems();
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
        if (tag.m_128441_("namelist")) {
            ListTag list = (ListTag)tag.m_128423_("namelist");
            for (int i = 0; i < list.size(); ++i) {
                this.bookNames.set(i, (Object)list.m_128778_(i));
            }
        }
    }

    protected void m_183515_(CompoundTag tag) {
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
        ListTag list = new ListTag();
        for (int i = 0; i < 16; ++i) {
            list.add((Object)StringTag.m_129297_((String)((String)this.bookNames.get(i))));
        }
        tag.m_128365_("namelist", (Tag)list);
    }

    public void m_6211_() {
        for (int i = 0; i < this.items.size(); ++i) {
            this.items.set(i, (Object)ItemStack.f_41583_);
        }
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean m_7983_() {
        for (int i = 0; i < this.items.size(); ++i) {
            if (this.items.get(i) == ItemStack.f_41583_) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int var1) {
        return (ItemStack)this.items.get(var1);
    }

    public ItemStack m_7407_(int var1, int var2) {
        return ContainerHelper.m_18969_(this.items, (int)var1, (int)var2);
    }

    public ItemStack m_8016_(int var1) {
        return ContainerHelper.m_18966_(this.items, (int)var1);
    }

    public void m_6836_(int var1, ItemStack var2) {
        this.items.set(var1, (Object)var2);
    }

    public boolean m_6542_(Player p_70300_1_) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return p_70300_1_.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    static {
        itemPosX.add(0.0625);
        itemPosX.add(0.17250000000000001);
        itemPosX.add(0.28250000000000003);
        itemPosX.add(0.39250000000000007);
        itemPosX.add(0.5025000000000001);
        itemPosX.add(0.6125);
        itemPosX.add(0.7225000000000001);
        itemPosX.add(0.8325);
        itemPosY.add(0.0625);
        itemPosY.add(0.0625);
        itemPosY.add(0.0625);
        itemPosY.add(0.0625);
        itemPosY.add(0.0625);
        itemPosY.add(0.0625);
        itemPosY.add(0.0625);
        itemPosY.add(0.0625);
        itemPosY.add(0.53125);
        itemPosY.add(0.53125);
        itemPosY.add(0.53125);
        itemPosY.add(0.53125);
        itemPosY.add(0.53125);
        itemPosY.add(0.53125);
        itemPosY.add(0.53125);
        itemPosY.add(0.53125);
        itemPosZ.add(0.375);
        randomBookNames = List.of("History of Mining", "History of Crafting", "History of Magic", "Ancient History", "Modern Style", "Modern Architecture", "On Building", "On Crafting", "Advanced Building", "Advanced Crafting", "A Brief Respite", "Journey's End", "The Journey", "Heroic Tales", "Feats of Strength", "The Olde Ways", "A Better Tomorrow", "Cobblestone and a Hard Place", "Advanced Swordsmanship", "Expert Swordsmanship", "A Day's Work", "Tending Your Fields", "How To Punch Trees", "The Art of War", "The Odyssey", "Fortune Favors the Bold", "Smithing: A Primer", "The Coldest Night", "The Darkest Night", "Following Your Dreams", "A Cautionary Tale", "Smithing: A Primer", "Lion Of Yesterday", "Agent Of Heaven", "Descendants Of The Gods", "Officers With Gold", "Friends And Enemies", "Mice And Blacksmiths", "Crossbow Of The South", "Obliteration With Sins", "Separated In The Void", "Dead In The Castle", "The Colossal Spider", "Army Of The Eclipse", "Heirs Of The End", "Pirates Of Twilight", "Kings And Invaders", "Gods And Phantoms", "The Living Dead", "The Age Of Heroes", "Breaking The Stars", "Breath Of The West", "Hero Without Direction", "Parrot Of Utopia", "Architect Of Destruction", "Armies Of The Night", "Trees And Knights", "Owls And Heirs", "The Revelation", "Perfection Of The Night", "Crying Out", "Guarded By The North", "Emperor Without Desire", "Hero Without Honor", "Hunters Without Honor", "Friends With Honor", "Mice And Snakes", "Snakes And Spies", "Curse Without Direction", "Fate Of The Void", "Symbols Of The Immortals", "Remembering The Past", "Dog Without Shame", "Invader Without Cause", "The Withered Tree", "Bandits Of The Curse", "Gangsters And Heroes", "Officers And Warriors", "Annihilation Of The Solstice", "Determined To Win", "Running From The End", "Fountain Of Regret", "Tortoise Of Stone", "Warden Of The Prison", "Herald Of The Ancients", "Priests Of The Forest", "Butchers And Guardians", "Kings And Dogs", "Crossbow Of Hope", "Edge Of Dreams", "Vanish In The Commander", "Screams In The Graveyard", "Soldier Of Glory", "Defender Of Greatness", "Swindlers Of The Gods", "Eternal Night", "Creators And Rats", "Climbing The Mountain", "Dreams Of Emeralds", "Dreams Of Diamonds", "Ancient Ruins", "Secrets Revealed", "Painting My Dreams", "Vulture Culture", "Creator Of Silver", "Warriors Of Stone", "Snakes Of The West", "The Long March", "Swindlers And Gods", "Buried Treasure", "Hope And Sorrow", "Bow Of The Forsaken", "Trading In Secrets", "Helping The World", "Parrot Of Wind", "Soldier Of Despair", "Foreigners Without Honor", "Gangsters Of Stone", "Heirs And Knights", "Soldiers and Officers", "History Of Famine", "Goal Of The Ancestors", "Scared Of Nature", "Secrets Of Nature", "Wellspring Of Might", "Forgotten Artifacts", "The Ultimate Folly", "The Hero's Cookbook", "Duchess Of Glory", "Mutiny", "Tools Of The Trade", "Soldiers Without Fear", "Creators And Heroes", "Humans And Vultures", "The Immortals", "Mapping The Kingdom", "Rejecting The King", "Sounds In The Country", "Changeling Of The Night", "Man Of The End", "Turtles With Honor", "Phantoms With Pride", "Warriors And Assassins", "Fish And Officers", "Origin Of Gold", "Vision Of The Forsaken", "Deceiving Myself", "Raiding The Dungeons", "Witch Without Faith", "Hero Without Duty", "Descendants Without Desire", "Rebels Of Time", "Bandits And Lions", "Dogs And Gods", "The Doom That Comes", "Fortune Of The Gods", "Smiles In My Family", "Life In The East", "Bandit Of Fortune", "Hunter With Sins", "The Lucky Bandit", "Owls Of The Plague", "Knights And Spies", "Soldiers And Warriors", "Wand Of Glory", "Man Without A Home", "Screams In Dreams", "Fighting The Power", "Storming The Castle", "The Hidden Dagger", "The Ancient Ways", "True Courage", "True Grit", "True Heroics", "Man Of The Void", "Girls Without Faith", "Swindlers Of Dusk", "Criminals And Kings", "Wizards And Werewolves", "Goal Of The Curse", "Wand Of Nightmares", "Punished By The Darkness", "Force Of The End", "Slave Of The Ocean", "Hunter Of Spring", "Witches Of The Banished", "Ogres Of Dreams", "Women And Pirates", "Creators And Phantoms", "Inspirations And Secrets", "Limit Of The Curse", "Listening To Dreams", "Altering My End", "Throne Of The King", "Rat Of The Prison", "Lords Of Nature", "Mermaids Of The West", "Necromancers And Priests", "Soldiers And Serpents", "Soldier Of Ice", "Hatred Without Fear", "Forsaking The Curse", "Hunted By The Graveyard", "Butcher Of Rainbows", "Human Of Ice", "Birdwatcher", "Owls Of The East", "Thieves And Gods", "Heirs And Protectors", "Influence Of The Eclipse", "Inception", "Never Trust The Champions", "Promises Of The Eternals", "Guilty Damned", "The Final Song", "The Reaping", "Clash in the Sky", "Atlas of Destiny", "Guilty Damned", "A Step Too Far", "History of Villages");
    }
}

