/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.tileentities;

import com.dairymoose.modernlife.blocks.ExtractorBlock;
import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.tileentities.ExtractorItemHandler;
import com.dairymoose.modernlife.tileentities.IHorizontalHopper;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.HopperMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.VanillaInventoryCodeHooks;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExtractorBlockEntity
extends RandomizableContainerBlockEntity
implements IHorizontalHopper {
    public static final BlockEntityType<ExtractorBlockEntity> EXTRACTOR = BlockEntityType.Builder.m_155273_(ExtractorBlockEntity::new, (Block[])new Block[]{(Block)CustomBlocks.BLOCK_EXTRACTOR.get()}).m_58966_(null);
    private static final Logger LOGGER = LogManager.getLogger();
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)5, (Object)ItemStack.f_41583_);
    private int cooldownTime = -1;
    private long tickedGameTime;

    public ExtractorBlockEntity(BlockPos pos, BlockState state) {
        super(EXTRACTOR, pos, state);
    }

    public void m_142466_(CompoundTag p_230337_2_) {
        super.m_142466_(p_230337_2_);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        if (!this.m_59631_(p_230337_2_)) {
            ContainerHelper.m_18980_((CompoundTag)p_230337_2_, this.items);
        }
        this.cooldownTime = p_230337_2_.m_128451_("TransferCooldown");
    }

    protected void m_183515_(CompoundTag p_189515_1_) {
        if (!this.m_59634_(p_189515_1_)) {
            ContainerHelper.m_18973_((CompoundTag)p_189515_1_, this.items);
        }
        p_189515_1_.m_128405_("TransferCooldown", this.cooldownTime);
    }

    public int m_6643_() {
        return this.items.size();
    }

    public ItemStack m_7407_(int p_70298_1_, int p_70298_2_) {
        this.m_59640_(null);
        return ContainerHelper.m_18969_(this.m_7086_(), (int)p_70298_1_, (int)p_70298_2_);
    }

    public void m_6836_(int p_70299_1_, ItemStack p_70299_2_) {
        this.m_59640_(null);
        this.m_7086_().set(p_70299_1_, (Object)p_70299_2_);
        if (p_70299_2_.m_41613_() > this.m_6893_()) {
            p_70299_2_.m_41764_(this.m_6893_());
        }
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"container.extractor");
    }

    public static void tick(Level level, BlockPos pos, BlockState state, ExtractorBlockEntity blockEntity) {
        blockEntity.tick();
    }

    public void tick() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            --this.cooldownTime;
            this.tickedGameTime = this.f_58857_.m_46467_();
            if (!this.isOnCooldown()) {
                this.setCooldown(0);
                this.tryMoveItems(() -> ExtractorBlockEntity.suckInItems(this));
            }
        }
    }

    private boolean tryMoveItems(Supplier<Boolean> p_200109_1_) {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            if (!this.isOnCooldown() && ((Boolean)this.m_58900_().m_61143_((Property)HopperBlock.f_54022_)).booleanValue()) {
                boolean flag = false;
                if (!this.m_7983_()) {
                    flag = this.ejectItems();
                }
                if (!this.inventoryFull()) {
                    flag |= p_200109_1_.get().booleanValue();
                }
                if (flag) {
                    this.setCooldown(8);
                    this.m_6596_();
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private boolean inventoryFull() {
        for (ItemStack itemstack : this.items) {
            if (!itemstack.m_41619_() && itemstack.m_41613_() == itemstack.m_41741_()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Level getHopperLevel() {
        return this.f_58857_;
    }

    private static Optional<Pair<IItemHandler, Object>> getItemHandler(IHorizontalHopper hopper, Direction hopperFacing) {
        double x = hopper.getLevelX() + (double)hopperFacing.m_122429_();
        double y = hopper.getLevelY() + (double)hopperFacing.m_122430_();
        double z = hopper.getLevelZ() + (double)hopperFacing.m_122431_();
        return VanillaInventoryCodeHooks.getItemHandler((Level)hopper.getHopperLevel(), (double)x, (double)y, (double)z, (Direction)hopperFacing.m_122424_());
    }

    private static boolean isFull(IItemHandler itemHandler) {
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack stackInSlot = itemHandler.getStackInSlot(slot);
            if (!stackInSlot.m_41619_() && stackInSlot.m_41613_() >= itemHandler.getSlotLimit(slot)) continue;
            return false;
        }
        return true;
    }

    private static boolean isEmpty(IItemHandler itemHandler) {
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack stackInSlot = itemHandler.getStackInSlot(slot);
            if (stackInSlot.m_41613_() <= 0) continue;
            return false;
        }
        return true;
    }

    public static boolean insertHook(ExtractorBlockEntity hopper) {
        Direction hopperFacing = ((Direction)hopper.m_58900_().m_61143_((Property)HopperBlock.f_54021_)).m_122424_();
        return ExtractorBlockEntity.getItemHandler(hopper, hopperFacing).map(destinationResult -> {
            IItemHandler itemHandler = (IItemHandler)destinationResult.getKey();
            Object destination = destinationResult.getValue();
            if (ExtractorBlockEntity.isFull(itemHandler)) {
                return false;
            }
            for (int i = 0; i < hopper.m_6643_(); ++i) {
                if (hopper.m_8020_(i).m_41619_()) continue;
                ItemStack originalSlotContents = hopper.m_8020_(i).m_41777_();
                ItemStack insertStack = hopper.m_7407_(i, 1);
                ItemStack remainder = ExtractorBlockEntity.putStackInInventoryAllSlots((BlockEntity)hopper, destination, itemHandler, insertStack);
                if (remainder.m_41619_()) {
                    return true;
                }
                hopper.m_6836_(i, originalSlotContents);
            }
            return false;
        }).orElse(false);
    }

    private static ItemStack putStackInInventoryAllSlots(BlockEntity source, Object destination, IItemHandler destInventory, ItemStack stack) {
        for (int slot = 0; slot < destInventory.getSlots() && !stack.m_41619_(); ++slot) {
            stack = ExtractorBlockEntity.insertStack(source, destination, destInventory, stack, slot);
        }
        return stack;
    }

    private static ItemStack insertStack(BlockEntity source, Object destination, IItemHandler destInventory, ItemStack stack, int slot) {
        ItemStack itemstack = destInventory.getStackInSlot(slot);
        if (destInventory.insertItem(slot, stack, true).m_41619_()) {
            ExtractorBlockEntity destinationHopper;
            boolean insertedItem = false;
            boolean inventoryWasEmpty = ExtractorBlockEntity.isEmpty(destInventory);
            if (itemstack.m_41619_()) {
                destInventory.insertItem(slot, stack, false);
                stack = ItemStack.f_41583_;
                insertedItem = true;
            } else if (ItemHandlerHelper.canItemStacksStack((ItemStack)itemstack, (ItemStack)stack)) {
                int originalSize = stack.m_41613_();
                boolean bl = insertedItem = originalSize < (stack = destInventory.insertItem(slot, stack, false)).m_41613_();
            }
            if (insertedItem && inventoryWasEmpty && destination instanceof ExtractorBlockEntity && !(destinationHopper = (ExtractorBlockEntity)destination).isOnCustomCooldown()) {
                int k = 0;
                if (source instanceof ExtractorBlockEntity && destinationHopper.getLastUpdateTime() >= ((ExtractorBlockEntity)source).getLastUpdateTime()) {
                    k = 1;
                }
                destinationHopper.setCooldown(8 - k);
            }
        }
        return stack;
    }

    private boolean ejectItems() {
        if (ExtractorBlockEntity.insertHook(this)) {
            return true;
        }
        Container iinventory = this.getAttachedContainer();
        if (iinventory == null) {
            return false;
        }
        Direction direction = (Direction)this.m_58900_().m_61143_((Property)HopperBlock.f_54021_);
        if (this.isFullContainer(iinventory, direction)) {
            return false;
        }
        for (int i = 0; i < this.m_6643_(); ++i) {
            if (this.m_8020_(i).m_41619_()) continue;
            ItemStack itemstack = this.m_8020_(i).m_41777_();
            ItemStack itemstack1 = ExtractorBlockEntity.addItem(this, iinventory, this.m_7407_(i, 1), direction);
            if (itemstack1.m_41619_()) {
                iinventory.m_6596_();
                return true;
            }
            this.m_6836_(i, itemstack);
        }
        return false;
    }

    private static IntStream getSlots(Container p_213972_0_, Direction p_213972_1_) {
        return p_213972_0_ instanceof WorldlyContainer ? IntStream.of(((WorldlyContainer)p_213972_0_).m_7071_(p_213972_1_)) : IntStream.range(0, p_213972_0_.m_6643_());
    }

    private boolean isFullContainer(Container p_174919_1_, Direction p_174919_2_) {
        return ExtractorBlockEntity.getSlots(p_174919_1_, p_174919_2_).allMatch(p_213970_1_ -> {
            ItemStack itemstack = p_174919_1_.m_8020_(p_213970_1_);
            return itemstack.m_41613_() >= itemstack.m_41741_();
        });
    }

    private static boolean isEmptyContainer(Container p_174917_0_, Direction p_174917_1_) {
        return ExtractorBlockEntity.getSlots(p_174917_0_, p_174917_1_).allMatch(p_213973_1_ -> p_174917_0_.m_8020_(p_213973_1_).m_41619_());
    }

    @Nullable
    public static Boolean extractHook(ExtractorBlockEntity dest) {
        return ExtractorBlockEntity.getItemHandler(dest, (Direction)dest.m_58900_().m_61143_((Property)ExtractorBlock.f_54021_)).map(itemHandlerResult -> {
            IItemHandler handler = (IItemHandler)itemHandlerResult.getKey();
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack extractItem = handler.extractItem(i, 1, true);
                if (extractItem.m_41619_()) continue;
                for (int j = 0; j < dest.m_6643_(); ++j) {
                    ItemStack destStack = dest.m_8020_(j);
                    if (!dest.m_7013_(j, extractItem) || !destStack.m_41619_() && (destStack.m_41613_() >= destStack.m_41741_() || destStack.m_41613_() >= dest.m_6893_() || !ItemHandlerHelper.canItemStacksStack((ItemStack)extractItem, (ItemStack)destStack))) continue;
                    extractItem = handler.extractItem(i, 1, false);
                    if (destStack.m_41619_()) {
                        dest.m_6836_(j, extractItem);
                    } else {
                        destStack.m_41769_(1);
                        dest.m_6836_(j, destStack);
                    }
                    dest.m_6596_();
                    return true;
                }
            }
            return false;
        }).orElse(null);
    }

    public static boolean suckInItems(ExtractorBlockEntity p_145891_0_) {
        Boolean ret = ExtractorBlockEntity.extractHook(p_145891_0_);
        if (ret != null) {
            return ret;
        }
        Container iinventory = ExtractorBlockEntity.getSourceContainer(p_145891_0_, p_145891_0_.m_58900_());
        if (iinventory != null) {
            Direction direction = Direction.DOWN;
            switch ((Direction)p_145891_0_.m_58900_().m_61143_((Property)HopperBlock.f_54021_)) {
                case EAST: {
                    direction = Direction.WEST;
                    break;
                }
                case NORTH: {
                    direction = Direction.SOUTH;
                    break;
                }
                case SOUTH: {
                    direction = Direction.NORTH;
                    break;
                }
                case WEST: {
                    direction = Direction.EAST;
                }
            }
            Direction finalDirection = direction;
            return ExtractorBlockEntity.isEmptyContainer(iinventory, finalDirection) ? false : ExtractorBlockEntity.getSlots(iinventory, finalDirection).anyMatch(p_213971_3_ -> ExtractorBlockEntity.tryTakeInItemFromSlot(p_145891_0_, iinventory, p_213971_3_, finalDirection));
        }
        for (ItemEntity itementity : ExtractorBlockEntity.getFrontalItems(p_145891_0_, p_145891_0_.m_58900_())) {
            if (!ExtractorBlockEntity.addItem(p_145891_0_, itementity)) continue;
            return true;
        }
        return false;
    }

    private static boolean tryTakeInItemFromSlot(IHorizontalHopper p_174915_0_, Container p_174915_1_, int p_174915_2_, Direction p_174915_3_) {
        ItemStack itemstack = p_174915_1_.m_8020_(p_174915_2_);
        if (!itemstack.m_41619_() && ExtractorBlockEntity.canTakeItemFromContainer(p_174915_1_, itemstack, p_174915_2_, p_174915_3_)) {
            ItemStack itemstack1 = itemstack.m_41777_();
            ItemStack itemstack2 = ExtractorBlockEntity.addItem(p_174915_1_, p_174915_0_, p_174915_1_.m_7407_(p_174915_2_, 1), null);
            if (itemstack2.m_41619_()) {
                p_174915_1_.m_6596_();
                return true;
            }
            p_174915_1_.m_6836_(p_174915_2_, itemstack1);
        }
        return false;
    }

    public static boolean addItem(Container p_200114_0_, ItemEntity p_200114_1_) {
        boolean flag = false;
        ItemStack itemstack = p_200114_1_.m_32055_().m_41777_();
        ItemStack itemstack1 = ExtractorBlockEntity.addItem(null, p_200114_0_, itemstack, null);
        if (itemstack1.m_41619_()) {
            flag = true;
            p_200114_1_.m_146870_();
        } else {
            p_200114_1_.m_32045_(itemstack1);
        }
        return flag;
    }

    public static ItemStack addItem(@Nullable Container p_59327_, Container p_59328_, ItemStack p_59329_, @Nullable Direction p_59330_) {
        if (p_59328_ instanceof WorldlyContainer && p_59330_ != null) {
            WorldlyContainer worldlycontainer = (WorldlyContainer)p_59328_;
            int[] aint = worldlycontainer.m_7071_(p_59330_);
            for (int k = 0; k < aint.length && !p_59329_.m_41619_(); ++k) {
                p_59329_ = ExtractorBlockEntity.tryMoveInItem(p_59327_, p_59328_, p_59329_, aint[k], p_59330_);
            }
        } else {
            int i = p_59328_.m_6643_();
            for (int j = 0; j < i && !p_59329_.m_41619_(); ++j) {
                p_59329_ = ExtractorBlockEntity.tryMoveInItem(p_59327_, p_59328_, p_59329_, j, p_59330_);
            }
        }
        return p_59329_;
    }

    private static boolean canPlaceItemInContainer(Container p_174920_0_, ItemStack p_174920_1_, int p_174920_2_, @Nullable Direction p_174920_3_) {
        if (!p_174920_0_.m_7013_(p_174920_2_, p_174920_1_)) {
            return false;
        }
        return !(p_174920_0_ instanceof WorldlyContainer) || ((WorldlyContainer)p_174920_0_).m_7155_(p_174920_2_, p_174920_1_, p_174920_3_);
    }

    private static boolean canTakeItemFromContainer(Container p_174921_0_, ItemStack p_174921_1_, int p_174921_2_, Direction p_174921_3_) {
        return !(p_174921_0_ instanceof WorldlyContainer) || ((WorldlyContainer)p_174921_0_).m_7157_(p_174921_2_, p_174921_1_, p_174921_3_);
    }

    private static ItemStack tryMoveInItem(@Nullable Container p_174916_0_, Container p_174916_1_, ItemStack p_174916_2_, int p_174916_3_, @Nullable Direction p_174916_4_) {
        ItemStack itemstack = p_174916_1_.m_8020_(p_174916_3_);
        if (ExtractorBlockEntity.canPlaceItemInContainer(p_174916_1_, p_174916_2_, p_174916_3_, p_174916_4_)) {
            boolean flag = false;
            boolean flag1 = p_174916_1_.m_7983_();
            if (itemstack.m_41619_()) {
                p_174916_1_.m_6836_(p_174916_3_, p_174916_2_);
                p_174916_2_ = ItemStack.f_41583_;
                flag = true;
            } else if (ExtractorBlockEntity.canMergeItems(itemstack, p_174916_2_)) {
                int i = p_174916_2_.m_41741_() - itemstack.m_41613_();
                int j = Math.min(p_174916_2_.m_41613_(), i);
                p_174916_2_.m_41774_(j);
                itemstack.m_41769_(j);
                boolean bl = flag = j > 0;
            }
            if (flag) {
                ExtractorBlockEntity ExtractorBlockEntity1;
                if (flag1 && p_174916_1_ instanceof ExtractorBlockEntity && !(ExtractorBlockEntity1 = (ExtractorBlockEntity)p_174916_1_).isOnCustomCooldown()) {
                    int k = 0;
                    if (p_174916_0_ instanceof ExtractorBlockEntity) {
                        ExtractorBlockEntity ExtractorBlockEntity2 = (ExtractorBlockEntity)p_174916_0_;
                        if (ExtractorBlockEntity1.tickedGameTime >= ExtractorBlockEntity2.tickedGameTime) {
                            k = 1;
                        }
                    }
                    ExtractorBlockEntity1.setCooldown(8 - k);
                }
                p_174916_1_.m_6596_();
            }
        }
        return p_174916_2_;
    }

    @Nullable
    private Container getAttachedContainer() {
        Direction direction = ((Direction)this.m_58900_().m_61143_((Property)HopperBlock.f_54021_)).m_122424_();
        return ExtractorBlockEntity.getContainerAt(this.getHopperLevel(), this.f_58858_.m_121945_(direction));
    }

    @Nullable
    public static Container getSourceContainer(IHorizontalHopper p_145884_0_, BlockState state) {
        switch ((Direction)state.m_61143_((Property)HopperBlock.f_54021_)) {
            case EAST: {
                return ExtractorBlockEntity.getContainerAt(p_145884_0_.getHopperLevel(), p_145884_0_.getLevelX() + 1.0, p_145884_0_.getLevelY(), p_145884_0_.getLevelZ());
            }
            case NORTH: {
                return ExtractorBlockEntity.getContainerAt(p_145884_0_.getHopperLevel(), p_145884_0_.getLevelX(), p_145884_0_.getLevelY(), p_145884_0_.getLevelZ() - 1.0);
            }
            case SOUTH: {
                return ExtractorBlockEntity.getContainerAt(p_145884_0_.getHopperLevel(), p_145884_0_.getLevelX(), p_145884_0_.getLevelY(), p_145884_0_.getLevelZ() + 1.0);
            }
            case WEST: {
                return ExtractorBlockEntity.getContainerAt(p_145884_0_.getHopperLevel(), p_145884_0_.getLevelX() - 1.0, p_145884_0_.getLevelY(), p_145884_0_.getLevelZ());
            }
        }
        return ExtractorBlockEntity.getContainerAt(p_145884_0_.getHopperLevel(), p_145884_0_.getLevelX(), p_145884_0_.getLevelY() + 1.0, p_145884_0_.getLevelZ());
    }

    public static List<ItemEntity> getFrontalItems(IHorizontalHopper p_200115_0_, BlockState state) {
        return p_200115_0_.getSuckShape(state).m_83299_().stream().flatMap(p_200110_1_ -> p_200115_0_.getHopperLevel().m_6443_(ItemEntity.class, p_200110_1_.m_82386_(p_200115_0_.getLevelX() - 0.5, p_200115_0_.getLevelY() - 0.5, p_200115_0_.getLevelZ() - 0.5), EntitySelector.f_20402_).stream()).collect(Collectors.toList());
    }

    @Nullable
    public static Container getContainerAt(Level p_195484_0_, BlockPos p_195484_1_) {
        return ExtractorBlockEntity.getContainerAt(p_195484_0_, (double)p_195484_1_.m_123341_() + 0.5, (double)p_195484_1_.m_123342_() + 0.5, (double)p_195484_1_.m_123343_() + 0.5);
    }

    @Nullable
    public static Container getContainerAt(Level p_145893_0_, double p_145893_1_, double p_145893_3_, double p_145893_5_) {
        List list;
        BlockEntity tileentity;
        WorldlyContainer iinventory = null;
        BlockPos blockpos = BlockPos.m_274561_((double)p_145893_1_, (double)p_145893_3_, (double)p_145893_5_);
        BlockState blockstate = p_145893_0_.m_8055_(blockpos);
        Block block = blockstate.m_60734_();
        if (block instanceof WorldlyContainerHolder) {
            iinventory = ((WorldlyContainerHolder)block).m_5840_(blockstate, (LevelAccessor)p_145893_0_, blockpos);
        } else if (blockstate.m_155947_() && (tileentity = p_145893_0_.m_7702_(blockpos)) instanceof Container && (iinventory = (Container)tileentity) instanceof ChestBlockEntity && block instanceof ChestBlock) {
            iinventory = ChestBlock.m_51511_((ChestBlock)((ChestBlock)block), (BlockState)blockstate, (Level)p_145893_0_, (BlockPos)blockpos, (boolean)true);
        }
        if (iinventory == null && !(list = p_145893_0_.m_6249_((Entity)null, new AABB(p_145893_1_ - 0.5, p_145893_3_ - 0.5, p_145893_5_ - 0.5, p_145893_1_ + 0.5, p_145893_3_ + 0.5, p_145893_5_ + 0.5), EntitySelector.f_20405_)).isEmpty()) {
            iinventory = (Container)list.get(p_145893_0_.f_46441_.m_188503_(list.size()));
        }
        return iinventory;
    }

    private static boolean canMergeItems(ItemStack p_145894_0_, ItemStack p_145894_1_) {
        if (p_145894_0_.m_41720_() != p_145894_1_.m_41720_()) {
            return false;
        }
        if (p_145894_0_.m_41773_() != p_145894_1_.m_41773_()) {
            return false;
        }
        if (p_145894_0_.m_41613_() > p_145894_0_.m_41741_()) {
            return false;
        }
        return ItemStack.m_150942_((ItemStack)p_145894_0_, (ItemStack)p_145894_1_);
    }

    @Override
    public double getLevelX() {
        return (double)this.f_58858_.m_123341_() + 0.5;
    }

    @Override
    public double getLevelY() {
        return (double)this.f_58858_.m_123342_() + 0.5;
    }

    @Override
    public double getLevelZ() {
        return (double)this.f_58858_.m_123343_() + 0.5;
    }

    public void setCooldown(int p_145896_1_) {
        this.cooldownTime = p_145896_1_;
    }

    private boolean isOnCooldown() {
        return this.cooldownTime > 0;
    }

    public boolean isOnCustomCooldown() {
        return this.cooldownTime > 8;
    }

    protected NonNullList<ItemStack> m_7086_() {
        return this.items;
    }

    protected void m_6520_(NonNullList<ItemStack> p_199721_1_) {
        this.items = p_199721_1_;
    }

    public void entityInside(Entity p_200113_1_) {
        if (p_200113_1_ instanceof ItemEntity) {
            BlockPos blockpos = this.m_58899_();
            if (Shapes.m_83157_((VoxelShape)Shapes.m_83064_((AABB)p_200113_1_.m_20191_().m_82386_((double)(-blockpos.m_123341_()), (double)(-blockpos.m_123342_()), (double)(-blockpos.m_123343_()))), (VoxelShape)this.getSuckShape(this.m_58900_()), (BooleanOp)BooleanOp.f_82689_)) {
                this.tryMoveItems(() -> ExtractorBlockEntity.addItem(this, (ItemEntity)p_200113_1_));
            }
        }
    }

    protected AbstractContainerMenu m_6555_(int p_213906_1_, Inventory p_213906_2_) {
        return new HopperMenu(p_213906_1_, p_213906_2_, (Container)this);
    }

    protected IItemHandler createUnSidedHandler() {
        return new ExtractorItemHandler(this);
    }

    public long getLastUpdateTime() {
        return this.tickedGameTime;
    }
}

