/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.renderer.tileentity;

import com.dairymoose.modernlife.blocks.ModernBookshelfBlock;
import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.tileentities.ModernBookshelfBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ModernBookshelfBlockEntityRenderer
implements BlockEntityRenderer<ModernBookshelfBlockEntity> {
    private static final Logger LOGGER = LogManager.getLogger();
    public static ItemStack renderBook = null;
    public static int renderRgb0 = 0;
    public static int renderRgb1 = 0;
    public static Map<Item, Integer> rgb0ForItem = new HashMap<Item, Integer>();
    public static Map<Item, Integer> rgb1ForItem = new HashMap<Item, Integer>();
    private boolean didRenderErrorMsg = false;

    public ModernBookshelfBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    private int reverseEndianness(int input) {
        return (input & 0xFF) << 24 | (input & 0xFF00) << 8 | (input & 0xFF0000) >>> 8 | (input & 0xFF000000) >>> 24;
    }

    public void render(ModernBookshelfBlockEntity tileEntity, float v, PoseStack matrixStack, MultiBufferSource iRenderTypeBuffer, int lightmap, int i1) {
        if (!tileEntity.m_7983_()) {
            for (int i = 0; i < tileEntity.m_6643_(); ++i) {
                ItemStack itemStack;
                block28: {
                    List quads;
                    itemStack = tileEntity.m_8020_(i);
                    if (itemStack.m_41619_()) continue;
                    matrixStack.m_85836_();
                    if (tileEntity.m_58900_().m_61143_((Property)ModernBookshelfBlock.FACING) == Direction.EAST) {
                        matrixStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                        matrixStack.m_85837_(-0.9375, 0.5, 0.0);
                    } else if (tileEntity.m_58900_().m_61143_((Property)ModernBookshelfBlock.FACING) == Direction.NORTH) {
                        matrixStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                        matrixStack.m_85837_(-0.9375, 0.5, -1.0);
                    } else if (tileEntity.m_58900_().m_61143_((Property)ModernBookshelfBlock.FACING) == Direction.WEST) {
                        matrixStack.m_252781_(Axis.f_252436_.m_252977_(270.0f));
                        matrixStack.m_85837_(0.0625, 0.5, -1.0);
                    } else if (tileEntity.m_58900_().m_61143_((Property)ModernBookshelfBlock.FACING) == Direction.SOUTH) {
                        matrixStack.m_85837_(0.0625, 0.5, 0.0);
                    }
                    List<Double> yList = null;
                    if (tileEntity.m_58903_() == ModernBookshelfBlockEntity.MODERN_BOOKSHELF) {
                        yList = ModernBookshelfBlockEntity.itemPosY;
                    }
                    matrixStack.m_85837_(ModernBookshelfBlockEntity.itemPosX.get(i % ModernBookshelfBlockEntity.itemPosX.size()).doubleValue(), yList.get(i % yList.size()).doubleValue(), ModernBookshelfBlockEntity.itemPosZ.get(i % ModernBookshelfBlockEntity.itemPosZ.size()).doubleValue());
                    matrixStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                    renderBook = itemStack;
                    HashMap<Integer, Integer> colorCount = new HashMap<Integer, Integer>();
                    TextureAtlasSprite sprite = null;
                    BakedModel bm = Minecraft.m_91087_().m_91291_().m_174264_(itemStack, null, null, i);
                    if (bm != null && (quads = bm.m_213637_(null, null, RandomSource.m_216327_())) != null && !quads.isEmpty()) {
                        sprite = ((BakedQuad)quads.get(0)).m_173410_();
                    }
                    int mostCommonRgb = 0;
                    int secondMostCommonRgb = 0;
                    Integer lookupRgb0 = rgb0ForItem.get(itemStack.m_41720_());
                    Integer lookupRgb1 = rgb1ForItem.get(itemStack.m_41720_());
                    if (lookupRgb0 == null) {
                        if (sprite != null) {
                            for (int x = 0; x < sprite.m_245424_().m_246492_(); ++x) {
                                for (int y = 0; y < sprite.m_245424_().m_245330_(); ++y) {
                                    int rgba = sprite.getPixelRGBA(0, x, y);
                                    int rgb = rgba & 0xFFFFFF;
                                    int a = (rgba & 0xFF000000) >>> 24;
                                    if (a != 255) continue;
                                    Integer count = (Integer)colorCount.get(rgb);
                                    if (count == null) {
                                        count = 0;
                                    }
                                    count = count + 1;
                                    colorCount.put(rgb, count);
                                }
                            }
                            int highestIndex = 0;
                            for (Integer rgb : colorCount.keySet()) {
                                Integer highestCount = (Integer)colorCount.get(highestIndex);
                                Integer count = (Integer)colorCount.get(rgb);
                                if (highestCount != null && count <= highestCount) continue;
                                highestIndex = rgb;
                            }
                            Integer highestCount = (Integer)colorCount.get(highestIndex);
                            int secondHighestIndex = 0;
                            for (Integer rgb : colorCount.keySet()) {
                                Integer secondHighestCount = (Integer)colorCount.get(secondHighestIndex);
                                Integer count = (Integer)colorCount.get(rgb);
                                if (secondHighestCount != null && (count <= secondHighestCount || count >= highestCount)) continue;
                                secondHighestIndex = rgb;
                            }
                            mostCommonRgb = this.reverseEndianness(highestIndex) >> 8;
                            secondMostCommonRgb = this.reverseEndianness(secondHighestIndex) >> 8;
                        } else {
                            mostCommonRgb = 0x7F7F7F;
                            secondMostCommonRgb = 0;
                        }
                        rgb0ForItem.put(itemStack.m_41720_(), mostCommonRgb);
                        rgb1ForItem.put(itemStack.m_41720_(), secondMostCommonRgb);
                    } else {
                        mostCommonRgb = lookupRgb0;
                        secondMostCommonRgb = lookupRgb1;
                    }
                    renderRgb0 = mostCommonRgb;
                    renderRgb1 = secondMostCommonRgb;
                    float yScale = tileEntity.bookHeight.get(i).floatValue();
                    yScale = 1.0f;
                    matrixStack.m_85841_(1.0f, yScale, 1.0f);
                    ItemStack toRender = new ItemStack((ItemLike)CustomBlocks.BLOCK_MODERN_BOOK.get());
                    try {
                        PoseStack itemPoseStack = new PoseStack();
                        itemPoseStack.m_252931_(matrixStack.m_85850_().m_252922_());
                        Minecraft.m_91087_().m_91291_().m_269128_(toRender, ItemDisplayContext.NONE, lightmap, i1, itemPoseStack, iRenderTypeBuffer, tileEntity.m_58904_(), i);
                    }
                    catch (Exception e) {
                        if (this.didRenderErrorMsg) break block28;
                        this.didRenderErrorMsg = true;
                        LOGGER.error("Error while rendering book item in shelf, mixin incompatibility?", (Throwable)e);
                    }
                }
                matrixStack.m_252880_(-0.013f, -0.245f, -0.1755f);
                float scaleValue = -0.003f;
                String displayText = itemStack.m_41786_().getString();
                String storedName = (String)tileEntity.bookNames.get(i);
                if (!storedName.isBlank()) {
                    displayText = storedName;
                }
                int textLength = displayText.length();
                int MAX_TEXT_LENGTH = 14;
                if (textLength > 14) {
                    int overMaxDiff = textLength - 14;
                    scaleValue += (float)overMaxDiff * 8.0E-5f;
                }
                if ((double)scaleValue > 0.0) {
                    scaleValue = 0.1f;
                }
                matrixStack.m_85841_(scaleValue, scaleValue, scaleValue);
                matrixStack.m_252781_(Axis.f_252403_.m_252977_(90.0f));
                float lightmapPct = (float)lightmap / 200.0f;
                if (lightmapPct < 0.2f) {
                    lightmapPct = 0.2f;
                } else if (lightmapPct > 0.9f) {
                    lightmapPct = 0.9f;
                }
                int textR = (int)(255.0f * lightmapPct);
                int textG = (int)(255.0f * lightmapPct);
                int textB = (int)(255.0f * lightmapPct);
                int textColor = textR << 16 | textG << 8 | textB;
                MutableComponent displayComponent = MutableComponent.m_237204_((ComponentContents)new LiteralContents(displayText));
                Style displayStyle = displayComponent.m_7383_();
                GuiGraphics graphics = new GuiGraphics(Minecraft.m_91087_(), Minecraft.m_91087_().m_91269_().m_110104_());
                graphics.m_280168_().m_166856_();
                graphics.m_280168_().m_252931_(matrixStack.m_85850_().m_252922_());
                Font font = Minecraft.m_91087_().f_91062_;
                Minecraft.m_91087_();
                graphics.m_280614_(font, (Component)displayComponent.m_130948_(displayStyle.m_131150_(Minecraft.f_91058_).m_131136_(Boolean.valueOf(true))), 0, 0, textColor, false);
                matrixStack.m_85849_();
            }
        }
    }
}

