/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.network.play.client;

import com.dairymoose.inventory.container.TrashCanContainer;
import com.dairymoose.modernlife.core.ModernLifeCommon;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerGamePacketListener;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerboundTrashCanPacket
implements Packet<ServerGamePacketListener> {
    private int containerId;
    private ItemStack toTrash = ItemStack.f_41583_;
    private static final Logger LOGGER = LogManager.getLogger();

    public ServerboundTrashCanPacket() {
    }

    public ServerboundTrashCanPacket(FriendlyByteBuf buffer) {
        this.read(buffer);
    }

    public ServerboundTrashCanPacket(int containerId, ItemStack toTrash) {
        this.containerId = containerId;
        this.toTrash = toTrash;
    }

    public void read(FriendlyByteBuf p_148837_1_) {
        this.containerId = p_148837_1_.readInt();
        this.toTrash = p_148837_1_.m_130267_();
    }

    public void m_5779_(FriendlyByteBuf p_148840_1_) {
        p_148840_1_.writeInt(this.containerId);
        p_148840_1_.m_130055_(this.toTrash);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            this.handle((ServerGamePacketListener)((NetworkEvent.Context)ctx.get()).getNetworkManager().m_129538_());
        });
        ctx.get().setPacketHandled(true);
    }

    public static boolean playerHasItem(Player player, ItemStack item) {
        return ItemStack.m_41656_((ItemStack)player.f_36096_.m_38853_(0).m_7993_(), (ItemStack)item);
    }

    public void handle(ServerGamePacketListener p_148833_1_) {
        ModernLifeCommon.LOGGER.debug("Handle ServerboundTrashCanPacket");
        if (p_148833_1_ instanceof ServerGamePacketListenerImpl) {
            ServerGamePacketListenerImpl serverHandler = (ServerGamePacketListenerImpl)p_148833_1_;
            serverHandler.f_9743_.m_9243_();
            if (serverHandler.f_9743_.f_36096_.f_38840_ == this.containerId && !serverHandler.f_9743_.m_5833_() && serverHandler.f_9743_.f_36096_ instanceof TrashCanContainer) {
                TrashCanContainer trashCanContainer = (TrashCanContainer)serverHandler.f_9743_.f_36096_;
                if (ServerboundTrashCanPacket.playerHasItem((Player)serverHandler.f_9743_, this.toTrash)) {
                    trashCanContainer.trashItem(this.toTrash);
                    serverHandler.f_9743_.f_36096_.m_38946_();
                }
            }
        }
    }
}

