/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.network.play.client;

import com.dairymoose.modernlife.blocks.EaselBlock;
import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.core.ModernLifeCommon;
import com.dairymoose.modernlife.core.ModernLifeConfig;
import com.dairymoose.modernlife.network.play.client.ServerboundMultipartCameraPacket;
import com.dairymoose.modernlife.tileentities.EaselBlockEntity;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerboundMultipartEaselPacket
implements Packet<ServerGamePacketListener> {
    private int seqNo;
    private boolean last;
    private byte[] image;
    private int texWidth;
    private int texHeight;
    private BlockPos easelPos;
    private static final Logger LOGGER = LogManager.getLogger();
    private static Map<Player, List<ServerboundMultipartEaselPacket>> canvasPackets = new HashMap<Player, List<ServerboundMultipartEaselPacket>>();

    public ServerboundMultipartEaselPacket() {
    }

    public ServerboundMultipartEaselPacket(int seqNo, boolean last, byte[] image, int texWidth, int texHeight, BlockPos easelPos) {
        this.seqNo = seqNo;
        this.last = last;
        this.image = image;
        this.texWidth = texWidth;
        this.texHeight = texHeight;
        this.easelPos = easelPos;
    }

    public ServerboundMultipartEaselPacket(FriendlyByteBuf buffer) {
        this.read(buffer);
    }

    public void read(FriendlyByteBuf buffer) {
        this.seqNo = buffer.readInt();
        this.last = buffer.readBoolean();
        this.image = buffer.m_130052_();
        this.texWidth = buffer.readInt();
        this.texHeight = buffer.readInt();
        this.easelPos = buffer.m_130135_();
    }

    public void m_5779_(FriendlyByteBuf buffer) {
        buffer.writeInt(this.seqNo);
        buffer.writeBoolean(this.last);
        buffer.m_130087_(this.image);
        buffer.writeInt(this.texWidth);
        buffer.writeInt(this.texHeight);
        buffer.m_130064_(this.easelPos);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            this.handle((ServerGamePacketListener)((NetworkEvent.Context)ctx.get()).getNetworkManager().m_129538_());
        });
        ctx.get().setPacketHandled(true);
    }

    private ServerboundMultipartEaselPacket getLastPacket(List<ServerboundMultipartEaselPacket> packets) {
        for (ServerboundMultipartEaselPacket packet : packets) {
            if (!packet.last) continue;
            return packet;
        }
        return null;
    }

    public void handle(ServerGamePacketListener p_148833_1_) {
        ModernLifeCommon.LOGGER.debug("Handle CMultipartCanvasPacket");
        if (this.easelPos == null) {
            return;
        }
        if (p_148833_1_ instanceof ServerGamePacketListenerImpl) {
            ServerGamePacketListenerImpl serverHandler = (ServerGamePacketListenerImpl)p_148833_1_;
            CompoundTag nbt = new CompoundTag();
            ServerLevel world = serverHandler.f_9743_.m_284548_();
            ModernLifeCommon.LOGGER.debug("world = " + (Level)world);
            if (world != null && world.m_46749_(this.easelPos)) {
                BlockState easelState = world.m_8055_(this.easelPos);
                ModernLifeCommon.LOGGER.debug("easelState = " + easelState);
                if (easelState != null && easelState.m_60713_((Block)CustomBlocks.BLOCK_EASEL.get()) && !((Boolean)easelState.m_61143_((Property)EaselBlock.EMPTY)).booleanValue()) {
                    List<ServerboundMultipartEaselPacket> packets = canvasPackets.get(serverHandler.f_9743_);
                    if (packets == null) {
                        packets = new ArrayList<ServerboundMultipartEaselPacket>();
                        canvasPackets.put((Player)serverHandler.f_9743_, packets);
                    }
                    packets.add(this);
                    ServerboundMultipartEaselPacket lastPacket = this.getLastPacket(packets);
                    byte[] stitchedImage = null;
                    ByteArrayOutputStream stream = new ByteArrayOutputStream();
                    ModernLifeCommon.LOGGER.debug("packets.size = " + packets.size() + ", lastPacket = " + lastPacket);
                    if (lastPacket != null && packets.size() == lastPacket.seqNo) {
                        packets.sort(new Comparator<ServerboundMultipartEaselPacket>(){

                            @Override
                            public int compare(ServerboundMultipartEaselPacket var1, ServerboundMultipartEaselPacket var2) {
                                return var1.seqNo - var2.seqNo;
                            }
                        });
                        for (ServerboundMultipartEaselPacket packet : packets) {
                            try {
                                stream.write(packet.image);
                            }
                            catch (IOException e) {
                                ModernLifeCommon.LOGGER.debug("error writing image part", (Throwable)e);
                            }
                        }
                        stitchedImage = stream.toByteArray();
                    }
                    if (stitchedImage != null) {
                        ModernLifeCommon.LOGGER.debug("image length = " + stitchedImage.length);
                    }
                    int maxTexSizeW = 512;
                    int maxTexSizeH = 512;
                    Integer configIntW = (Integer)ModernLifeConfig.COMMON.cameraResolutionW.get();
                    Integer configIntH = (Integer)ModernLifeConfig.COMMON.cameraResolutionH.get();
                    if (configIntW != null) {
                        maxTexSizeW = configIntW;
                    }
                    if (configIntH != null) {
                        maxTexSizeH = configIntH;
                    }
                    if (stitchedImage != null && stitchedImage.length != 0 && stitchedImage.length <= ServerboundMultipartCameraPacket.MAX_IMAGE_LENGTH(maxTexSizeW) && this.texWidth <= maxTexSizeW && this.texHeight <= maxTexSizeH) {
                        packets.clear();
                        ModernLifeCommon.LOGGER.debug("easelPos = " + this.easelPos);
                        BlockEntity tileEntity = world.m_46745_(this.easelPos).m_7702_(this.easelPos);
                        ModernLifeCommon.LOGGER.debug("tileEntity = " + tileEntity);
                        if (tileEntity instanceof EaselBlockEntity) {
                            EaselBlockEntity easelBlockEntity = (EaselBlockEntity)tileEntity;
                            ItemStack currentItem = easelBlockEntity.m_8020_(0).m_41777_();
                            if (easelBlockEntity != null) {
                                world.m_46597_(this.easelPos, (BlockState)easelState.m_61124_((Property)EaselBlock.EMPTY, (Comparable)Boolean.valueOf(true)));
                                int texSize = 64;
                                if (this.texWidth > 0) {
                                    // empty if block
                                }
                                ItemStack itemStack = currentItem;
                                long uniqueId = 0L;
                                if (itemStack.m_41783_() != null && itemStack.m_41783_().m_128441_("UniqueId")) {
                                    uniqueId = itemStack.m_41783_().m_128454_("UniqueId");
                                }
                                if (itemStack.m_41783_() != null && itemStack.m_41783_().m_128441_("TextureSize")) {
                                    texSize = itemStack.m_41783_().m_128451_("TextureSize");
                                    this.texWidth = itemStack.m_41783_().m_128451_("TextureWidth");
                                    this.texHeight = itemStack.m_41783_().m_128451_("TextureHeight");
                                }
                                if (uniqueId == 0L) {
                                    uniqueId = ModernLifeCommon.getNextCanvasId();
                                }
                                ServerboundMultipartCameraPacket.saveImage(uniqueId, stitchedImage, this.texWidth, this.texHeight);
                                itemStack.m_41784_().m_128356_("UniqueId", uniqueId);
                                itemStack.m_41784_().m_128405_("TextureSize", texSize);
                                itemStack.m_41784_().m_128405_("TextureWidth", this.texWidth);
                                itemStack.m_41784_().m_128405_("TextureHeight", this.texHeight);
                                serverHandler.f_9743_.m_36356_(itemStack);
                                easelBlockEntity.m_6836_(0, ItemStack.f_41583_);
                                ServerboundMultipartCameraPacket.pushImageUpdate(itemStack);
                            }
                        }
                    } else if (stitchedImage != null) {
                        packets.clear();
                        ModernLifeCommon.LOGGER.error("incoming image (" + this.texWidth + "/" + this.texHeight + "/" + maxTexSizeW + "/" + maxTexSizeH + ") is too big: " + stitchedImage.length + "/" + ServerboundMultipartCameraPacket.MAX_IMAGE_LENGTH(maxTexSizeW));
                    }
                }
            }
        }
    }

    public byte[] getImage() {
        return this.image;
    }
}

