/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.network.play.client;

import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.core.ModernLifeCommon;
import com.dairymoose.modernlife.core.ModernLifeConfig;
import com.dairymoose.modernlife.items.HandgunItem;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerboundHitscanPacket
implements Packet<ServerGamePacketListener> {
    private BlockPos blockPos;
    private int entityId;
    private Vec3 location;
    private Direction direction;
    private static final Logger LOGGER = LogManager.getLogger();

    public ServerboundHitscanPacket() {
    }

    public ServerboundHitscanPacket(FriendlyByteBuf buffer) {
        this.read(buffer);
    }

    public ServerboundHitscanPacket(BlockPos blockPos, int entityId, Vec3 location, Direction direction) {
        this.blockPos = blockPos;
        this.entityId = entityId;
        this.location = location;
        this.direction = direction;
    }

    public void read(FriendlyByteBuf p_148837_1_) {
        this.blockPos = p_148837_1_.m_130135_();
        this.entityId = p_148837_1_.readInt();
        this.location = new Vec3(p_148837_1_.readDouble(), p_148837_1_.readDouble(), p_148837_1_.readDouble());
        int dirValue = p_148837_1_.readInt();
        this.direction = dirValue == -1 ? null : Direction.m_122376_((int)dirValue);
    }

    public void m_5779_(FriendlyByteBuf p_148840_1_) {
        p_148840_1_.m_130064_(this.blockPos);
        p_148840_1_.writeInt(this.entityId);
        p_148840_1_.writeDouble(this.location.f_82479_);
        p_148840_1_.writeDouble(this.location.f_82480_);
        p_148840_1_.writeDouble(this.location.f_82481_);
        if (this.direction == null) {
            p_148840_1_.writeInt(-1);
        } else {
            p_148840_1_.writeInt(this.direction.m_122411_());
        }
    }

    public static void playGunSound(Level world, Player player, BlockPos pos) {
        if (world == null) {
            return;
        }
        float volume = 2.0f;
        float pitch = 1.2f;
        float pitchRange = 0.6f;
        float pitchRand = (float)((double)pitchRange * Math.random());
        world.m_5594_(player, player.m_20183_(), (SoundEvent)CustomBlocks.SOUND_GUN_FIRE.get(), SoundSource.BLOCKS, volume, pitch += (pitchRand -= pitchRange / 2.0f));
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            this.handle((ServerGamePacketListener)((NetworkEvent.Context)ctx.get()).getNetworkManager().m_129538_());
        });
        ctx.get().setPacketHandled(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(ServerGamePacketListener p_148833_1_) {
        ModernLifeCommon.LOGGER.debug("Handle ServerboundHitscanPacket");
        if (p_148833_1_ instanceof ServerGamePacketListenerImpl) {
            ItemStack itemStack;
            ServerGamePacketListenerImpl serverHandler = (ServerGamePacketListenerImpl)p_148833_1_;
            ServerLevel world = serverHandler.f_9743_.m_284548_();
            if (world != null && world instanceof ServerLevel && (itemStack = serverHandler.f_9743_.m_21205_()).m_41720_() == CustomBlocks.ITEM_HANDGUN.get() && ((HandgunItem)((Object)CustomBlocks.ITEM_HANDGUN.get())).removeAmmo((Player)serverHandler.f_9743_, 1)) {
                Entity entity;
                ServerLevel ServerLevel2 = world;
                SimpleParticleType particleType = ParticleTypes.f_123796_;
                ParticleType particles = (ParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(ForgeRegistries.PARTICLE_TYPES.getKey((Object)ParticleTypes.f_123794_));
                BlockState state = world.m_8055_(this.blockPos);
                if (!state.m_60795_()) {
                    BlockParticleOption blockParticle = new BlockParticleOption(particles, state);
                    ServerLevel2.m_8767_((ParticleOptions)blockParticle, this.location.f_82479_, this.location.f_82480_, this.location.f_82481_, 30, 0.1, 0.1, 0.1, 0.1);
                }
                if ((entity = world.m_6815_(this.entityId)) instanceof LivingEntity) {
                    float foreheadHeight = entity.m_20206_() - entity.m_20192_();
                    boolean headShot = this.location.f_82480_ >= entity.m_20188_() - (double)foreheadHeight;
                    int particleCount = 20;
                    int initialInvulnerableTime = entity.f_19802_;
                    try {
                        entity.f_19802_ = 0;
                        double baseDamage = 19.5;
                        double critMultiplier = 2.0;
                        boolean canHeadshot = true;
                        Double configDamage = (Double)ModernLifeConfig.SERVER.handgunDamage.get();
                        Double configCritMult = (Double)ModernLifeConfig.SERVER.handgunCritMultiplier.get();
                        Boolean configEnableHeadshots = (Boolean)ModernLifeConfig.SERVER.handgunEnableHeadshots.get();
                        if (configDamage != null) {
                            baseDamage = configDamage;
                        }
                        if (configCritMult != null) {
                            critMultiplier = configCritMult;
                        }
                        if (configEnableHeadshots != null) {
                            canHeadshot = configEnableHeadshots;
                        }
                        if (!canHeadshot) {
                            headShot = false;
                        }
                        if (headShot) {
                            entity.m_6469_(world.m_269111_().m_269075_((Player)serverHandler.f_9743_), (float)(baseDamage * critMultiplier));
                            particleCount = 60;
                        } else {
                            entity.m_6469_(world.m_269111_().m_269075_((Player)serverHandler.f_9743_), (float)baseDamage);
                        }
                        if (this.entityId != -1) {
                            particleType = ParticleTypes.f_123784_;
                            ServerLevel2.m_8767_((ParticleOptions)particleType, this.location.f_82479_, this.location.f_82480_, this.location.f_82481_, particleCount, 0.1, 0.1, 0.1, 0.1);
                        }
                    }
                    finally {
                        entity.f_19802_ = initialInvulnerableTime;
                    }
                }
                if (this.entityId == -1) {
                    ((HandgunItem)((Object)CustomBlocks.ITEM_HANDGUN.get())).hitBlockPos((Player)serverHandler.f_9743_, (Level)ServerLevel2, itemStack, this.blockPos, this.location, this.direction);
                }
                ServerboundHitscanPacket.playGunSound((Level)world, (Player)serverHandler.f_9743_, serverHandler.f_9743_.m_20183_());
            }
        }
    }
}

