/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.network.play.client;

import com.dairymoose.entity.MotorboatEntity;
import com.dairymoose.modernlife.core.ModernLifeCommon;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerboundFuelLevelPacket
implements Packet<ServerGamePacketListener> {
    private float fuelLevel;
    private int entityId;
    private static final Logger LOGGER = LogManager.getLogger();

    public ServerboundFuelLevelPacket() {
    }

    public ServerboundFuelLevelPacket(FriendlyByteBuf buffer) {
        this.read(buffer);
    }

    public ServerboundFuelLevelPacket(float fuelLevel, int entityId) {
        this.fuelLevel = fuelLevel;
        this.entityId = entityId;
    }

    public void read(FriendlyByteBuf p_148837_1_) {
        this.fuelLevel = p_148837_1_.readFloat();
        this.entityId = p_148837_1_.readInt();
    }

    public void m_5779_(FriendlyByteBuf p_148840_1_) {
        p_148840_1_.writeFloat(this.fuelLevel);
        p_148840_1_.writeInt(this.entityId);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            this.handle((ServerGamePacketListener)((NetworkEvent.Context)ctx.get()).getNetworkManager().m_129538_());
        });
        ctx.get().setPacketHandled(true);
    }

    public void handle(ServerGamePacketListener p_148833_1_) {
        ModernLifeCommon.LOGGER.debug("Handle ServerboundFuelLevelPacket");
        if (p_148833_1_ instanceof ServerGamePacketListenerImpl) {
            Entity e;
            ServerGamePacketListenerImpl serverHandler = (ServerGamePacketListenerImpl)p_148833_1_;
            ServerLevel world = serverHandler.f_9743_.m_284548_();
            ModernLifeCommon.LOGGER.debug("world = " + (Level)world);
            if (world != null && (e = world.m_6815_(this.entityId)) instanceof MotorboatEntity) {
                MotorboatEntity motorboat = (MotorboatEntity)e;
                motorboat.setSyncedFuelLevel(this.fuelLevel);
            }
        }
    }
}

