/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.network.play.client;

import com.dairymoose.modernlife.items.ChainsawItem;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerGamePacketListener;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerboundChainsawTargetPacket
implements Packet<ServerGamePacketListener> {
    private BlockHitResult rayTrace;
    private int targetedEntityId;
    private static final Logger LOGGER = LogManager.getLogger();

    public ServerboundChainsawTargetPacket() {
    }

    public ServerboundChainsawTargetPacket(FriendlyByteBuf buffer) {
        this.read(buffer);
    }

    public ServerboundChainsawTargetPacket(BlockHitResult rayTrace, int targetedEntityId) {
        this.rayTrace = rayTrace;
        this.targetedEntityId = targetedEntityId;
    }

    public void read(FriendlyByteBuf packet) {
        this.rayTrace = packet.m_130283_();
        this.targetedEntityId = packet.readInt();
    }

    public void m_5779_(FriendlyByteBuf packet) {
        if (this.rayTrace == null) {
            this.rayTrace = BlockHitResult.m_82426_((Vec3)new Vec3(0.0, 0.0, 0.0), (Direction)Direction.UP, (BlockPos)new BlockPos(0, 0, 0));
        }
        packet.m_130062_(this.rayTrace);
        packet.writeInt(this.targetedEntityId);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            this.handle((ServerGamePacketListener)((NetworkEvent.Context)ctx.get()).getNetworkManager().m_129538_());
        });
        ctx.get().setPacketHandled(true);
    }

    public void handle(ServerGamePacketListener iServerHandler) {
        if (iServerHandler instanceof ServerGamePacketListenerImpl) {
            ChainsawItem.MiningInfo mInfo;
            ServerGamePacketListenerImpl serverHandler = (ServerGamePacketListenerImpl)iServerHandler;
            if (this.rayTrace == null) {
                this.rayTrace = BlockHitResult.m_82426_((Vec3)new Vec3(0.0, 0.0, 0.0), (Direction)Direction.UP, (BlockPos)new BlockPos(0, 0, 0));
            }
            if ((mInfo = ChainsawItem.mineMap.get(serverHandler.f_9743_)) == null) {
                mInfo = new ChainsawItem.MiningInfo();
                ChainsawItem.mineMap.put((Player)serverHandler.f_9743_, mInfo);
            }
            if (this.targetedEntityId != -1) {
                Entity entity = serverHandler.f_9743_.m_9236_().m_6815_(this.targetedEntityId);
                if (entity != null) {
                    mInfo.rayTrace = this.rayTrace == null ? new EntityHitResult(entity) : new EntityHitResult(entity, this.rayTrace.m_82450_());
                }
            } else {
                mInfo.rayTrace = this.rayTrace;
            }
        }
    }
}

