/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.network.play.client;

import com.dairymoose.modernlife.blocks.EaselBlock;
import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.core.ModernLifeCommon;
import com.dairymoose.modernlife.tileentities.EaselBlockEntity;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerboundCanvasPacket
implements Packet<ServerGamePacketListener> {
    private byte[] image;
    private BlockPos easelPos;
    private static final Logger LOGGER = LogManager.getLogger();
    private boolean enabled = false;

    public ServerboundCanvasPacket() {
    }

    public ServerboundCanvasPacket(byte[] image, BlockPos easelPos) {
        this.image = image;
        this.easelPos = easelPos;
        ModernLifeCommon.LOGGER.debug("image length = " + image.length);
    }

    public ServerboundCanvasPacket(FriendlyByteBuf buffer) {
        this.read(buffer);
    }

    public void read(FriendlyByteBuf buffer) {
        this.image = buffer.m_130052_();
        this.easelPos = buffer.m_130135_();
    }

    public void m_5779_(FriendlyByteBuf buffer) {
        buffer.m_130087_(this.image);
        buffer.m_130064_(this.easelPos);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            this.handle((ServerGamePacketListener)((NetworkEvent.Context)ctx.get()).getNetworkManager().m_129538_());
        });
        ctx.get().setPacketHandled(true);
    }

    public void handle(ServerGamePacketListener p_148833_1_) {
        if (!this.enabled) {
            return;
        }
        ModernLifeCommon.LOGGER.debug("Handle ServerboundCanvasPacket");
        if (this.easelPos == null) {
            return;
        }
        if (p_148833_1_ instanceof ServerGamePacketListenerImpl) {
            ServerGamePacketListenerImpl serverHandler = (ServerGamePacketListenerImpl)p_148833_1_;
            CompoundTag nbt = new CompoundTag();
            ServerLevel world = serverHandler.f_9743_.m_284548_();
            ModernLifeCommon.LOGGER.debug("world = " + (Level)world);
            if (world != null && world.m_46749_(this.easelPos)) {
                BlockState easelState = world.m_8055_(this.easelPos);
                ModernLifeCommon.LOGGER.debug("easelState = " + easelState);
                if (easelState != null && easelState.m_60713_((Block)CustomBlocks.BLOCK_EASEL.get()) && !((Boolean)easelState.m_61143_((Property)EaselBlock.EMPTY)).booleanValue() && this.image != null && this.image.length != 0 && this.image.length < 100000) {
                    ModernLifeCommon.LOGGER.debug("easelPos = " + this.easelPos);
                    BlockEntity tileEntity = world.m_46745_(this.easelPos).m_7702_(this.easelPos);
                    ModernLifeCommon.LOGGER.debug("tileEntity = " + tileEntity);
                    if (tileEntity instanceof EaselBlockEntity) {
                        EaselBlockEntity easelBlockEntity = (EaselBlockEntity)tileEntity;
                        ItemStack currentItem = easelBlockEntity.m_8020_(0).m_41777_();
                        if (easelBlockEntity != null) {
                            world.m_46597_(this.easelPos, (BlockState)easelState.m_61124_((Property)EaselBlock.EMPTY, (Comparable)Boolean.valueOf(true)));
                            ItemStack itemStack = currentItem;
                            itemStack.m_41784_().m_128382_("image", this.image);
                            serverHandler.f_9743_.m_36356_(itemStack);
                            easelBlockEntity.m_6836_(0, ItemStack.f_41583_);
                        }
                    }
                }
            }
        }
    }

    public byte[] getImage() {
        return this.image;
    }
}

