/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.network.play.client;

import com.dairymoose.modernlife.core.ModernLifeCommon;
import com.dairymoose.modernlife.tileentities.PhotocopierBlockEntity;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerboundCanvasCopyRequestPacket
implements Packet<ServerGamePacketListener> {
    private static final Logger LOGGER = LogManager.getLogger();
    private long uniqueId = -1L;
    private int numberOfCopies = 0;
    private BlockPos pos;
    private CompoundTag nbt;

    public ServerboundCanvasCopyRequestPacket() {
    }

    public ServerboundCanvasCopyRequestPacket(long uniqueId, int numberOfCopies, CompoundTag nbt, BlockPos pos) {
        this.uniqueId = uniqueId;
        this.numberOfCopies = numberOfCopies;
        this.pos = pos;
        if (nbt == null) {
            nbt = new CompoundTag();
        }
        this.nbt = nbt;
    }

    public ServerboundCanvasCopyRequestPacket(FriendlyByteBuf buffer) {
        this.read(buffer);
    }

    public void read(FriendlyByteBuf buffer) {
        this.uniqueId = buffer.readLong();
        this.numberOfCopies = buffer.readInt();
        this.pos = buffer.m_130135_();
        this.nbt = buffer.m_130260_();
    }

    public void m_5779_(FriendlyByteBuf buffer) {
        buffer.writeLong(this.uniqueId);
        buffer.writeInt(this.numberOfCopies);
        buffer.m_130064_(this.pos);
        buffer.m_130079_(this.nbt);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            this.handle((ServerGamePacketListener)((NetworkEvent.Context)ctx.get()).getNetworkManager().m_129538_());
        });
        ctx.get().setPacketHandled(true);
    }

    public static int sanitizeNumberOfCopies(int numberOfCopies) {
        if (numberOfCopies < 0) {
            numberOfCopies = 0;
        }
        if (numberOfCopies > 5) {
            numberOfCopies = 5;
        }
        return numberOfCopies;
    }

    public void handle(ServerGamePacketListener listener) {
        ModernLifeCommon.LOGGER.debug("Handle ServerboundCanvasCopyRequestPacket");
        if (this.uniqueId < 0L) {
            return;
        }
        if (listener instanceof ServerGamePacketListenerImpl) {
            BlockEntity entity;
            ServerGamePacketListenerImpl handler = (ServerGamePacketListenerImpl)listener;
            this.numberOfCopies = ServerboundCanvasCopyRequestPacket.sanitizeNumberOfCopies(this.numberOfCopies);
            ServerLevel level = handler.m_142253_().m_284548_();
            if (level.m_46749_(this.pos) && (entity = level.m_7702_(this.pos)) instanceof PhotocopierBlockEntity) {
                PhotocopierBlockEntity photocopier = (PhotocopierBlockEntity)entity;
                photocopier.addTaskToQueue(this.uniqueId, this.nbt, this.numberOfCopies);
            }
        }
    }
}

