/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.network.play.client;

import com.dairymoose.modernlife.core.ModernLifeCommon;
import com.dairymoose.modernlife.network.play.client.ServerboundMultipartCameraPacket;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerGamePacketListener;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerboundCanvasChecksumPacket
implements Packet<ServerGamePacketListener> {
    private static final Logger LOGGER = LogManager.getLogger();
    private long uniqueId = -1L;
    private int checksum = 0;

    public ServerboundCanvasChecksumPacket() {
    }

    public ServerboundCanvasChecksumPacket(long uniqueId, int checksum) {
        this.uniqueId = uniqueId;
        this.checksum = checksum;
    }

    public ServerboundCanvasChecksumPacket(FriendlyByteBuf buffer) {
        this.read(buffer);
    }

    public void read(FriendlyByteBuf buffer) {
        this.uniqueId = buffer.readLong();
        this.checksum = buffer.readInt();
    }

    public void m_5779_(FriendlyByteBuf buffer) {
        buffer.writeLong(this.uniqueId);
        buffer.writeInt(this.checksum);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            this.handle((ServerGamePacketListener)((NetworkEvent.Context)ctx.get()).getNetworkManager().m_129538_());
        });
        ctx.get().setPacketHandled(true);
    }

    public void handle(ServerGamePacketListener listener) {
        ModernLifeCommon.LOGGER.debug("Handle ServerboundCanvasChecksumPacket");
        if (this.uniqueId < 0L) {
            return;
        }
        if (listener instanceof ServerGamePacketListenerImpl) {
            ServerGamePacketListenerImpl handler = (ServerGamePacketListenerImpl)listener;
            long timestamp = System.currentTimeMillis();
            ServerboundMultipartCameraPacket.CanvasHashCodeData chcd = ServerboundMultipartCameraPacket.canvasHashCodes.get(this.uniqueId);
            Integer hashCode = null;
            hashCode = chcd == null ? Integer.valueOf(ModernLifeCommon.recomputeOneChecksum(this.uniqueId)) : chcd.hashCode;
            ModernLifeCommon.LOGGER.debug("Checksum verification for " + this.uniqueId + ", server=" + hashCode + ", client=" + this.checksum);
            if (hashCode != this.checksum) {
                String playerName = "";
                if (handler.f_9743_ != null && handler.f_9743_.m_7755_() != null) {
                    playerName = handler.f_9743_.m_7755_().getString();
                }
                ModernLifeCommon.LOGGER.info("Client checksum mismatch on image " + this.uniqueId + ", pushing image update to player " + playerName);
                ServerboundMultipartCameraPacket.pushImageUpdate(this.uniqueId, handler.f_9743_);
            }
        }
    }
}

