/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.network.play.client;

import com.dairymoose.modernlife.blocks.ModernBookshelfBlock;
import com.dairymoose.modernlife.core.ModernLifeCommon;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerGamePacketListener;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerboundBookCancelPacket
implements Packet<ServerGamePacketListener> {
    private int oldItemSlot;
    private BlockPos bookshelfBlockPos;
    private static final Logger LOGGER = LogManager.getLogger();

    public ServerboundBookCancelPacket() {
    }

    public ServerboundBookCancelPacket(FriendlyByteBuf buffer) {
        this.read(buffer);
    }

    public ServerboundBookCancelPacket(int oldItemSlot, BlockPos bookshelfBlockPos) {
        this.oldItemSlot = oldItemSlot;
        this.bookshelfBlockPos = bookshelfBlockPos;
    }

    public void read(FriendlyByteBuf byteBuf) {
        this.oldItemSlot = byteBuf.readInt();
        this.bookshelfBlockPos = byteBuf.m_130135_();
    }

    public void m_5779_(FriendlyByteBuf byteBuf) {
        byteBuf.writeInt(this.oldItemSlot);
        if (this.bookshelfBlockPos == null) {
            this.bookshelfBlockPos = new BlockPos(0, 0, 0);
        }
        byteBuf.m_130064_(this.bookshelfBlockPos);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            this.handle((ServerGamePacketListener)((NetworkEvent.Context)ctx.get()).getNetworkManager().m_129538_());
        });
        ctx.get().setPacketHandled(true);
    }

    public static void execute(BlockPos bookshelfBlockPos, int oldItemSlot, Player player) {
        BlockState state;
        Block block;
        if (bookshelfBlockPos != null && player.m_9236_().m_46749_(bookshelfBlockPos) && (block = (state = player.m_9236_().m_8055_(bookshelfBlockPos)).m_60734_()) instanceof ModernBookshelfBlock) {
            block.m_6227_(state, player.m_9236_(), bookshelfBlockPos, player, InteractionHand.MAIN_HAND, null);
            if (player.m_21120_(InteractionHand.MAIN_HAND).m_41619_()) {
                ItemStack itemStack = player.m_150109_().m_8020_(oldItemSlot);
                player.m_21008_(InteractionHand.MAIN_HAND, itemStack);
                player.m_150109_().m_6836_(oldItemSlot, ItemStack.f_41583_);
            }
        }
    }

    public void handle(ServerGamePacketListener p_148833_1_) {
        ModernLifeCommon.LOGGER.debug("Handle ServerboundBookCancelPacket");
        if (p_148833_1_ instanceof ServerGamePacketListenerImpl) {
            ServerGamePacketListenerImpl serverHandler = (ServerGamePacketListenerImpl)p_148833_1_;
            if (this.oldItemSlot != -1) {
                ServerboundBookCancelPacket.execute(this.bookshelfBlockPos, this.oldItemSlot, (Player)serverHandler.f_9743_);
            }
        }
    }
}

