/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.items;

import com.dairymoose.entity.DummyEntity;
import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.core.ModernLifeNetwork;
import com.dairymoose.modernlife.network.play.client.ClientboundBulletHolePacket;
import com.dairymoose.modernlife.network.play.client.ServerboundHitscanPacket;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HandgunItem
extends DiggerItem {
    public static final int FIRING_TICK_MAX = 6;
    public static final int RELOADING_TICK_MAX = 30;
    public static int reloadingTick = -1;
    public static Map<Player, Integer> firingTickMap = new ConcurrentHashMap<Player, Integer>();
    public static long lastShotTimestamp = 0L;
    public static double originalFov = -1.0;
    public static final float handgunZoomFactor = 1.5f;
    public static final float DESTROY_INCREMENT = 0.49f;
    public static Map<Player, MiningInfo> mineMap = new HashMap<Player, MiningInfo>();
    private static final Logger LOGGER = LogManager.getLogger();

    public HandgunItem(Tier p_i48530_1_, float p_i48530_2_, float p_i48530_3_, Item.Properties p_i48530_4_) {
        super(p_i48530_2_, p_i48530_3_, p_i48530_1_, BlockTags.f_13035_, p_i48530_4_);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        return true;
    }

    public boolean onDroppedByPlayer(ItemStack item, Player player) {
        HandgunItem.resetFov();
        return super.onDroppedByPlayer(item, player);
    }

    public void hitBlockPos(Player player, Level world, ItemStack itemStack, BlockPos pos, Vec3 loc, Direction direction) {
        BlockState state = world.m_8055_(pos);
        ItemStack stoneSword = new ItemStack(new ItemLike(){

            public Item m_5456_() {
                return Items.f_42425_;
            }
        });
        float speed = ((SwordItem)stoneSword.m_41720_()).m_8102_(stoneSword, state);
        boolean destroyed = false;
        if (speed >= 1.5f || state.m_204336_(BlockTags.f_13047_)) {
            world.m_46961_(pos, true);
            destroyed = true;
        } else {
            float destroySpeed = state.m_60800_((BlockGetter)world, pos);
            MiningInfo mInfo = mineMap.get(player);
            if (mInfo == null) {
                mInfo = new MiningInfo();
                mineMap.put(player, mInfo);
            }
            if (!pos.equals((Object)mInfo.pos)) {
                mInfo.pos = pos;
                if (destroySpeed < 0.0f) {
                    mInfo.pos = null;
                }
                mInfo.miningValue = destroySpeed;
                mInfo.miningInitialValue = destroySpeed;
            }
            if (mInfo.miningInitialValue > 0.0f) {
                mInfo.miningValue -= 0.49f;
            }
            if (mInfo.miningInitialValue > 0.0f) {
                if (mInfo.miningValue <= 0.0f) {
                    world.m_6801_(-1, pos, 10);
                    world.m_46961_(pos, true);
                    destroyed = true;
                    mInfo.pos = null;
                    mInfo.miningInitialValue = -1.0f;
                } else {
                    int progressVal = (int)(10.0 * (1.0 - (double)(mInfo.miningValue / mInfo.miningInitialValue)));
                    world.m_6801_(-1, pos, progressVal);
                }
            }
        }
        if (!destroyed) {
            int holeNo = (int)(Math.random() * 3.0);
            ModernLifeNetwork.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new ClientboundBulletHolePacket(player.m_19879_(), loc, pos, holeNo, direction, player.m_9236_().m_46472_().m_135782_().toString()));
        }
    }

    public boolean hasAmmo(Player player) {
        for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
            ItemStack itemStack = (ItemStack)player.m_150109_().f_35974_.get(i);
            if (itemStack == null || itemStack.m_41720_() != CustomBlocks.ITEM_MAGAZINE.get() && itemStack.m_41720_() != CustomBlocks.ITEM_EXTENDED_MAGAZINE.get()) continue;
            return true;
        }
        return false;
    }

    public boolean removeAmmo(Player player, int ammo) {
        for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
            ItemStack itemStack = (ItemStack)player.m_150109_().f_35974_.get(i);
            if (itemStack == null || itemStack.m_41720_() != CustomBlocks.ITEM_MAGAZINE.get() && itemStack.m_41720_() != CustomBlocks.ITEM_EXTENDED_MAGAZINE.get()) continue;
            itemStack.m_41622_(ammo, (LivingEntity)player, (Consumer)new Consumer<Player>(){

                @Override
                public void accept(Player t) {
                }
            });
            return true;
        }
        return false;
    }

    public int getCurrentMagazineAmmo(Player player) {
        for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
            ItemStack itemStack = (ItemStack)player.m_150109_().f_35974_.get(i);
            if (itemStack == null || itemStack.m_41720_() != CustomBlocks.ITEM_MAGAZINE.get() && itemStack.m_41720_() != CustomBlocks.ITEM_EXTENDED_MAGAZINE.get()) continue;
            int remaining = itemStack.m_41776_() - itemStack.m_41773_();
            return remaining;
        }
        return 0;
    }

    public int getCurrentMagazineCapacity(Player player) {
        for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
            ItemStack itemStack = (ItemStack)player.m_150109_().f_35974_.get(i);
            if (itemStack == null || itemStack.m_41720_() != CustomBlocks.ITEM_MAGAZINE.get() && itemStack.m_41720_() != CustomBlocks.ITEM_EXTENDED_MAGAZINE.get()) continue;
            return itemStack.m_41776_();
        }
        return 0;
    }

    public int getAmmoTotal(Player player) {
        int total = 0;
        for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
            ItemStack itemStack = (ItemStack)player.m_150109_().f_35974_.get(i);
            if (itemStack == null || itemStack.m_41720_() != CustomBlocks.ITEM_MAGAZINE.get() && itemStack.m_41720_() != CustomBlocks.ITEM_EXTENDED_MAGAZINE.get()) continue;
            int remaining = itemStack.m_41776_() - itemStack.m_41773_();
            total += remaining;
        }
        return total;
    }

    public boolean fireGun(Player player) {
        long timeDiff = System.currentTimeMillis() - lastShotTimestamp;
        if (timeDiff >= 275L && (reloadingTick < 0 || reloadingTick == 0 && timeDiff >= 2000L)) {
            reloadingTick = -1;
            if (!this.hasAmmo(player)) {
                player.m_9236_().m_5594_(player, player.m_20183_(), SoundEvents.f_12088_, SoundSource.BLOCKS, 1.0f, 2.0f);
                return false;
            }
            int magAmmo = this.getCurrentMagazineAmmo(player);
            int totalAmmo = this.getAmmoTotal(player);
            lastShotTimestamp = System.currentTimeMillis();
            firingTickMap.put(player, 6);
            HitResult rayTrace = this.getRayTraceForPlayer(player.m_9236_(), player, 500.0);
            BlockPos pos = null;
            int entityId = -1;
            Vec3 location = rayTrace.m_82450_();
            Direction direction = null;
            if (rayTrace instanceof BlockHitResult) {
                BlockHitResult blockRayTrace = (BlockHitResult)rayTrace;
                pos = blockRayTrace.m_82425_();
                direction = blockRayTrace.m_82434_();
            } else if (rayTrace instanceof EntityHitResult) {
                EntityHitResult entityRayTrace = (EntityHitResult)rayTrace;
                pos = entityRayTrace.m_82443_().m_20183_();
                entityId = entityRayTrace.m_82443_().m_19879_();
            }
            ServerboundHitscanPacket.playGunSound(player.m_9236_(), player, pos);
            if (magAmmo == 1 && totalAmmo > 1) {
                reloadingTick = 30;
            }
            ModernLifeNetwork.INSTANCE.sendToServer((Object)new ServerboundHitscanPacket(pos, entityId, location, direction));
            return true;
        }
        return false;
    }

    private HitResult getRayTraceForPlayer(Level world, Player player, double range) {
        boolean useAdsSpread;
        double d0 = range;
        Vec3 entityPos = player.m_20299_(1.0f);
        Vec3 targetPos = entityPos.m_82549_(player.m_20252_(1.0f).m_82490_(range));
        boolean useMovementSpread = true;
        double spreadFactor = 0.0;
        if (useMovementSpread) {
            Vec3 movement = player.m_20184_();
            double offsetFactor = 1800.0;
            boolean useAdsSpread2 = true;
            if (useAdsSpread2 && !player.m_6117_()) {
                offsetFactor *= 2.0;
            }
            spreadFactor = (movement.f_82479_ * movement.f_82479_ + movement.f_82481_ * movement.f_82481_) * offsetFactor;
        }
        if ((useAdsSpread = true) && spreadFactor == 0.0 && !player.m_6117_()) {
            spreadFactor = 4.0;
        }
        if (spreadFactor != 0.0) {
            targetPos = targetPos.m_82520_(Math.random() * spreadFactor - spreadFactor / 2.0, 0.0, Math.random() * spreadFactor - spreadFactor / 2.0);
        }
        BlockHitResult rayTrace = world.m_45547_(new ClipContext(entityPos, targetPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
        Vec3 Vec32 = player.m_20299_(1.0f);
        boolean flag = false;
        int i = 3;
        double d1 = d0;
        d1 *= d1;
        if (rayTrace != null) {
            d1 = rayTrace.m_82450_().m_82557_(Vec32);
        }
        Vec3 Vec31 = player.m_20252_(1.0f);
        Vec3 Vec322 = Vec32.m_82520_(Vec31.f_82479_ * d0, Vec31.f_82480_ * d0, Vec31.f_82481_ * d0);
        if (useMovementSpread) {
            Vec322 = Vec322.m_82520_(Math.random() * spreadFactor - spreadFactor / 2.0, 0.0, Math.random() * spreadFactor - spreadFactor / 2.0);
        }
        float f = 1.0f;
        DummyEntity dummy = new DummyEntity(DummyEntity.DUMMY_ENTITY, world);
        AABB axisalignedbb = player.m_20191_().m_82369_(Vec31.m_82490_(d0)).m_82377_(1.0, 1.0, 1.0);
        EntityHitResult entityHitResult = ProjectileUtil.m_37287_((Entity)dummy, (Vec3)Vec32, (Vec3)Vec322, (AABB)axisalignedbb, entity -> entity != player && !entity.m_5833_() && entity.m_6087_(), (double)d1);
        if (entityHitResult != null) {
            Entity entity1 = entityHitResult.m_82443_();
            Vec3 Vec33 = entityHitResult.m_82450_();
            double d2 = Vec32.m_82557_(Vec33);
            rayTrace = entityHitResult;
        }
        return rayTrace;
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level world, List<Component> text, TooltipFlag flag) {
        text.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("Left click to fire")));
        text.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("Right click to aim down sights")));
        text.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents(" * Requires at least one Magazine in order to shoot")));
    }

    public static void resetFov() {
        originalFov = -1.0;
    }

    public boolean canContinueUsing(ItemStack oldStack, ItemStack newStack) {
        if (oldStack != newStack) {
            HandgunItem.resetFov();
        }
        return super.canContinueUsing(oldStack, newStack);
    }

    public void m_5551_(ItemStack itemStack, Level p_77615_2_, LivingEntity entity, int p_77615_4_) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.m_5810_();
            HandgunItem.resetFov();
        }
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand p_77659_3_) {
        ItemStack itemStack = player.m_21120_(p_77659_3_);
        player.m_6672_(p_77659_3_);
        if (world.f_46443_ && originalFov < 0.0) {
            originalFov = ((Integer)Minecraft.m_91087_().f_91066_.m_231837_().m_231551_()).intValue();
        }
        return InteractionResultHolder.m_19096_((Object)itemStack);
    }

    public static class MiningInfo {
        public float miningInitialValue;
        public float miningValue;
        public BlockPos pos;
    }
}

