/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.items;

import com.dairymoose.modernlife.blocks.PhotonBlock;
import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.core.ModernLifeCommon;
import com.dairymoose.modernlife.core.ModernLifeConfig;
import com.dairymoose.modernlife.core.ModernLifeNetwork;
import com.dairymoose.modernlife.network.play.client.ClientboundFlashlightUpdatePacket;
import com.dairymoose.modernlife.tileentities.PhotonBlockEntity;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FlashlightItem
extends DiggerItem {
    private static final Logger LOGGER = LogManager.getLogger();
    private int tickUpdatePeriod = 4;
    public static Map<Player, Boolean> usingFlashlight = new HashMap<Player, Boolean>();
    private Set<Player> canRelease = new HashSet<Player>();
    private final RandomSource random = RandomSource.m_216327_();

    public FlashlightItem(Tier p_i48530_1_, float p_i48530_2_, float p_i48530_3_, Item.Properties p_i48530_4_) {
        super(p_i48530_2_, p_i48530_3_, p_i48530_1_, BlockTags.f_13035_, p_i48530_4_);
    }

    public boolean onDroppedByPlayer(ItemStack item, Player player) {
        usingFlashlight.put(player, false);
        this.removePhoton((LivingEntity)player);
        return super.onDroppedByPlayer(item, player);
    }

    private boolean tryAddPhoton(Level world, Vec3 scaledView, LivingEntity livingEntity) {
        boolean isWater;
        Vec3 entityPos = livingEntity.m_20299_(1.0f);
        Vec3 photonPos = entityPos.m_82549_(scaledView);
        BlockHitResult result = world.m_45547_(new ClipContext(entityPos, photonPos, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)livingEntity));
        photonPos = result.m_82450_();
        BlockPos photonBlockPos = BlockPos.m_274561_((double)photonPos.f_82479_, (double)photonPos.f_82480_, (double)photonPos.f_82481_);
        BlockState state = world.m_8055_(photonBlockPos);
        if (state.m_60713_((Block)CustomBlocks.BLOCK_PHOTON.get())) {
            if (!((Boolean)state.m_61143_((Property)PhotonBlock.EXTINGUISHED)).booleanValue()) {
                return true;
            }
            world.m_7731_(photonBlockPos, (BlockState)state.m_61124_((Property)PhotonBlock.EXTINGUISHED, (Comparable)Boolean.valueOf(false)), 2);
            return true;
        }
        boolean bl = isWater = state.m_60819_() != null && state.m_60819_().m_192917_((Fluid)Fluids.f_76193_) && state.m_61145_((Property)BlockStateProperties.f_61362_).isEmpty() && state.m_60713_(Blocks.f_49990_);
        if (state.m_60795_() || isWater) {
            world.m_7731_(photonBlockPos, (BlockState)((Block)CustomBlocks.BLOCK_PHOTON.get()).m_49966_().m_61124_((Property)PhotonBlock.WATERLOGGED, (Comparable)Boolean.valueOf(isWater)), 2);
            this.removePhoton(livingEntity);
            PhotonBlockEntity.existingPhotons.add(photonBlockPos);
            PhotonBlockEntity.photonPos.put((Entity)livingEntity, photonBlockPos);
            return true;
        }
        return false;
    }

    public void m_5929_(Level level, LivingEntity livingEntity, ItemStack itemStack, int count) {
        Integer configUpdatePeriod = (Integer)ModernLifeConfig.SERVER.flashlightUpdatePeriod.get();
        if (configUpdatePeriod != null) {
            this.tickUpdatePeriod = configUpdatePeriod;
        }
        if (count % this.tickUpdatePeriod == 0 && livingEntity.m_9236_() instanceof ServerLevel) {
            if (itemStack.m_41773_() < itemStack.m_41776_()) {
                Vec3 scaledView;
                Level world = livingEntity.m_9236_();
                Vec3 view = livingEntity.m_20252_(1.0f);
                float scaleValue = 6.0f;
                Double configRange = (Double)ModernLifeConfig.SERVER.flashlightRange.get();
                if (configRange != null) {
                    scaleValue = configRange.floatValue();
                }
                while (scaleValue >= 0.0f && !this.tryAddPhoton(world, scaledView = view.m_82490_((double)scaleValue), livingEntity)) {
                    scaleValue -= 1.0f;
                }
                itemStack.m_220157_(this.tickUpdatePeriod, this.random, null);
                if (itemStack.m_41773_() >= itemStack.m_41776_()) {
                    itemStack.m_41721_(itemStack.m_41776_());
                    if (livingEntity instanceof Player) {
                        Player player = (Player)livingEntity;
                        usingFlashlight.put(player, false);
                        this.removePhoton(livingEntity);
                    }
                }
            } else {
                this.removePhoton(livingEntity);
            }
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level world, List<Component> text, TooltipFlag flag) {
        String currentMinutes = String.valueOf((int)Math.floor((double)(itemStack.m_41776_() - itemStack.m_41773_()) / 1200.0));
        String maxMinutes = String.valueOf(itemStack.m_41776_() / 1200);
        text.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("Right click to use")));
        text.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("* Using it will deplete the battery but it will not break")));
        text.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("* " + currentMinutes + " minutes remaining before drained")));
        text.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("* Lasts " + maxMinutes + " minutes at full charge")));
        text.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("* Repair durability by using a battery")));
    }

    public int m_8105_(ItemStack stack) {
        return 2700000;
    }

    public void m_6883_(ItemStack itemStack, Level p_77663_2_, Entity p_77663_3_, int p_77663_4_, boolean p_77663_5_) {
    }

    public void m_5551_(ItemStack itemStack, Level world, LivingEntity livingEntity, int p_77615_4_) {
        if (world instanceof ServerLevel && livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (this.canRelease.contains(player)) {
                this.canRelease.remove(player);
                world.m_5594_((Player)null, livingEntity.m_20183_(), SoundEvents.f_12088_, SoundSource.BLOCKS, 0.3f, 1.0f);
                ModernLifeCommon.LOGGER.debug("releaseUsing: " + world);
                this.removePhoton((LivingEntity)player);
            } else {
                this.canRelease.add(player);
            }
        }
    }

    public void removePhoton(LivingEntity livingEntity) {
        BlockPos entityPhoton = PhotonBlockEntity.photonPos.get(livingEntity);
        if (entityPhoton != null) {
            PhotonBlockEntity.existingPhotons.remove(entityPhoton);
            PhotonBlockEntity.photonPos.remove(livingEntity);
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand p_77659_3_) {
        Boolean result;
        ItemStack itemStack = player.m_21120_(p_77659_3_);
        if (world.f_46443_ && !player.equals((Object)Minecraft.m_91087_().f_91074_)) {
            InteractionResultHolder.m_19096_((Object)itemStack);
        }
        if ((result = usingFlashlight.get(player)) == null) {
            result = false;
        }
        result = result == false;
        if (itemStack.m_41773_() >= itemStack.m_41776_()) {
            result = false;
        }
        ModernLifeCommon.LOGGER.debug("flashlight state=" + result);
        world.m_5594_((Player)null, player.m_20183_(), SoundEvents.f_12088_, SoundSource.BLOCKS, 0.3f, 1.0f);
        if (world instanceof ServerLevel) {
            if (!result.booleanValue()) {
                this.removePhoton((LivingEntity)player);
            }
            usingFlashlight.put(player, result);
            ModernLifeNetwork.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new ClientboundFlashlightUpdatePacket(player.m_19879_(), result));
            if (player.m_6117_()) {
                // empty if block
            }
        }
        return InteractionResultHolder.m_19096_((Object)itemStack);
    }
}

