/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.core;

import net.minecraftforge.common.ForgeConfigSpec;

public class ModernLifeClientConfig {
    public final ForgeConfigSpec.BooleanValue enableCameraViewfinder;
    public final ForgeConfigSpec.BooleanValue chainsawSlowsMovementWhenUsed;
    public final ForgeConfigSpec.IntValue emptyCanvasEaselSize;
    public final ForgeConfigSpec.BooleanValue extendedEaselColorPicker;
    public final ForgeConfigSpec.BooleanValue disableMirrorRendering;
    public final ForgeConfigSpec.BooleanValue disableCCTVRendering;
    public final ForgeConfigSpec.ConfigValue<Double> cctvCameraRange;
    public final ForgeConfigSpec.BooleanValue mirrorRendersInSpectatorMode;
    public final ForgeConfigSpec.BooleanValue clock24HoursMode;
    public final ForgeConfigSpec.BooleanValue moonIndicator;
    public final ForgeConfigSpec.IntValue alarmClockTextColorR;
    public final ForgeConfigSpec.IntValue alarmClockTextColorG;
    public final ForgeConfigSpec.IntValue alarmClockTextColorB;
    public final ForgeConfigSpec.BooleanValue showEaselResolutionScreen;
    public final ForgeConfigSpec.IntValue cctvOptifineDrawbuffer;
    public final ForgeConfigSpec.BooleanValue chainsawPlaysIdleSound;
    public final ForgeConfigSpec.IntValue canvasPreviewPixelWidth;
    public final ForgeConfigSpec.IntValue smallCanvasPreviewPixelWidth;
    public final ForgeConfigSpec.ConfigValue<Double> alarmVolume;
    public final ForgeConfigSpec.ConfigValue<Double> alarmPitch;
    public final ForgeConfigSpec.BooleanValue alarmCreatesParticles;

    public ModernLifeClientConfig(ForgeConfigSpec.Builder builder) {
        builder.push("client");
        builder.push("misc");
        this.enableCameraViewfinder = builder.comment("Enables camera viewfinder overlay").translation("config.modernlife.enableCameraViewfinder").define("enableCameraViewfinder", true);
        this.chainsawSlowsMovementWhenUsed = builder.comment("Chainsaw will slow down player movement while in use").translation("config.modernlife.chainsawSlowsMovementWhenUsed").define("chainsawSlowsMovementWhenUsed", false);
        this.disableMirrorRendering = builder.comment("Disables rendering for the Mirror (disabling is recommended for Optifine shaders)").translation("config.modernlife.disableMirrorRendering").define("disableMirrorRendering", false);
        this.disableCCTVRendering = builder.comment("Disables rendering for the CCTV Screen (disabling is recommended for Optifine shaders)").translation("config.modernlife.disableCCTVRendering").define("disableCCTVRendering", false);
        this.cctvCameraRange = builder.comment("Maximum range (in blocks) for CCTV screen to link to a CCTV camera").translation("config.modernlife.cctvCameraRange").define("cctvCameraRange", (Object)50.0);
        this.mirrorRendersInSpectatorMode = builder.comment("Enables mirror (and CCTV Screen) rendering in spectator mode").translation("config.modernlife.mirrorRendersInSpectatorMode").define("mirrorRendersInSpectatorMode", false);
        this.cctvOptifineDrawbuffer = builder.comment("OPTIFINE SHADER SPECIFIC: Use this drawbuffer color attachment for CCTV (and mirror) rendering").translation("config.modernlife.cctvOptifineDrawbuffer").defineInRange("cctvOptifineDrawbuffer", 0, 0, 30);
        this.chainsawPlaysIdleSound = builder.comment("Chainsaw plays idle sound").translation("config.modernlife.chainsawPlaysIdleSound").define("chainsawPlaysIdleSound", true);
        this.canvasPreviewPixelWidth = builder.comment("When mousing over a camera image, how large is the preview width?  (Height determined by aspect ratio)").translation("config.modernlife.canvasPreviewPixelWidth").defineInRange("canvasPreviewPixelWidth", 210, 5, 5000);
        this.smallCanvasPreviewPixelWidth = builder.comment("When mousing over a small image, how large is the preview width? (Height determined by aspect ratio)").translation("config.modernlife.smallCanvasPreviewPixelWidth").defineInRange("smallCanvasPreviewPixelWidth", 80, 5, 5000);
        builder.pop();
        builder.push("easel");
        this.emptyCanvasEaselSize = builder.comment("Resolution in pixels when drawing on an empty easel canvas").translation("config.modernlife.emptyCanvasEaselSize").defineInRange("emptyCanvasEaselSize", 64, 16, 512);
        this.extendedEaselColorPicker = builder.comment("Enables advanced easel color picker").translation("config.modernlife.extendedEaselColorPicker").define("extendedEaselColorPicker", false);
        this.showEaselResolutionScreen = builder.comment("Show easel resolution screen when drawing on an empty easel canvas").translation("config.modernlife.showEaselResolutionScreen").define("showEaselResolutionScreen", false);
        builder.pop();
        builder.push("alarm_clock");
        this.clock24HoursMode = builder.comment("Enables 24-hour mode for alarm clock (no AM/PM)").translation("config.modernlife.clock24HoursMode").define("clock24HoursMode", false);
        this.moonIndicator = builder.comment("Enables alarm clock moon indicator (shows when you can sleep)").translation("config.modernlife.moonIndicator").define("moonIndicator", true);
        this.alarmClockTextColorR = builder.comment("Alarm clock text color (R value in RGB)").translation("config.modernlife.alarmClockTextColorR").defineInRange("alarmClockTextColorR", 249, 0, 255);
        this.alarmClockTextColorG = builder.comment("Alarm clock text color (G value in RGB)").translation("config.modernlife.alarmClockTextColorG").defineInRange("alarmClockTextColorG", 8, 0, 255);
        this.alarmClockTextColorB = builder.comment("Alarm clock text color (B value in RGB)").translation("config.modernlife.alarmClockTextColorB").defineInRange("alarmClockTextColorB", 40, 0, 255);
        builder.pop();
        builder.push("warning_alarm");
        this.alarmVolume = builder.comment("Alarm volume multiplier").translation("config.modernlife.alarmVolume").defineInRange("alarmVolume", 0.7, 0.0, 5.0);
        this.alarmPitch = builder.comment("Alarm pitch multiplier").translation("config.modernlife.alarmPitch").defineInRange("alarmPitch", 1.0, 0.0, 5.0);
        this.alarmCreatesParticles = builder.comment("Alarm should create particles when sounded?").translation("config.modernlife.alarmCreatesParticles").define("alarmCreatesParticles", true);
        builder.pop();
        builder.pop();
    }
}

