/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.core;

import com.dairymoose.entity.BicycleEntity;
import com.dairymoose.entity.BicycleModel;
import com.dairymoose.entity.BicycleRenderer;
import com.dairymoose.entity.DummyEntity;
import com.dairymoose.entity.DummyRenderer;
import com.dairymoose.entity.MotorboatEntity;
import com.dairymoose.entity.MotorboatModel;
import com.dairymoose.entity.MotorboatRenderer;
import com.dairymoose.entity.projectile.ThrownSeedEntity;
import com.dairymoose.inventory.container.TrashCanContainer;
import com.dairymoose.modernlife.blocks.CCTVCameraBlock;
import com.dairymoose.modernlife.blocks.MirrorBlock;
import com.dairymoose.modernlife.blocks.ModernBookshelfBlock;
import com.dairymoose.modernlife.blocks.gui.EaselScreen;
import com.dairymoose.modernlife.blocks.gui.TrashCanScreen;
import com.dairymoose.modernlife.core.AutoRegisterProcessor;
import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.core.ModernLifeCommon;
import com.dairymoose.modernlife.core.ModernLifeConfig;
import com.dairymoose.modernlife.core.ModernLifeNetwork;
import com.dairymoose.modernlife.items.CameraItem;
import com.dairymoose.modernlife.items.ChainsawItem;
import com.dairymoose.modernlife.items.FlashlightItem;
import com.dairymoose.modernlife.items.HandgunItem;
import com.dairymoose.modernlife.items.SpeedometerItem;
import com.dairymoose.modernlife.network.play.client.ServerboundCanvasChecksumPacket;
import com.dairymoose.modernlife.network.play.client.ServerboundMultipartCameraPacket;
import com.dairymoose.modernlife.network.play.client.ServerboundRequestCanvasPacket;
import com.dairymoose.modernlife.network.play.client.ServerboundStopUsingCameraPacket;
import com.dairymoose.modernlife.renderer.tileentity.AlarmClockBlockEntityRenderer;
import com.dairymoose.modernlife.renderer.tileentity.CanvasBlockEntityRenderer;
import com.dairymoose.modernlife.renderer.tileentity.ChessBoardBlockEntityRenderer;
import com.dairymoose.modernlife.renderer.tileentity.MicrowaveBlockEntityRenderer;
import com.dairymoose.modernlife.renderer.tileentity.MirrorBlockEntityRenderer;
import com.dairymoose.modernlife.renderer.tileentity.ModernBookshelfBlockEntityRenderer;
import com.dairymoose.modernlife.renderer.tileentity.StoveBlockEntityRenderer;
import com.dairymoose.modernlife.renderer.tileentity.WallShelfBlockEntityRenderer;
import com.dairymoose.modernlife.renderer.tileentity.WinchBlockEntityRenderer;
import com.dairymoose.modernlife.tileentities.AlarmClockBlockEntity;
import com.dairymoose.modernlife.tileentities.CCTVCameraBlockEntity;
import com.dairymoose.modernlife.tileentities.CanvasBlockEntity;
import com.dairymoose.modernlife.tileentities.ChessBoardBlockEntity;
import com.dairymoose.modernlife.tileentities.MicrowaveBlockEntity;
import com.dairymoose.modernlife.tileentities.MirrorBlockEntity;
import com.dairymoose.modernlife.tileentities.ModernBookshelfBlockEntity;
import com.dairymoose.modernlife.tileentities.PowerReceiverBlockEntity;
import com.dairymoose.modernlife.tileentities.PowerTransmitterBlockEntity;
import com.dairymoose.modernlife.tileentities.StoveBlockEntity;
import com.dairymoose.modernlife.tileentities.WallShelfBlockEntity;
import com.dairymoose.modernlife.tileentities.WinchBlockEntity;
import com.dairymoose.modernlife.util.CanvasData;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.chunk.ChunkRenderDispatcher;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.MovementInputUpdateEvent;
import net.minecraftforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL30;

@OnlyIn(value=Dist.CLIENT)
public class ModernLifeClient {
    public static final String MODID = "modernlife";
    private static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"modernlife");
    private static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"modernlife");
    private static final DeferredRegister<BlockEntityType<?>> TILE_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"modernlife");
    private static final DeferredRegister<SoundEvent> SOUND_EVENTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"modernlife");
    private static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"modernlife");
    private static final DeferredRegister<MenuType<?>> CONTAINERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"modernlife");
    private ResourceLocation CAMERA_VIEWFINDER_LOCATION = new ResourceLocation("modernlife", "textures/item/camera_viewfinder.png");
    private int CAMERA_VIEWFINDER_WIDTH = 256;
    private int CAMERA_VIEWFINDER_HEIGHT = 256;
    private ResourceLocation GUI_MOTORBOAT_LOCATION = new ResourceLocation("modernlife", "textures/gui/gui_motorboat.png");
    private int GUI_MOTORBOAT_TEX_SIZE = 32;
    private int GUI_MOTORBOAT_BORDER_HEIGHT = 8;
    private ResourceLocation BULLET_HOLE_1_TEX = new ResourceLocation("modernlife", "textures/item/bullet_hole_1.png");
    private ResourceLocation BULLET_HOLE_2_TEX = new ResourceLocation("modernlife", "textures/item/bullet_hole_2.png");
    private ResourceLocation BULLET_HOLE_3_TEX = new ResourceLocation("modernlife", "textures/item/bullet_hole_3.png");
    private int BULLET_HOLE_TEX_SIZE = 32;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private static final Logger LOGGER = LogManager.getLogger();
    Queue<BlockEvent.NeighborNotifyEvent> snowEvents = new LinkedList<BlockEvent.NeighborNotifyEvent>();
    private static final boolean ON_OSX = Util.m_137581_() == Util.OS.OSX;
    int capturedWidth = 0;
    int capturedHeight = 0;
    private boolean isMirrorRendering = false;
    DummyEntity currentMirrorCamera = null;
    public static CCTVCameraBlockEntity cctvCurrentCamera = null;
    public static List<BulletHoleInfo> bulletHoles = new ArrayList<BulletHoleInfo>();
    private int renderTicker = 0;
    private static Boolean originalFastRender = null;
    private boolean foundMirror = false;
    static float cameraZoomFactor = 1.0f;
    private static final int CANVAS_CACHE_EXPIRY_MINUTES = 30;
    private static Map<Long, CachedCanvasData> cachedData = new ConcurrentHashMap<Long, CachedCanvasData>();
    private static Map<Long, Long> uniqueIdToTimestampMap = new ConcurrentHashMap<Long, Long>();
    private static Map<Long, Long> uniqueIdToTimestampChecksumMap = new ConcurrentHashMap<Long, Long>();
    static double originalFov = -1.0;

    public ModernLifeClient() {
        ModernLifeCommon mlc = new ModernLifeCommon();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::registerBlockColors);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::registerItemColors);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::registerClientTooltipEvent);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerBlockEntityRenderers() {
        BlockEntityRenderers.m_173590_(CanvasBlockEntity.CANVAS, CanvasBlockEntityRenderer::new);
        BlockEntityRenderers.m_173590_(MicrowaveBlockEntity.MICROWAVE, MicrowaveBlockEntityRenderer::new);
        BlockEntityRenderers.m_173590_(StoveBlockEntity.STOVE, StoveBlockEntityRenderer::new);
        BlockEntityRenderers.m_173590_(ChessBoardBlockEntity.CHESS_BOARD, ChessBoardBlockEntityRenderer::new);
        BlockEntityRenderers.m_173590_(MirrorBlockEntity.MIRROR, MirrorBlockEntityRenderer::new);
        BlockEntityRenderers.m_173590_(AlarmClockBlockEntity.ALARM_CLOCK, AlarmClockBlockEntityRenderer::new);
        BlockEntityRenderers.m_173590_(WallShelfBlockEntity.WALL_SHELF, WallShelfBlockEntityRenderer::new);
        BlockEntityRenderers.m_173590_(WallShelfBlockEntity.DOUBLE_WALL_SHELF, WallShelfBlockEntityRenderer::new);
        BlockEntityRenderers.m_173590_(WinchBlockEntity.WINCH, WinchBlockEntityRenderer::new);
        BlockEntityRenderers.m_173590_(ModernBookshelfBlockEntity.MODERN_BOOKSHELF, ModernBookshelfBlockEntityRenderer::new);
    }

    @SubscribeEvent
    public static void onConfigReloaded(ModConfigEvent.Reloading event) {
        if (ModernLifeConfig.clientSpec.isLoaded()) {
            ModernLifeConfig.reinit();
        }
    }

    private void registerClientTooltipEvent(RegisterClientTooltipComponentFactoriesEvent event) {
        ModernLifeCommon.LOGGER.info("register client tooltip");
        event.register(CanvasPreviewComponent.class, x -> x);
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        AutoRegisterProcessor.processAnnotations(BLOCKS, ITEMS, CustomBlocks.class);
        MenuScreens.m_96206_(TrashCanContainer.TRASH_CAN_CONTAINER_TYPE, TrashCanScreen::new);
        ForgeHooksClient.registerLayerDefinition((ModelLayerLocation)BicycleModel.BICYCLE, BicycleModel::createBodyLayer);
        ForgeHooksClient.registerLayerDefinition((ModelLayerLocation)MotorboatModel.MOTORBOAT, MotorboatModel::createBodyLayer);
        this.registerBlockEntityRenderers();
        AutoRegisterProcessor.processRenderTypes(CustomBlocks.class);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CustomBlocks.BLOCK_BIRCH_GLASS_DOOR.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CustomBlocks.BLOCK_CRIMSON_GLASS_DOOR.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CustomBlocks.BLOCK_DARK_OAK_GLASS_DOOR.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CustomBlocks.BLOCK_IRON_GLASS_DOOR.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CustomBlocks.BLOCK_JUNGLE_GLASS_DOOR.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CustomBlocks.BLOCK_OAK_GLASS_DOOR.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CustomBlocks.BLOCK_SPRUCE_GLASS_DOOR.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CustomBlocks.BLOCK_WARPED_GLASS_DOOR.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CustomBlocks.BLOCK_EXTRACTOR.get()), (RenderType)RenderType.m_110466_());
        EntityRenderers.m_174036_(ThrownSeedEntity.THROWN_SEED_ENTITY, context -> new ThrownItemRenderer(context));
        EntityRenderers.m_174036_(BicycleEntity.BICYCLE_ENTITY, context -> new BicycleRenderer(context));
        EntityRenderers.m_174036_(MotorboatEntity.MOTORBOAT_ENTITY, context -> new MotorboatRenderer(context));
        EntityRenderers.m_174036_(DummyEntity.DUMMY_ENTITY, context -> new DummyRenderer(context));
        ItemProperties.register((Item)((Item)CustomBlocks.ITEM_CHAINSAW.get()), (ResourceLocation)new ResourceLocation(MODID, "running"), (ItemPropertyFunction)new ItemPropertyFunction(){

            public float m_141951_(ItemStack paramItemStack, ClientLevel paramClientLevel, LivingEntity paramLivingEntity, int var4) {
                if (!(paramItemStack.m_41720_() instanceof ChainsawItem) || paramLivingEntity == null) {
                    return 0.0f;
                }
                if (paramLivingEntity.m_6117_() && paramLivingEntity.m_21211_() == paramItemStack) {
                    return 1.0f;
                }
                return 0.0f;
            }
        });
        ItemProperties.register((Item)((Item)CustomBlocks.ITEM_HANDGUN.get()), (ResourceLocation)new ResourceLocation(MODID, "running"), (ItemPropertyFunction)new ItemPropertyFunction(){

            public float m_141951_(ItemStack paramItemStack, ClientLevel paramClientLevel, LivingEntity paramLivingEntity, int var4) {
                if (!(paramItemStack.m_41720_() instanceof HandgunItem) || paramLivingEntity == null) {
                    return 0.0f;
                }
                Integer tickValue = HandgunItem.firingTickMap.get(paramLivingEntity);
                if (tickValue != null && tickValue >= 4) {
                    return 1.0f;
                }
                return 0.0f;
            }
        });
        ItemProperties.register((Item)((Item)CustomBlocks.ITEM_FLASHLIGHT.get()), (ResourceLocation)new ResourceLocation(MODID, "on"), (ItemPropertyFunction)new ItemPropertyFunction(){

            public float m_141951_(ItemStack paramItemStack, ClientLevel paramClientLevel, LivingEntity paramLivingEntity, int var4) {
                if (!(paramItemStack.m_41720_() instanceof FlashlightItem) || paramLivingEntity == null) {
                    return 0.0f;
                }
                Boolean usingFlashlight = FlashlightItem.usingFlashlight.get(paramLivingEntity);
                if (usingFlashlight != null && usingFlashlight.booleanValue() && (paramItemStack.equals(paramLivingEntity.m_21205_()) || paramItemStack.equals(paramLivingEntity.m_21206_()))) {
                    return 1.0f;
                }
                return 0.0f;
            }
        });
    }

    public static MirrorBlockEntity getChosenMirror() {
        MirrorBlockEntity chosenMirror = null;
        double leastDistance = -1.0;
        ArrayList<BlockPos> posToRemove = new ArrayList<BlockPos>();
        for (Map.Entry<BlockPos, MirrorBlockEntity> entry : MirrorBlockEntityRenderer.mirrorMap.entrySet()) {
            BlockPos pos = entry.getKey();
            MirrorBlockEntity mirror = entry.getValue();
            if (!mirror.m_58901_()) continue;
            posToRemove.add(pos);
        }
        for (BlockPos pos : posToRemove) {
            MirrorBlockEntityRenderer.mirrorMap.remove(pos);
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        HitResult picked = null;
        if (player != null) {
            picked = player.m_19907_(100.0, 1.0f, false);
        }
        for (Map.Entry<BlockPos, MirrorBlockEntity> entry : MirrorBlockEntityRenderer.mirrorMap.entrySet()) {
            BlockPos pos = entry.getKey();
            MirrorBlockEntity mirror = entry.getValue();
            if (player == null || picked == null) continue;
            Vec3 pickedLocation = picked.m_82450_();
            double distSqr = pickedLocation.m_82531_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
            double playerDistSqr = player.m_20275_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
            if (!(distSqr < 225.0) || !(playerDistSqr < 225.0)) continue;
            if (leastDistance < 0.0) {
                chosenMirror = mirror;
                leastDistance = distSqr;
                continue;
            }
            if (!(distSqr < leastDistance)) continue;
            chosenMirror = mirror;
            leastDistance = distSqr;
        }
        return chosenMirror;
    }

    float fixYaw(float yaw) {
        if ((yaw %= 360.0f) > 180.0f) {
            yaw -= 360.0f;
        }
        if (yaw < -180.0f) {
            yaw += 360.0f;
        }
        return yaw;
    }

    private double getAngularDifferenceTo(Player player, double mirrorX, double mirrorZ) {
        double playerX = player.m_20185_();
        double playerZ = player.m_20189_();
        double xDiff = playerX - mirrorX;
        double zDiff = playerZ - mirrorZ;
        double angleOfIncidence = Math.toDegrees(Math.atan2(zDiff, xDiff));
        return angleOfIncidence;
    }

    private float getMirrorReflectedYaw(Player player, double mirrorX, double mirrorZ) {
        double angleOfIncidence = this.getAngularDifferenceTo(player, mirrorX, mirrorZ);
        float reflectedYaw = (float)angleOfIncidence;
        reflectedYaw += 90.0f;
        reflectedYaw = this.fixYaw(reflectedYaw);
        return reflectedYaw;
    }

    public static List<CCTVCameraBlockEntity> eligibleCameras(Player player, BlockPos screenPos) {
        ArrayList<CCTVCameraBlockEntity> eligible = new ArrayList<CCTVCameraBlockEntity>();
        if (CCTVCameraBlockEntity.cctvCameras.size() > 0) {
            for (CCTVCameraBlockEntity cctvCamera : CCTVCameraBlockEntity.cctvCameras) {
                BlockPos camPos = cctvCamera.m_58899_();
                Vec3i camVec = new Vec3i(camPos.m_123341_(), camPos.m_123342_(), camPos.m_123343_());
                double blockRange = 50.0;
                Double configRange = (Double)ModernLifeConfig.CLIENT.cctvCameraRange.get();
                if (configRange != null && configRange >= 0.0) {
                    blockRange = configRange;
                }
                if (!player.m_9236_().m_8055_(cctvCamera.m_58899_()).m_60713_((Block)CustomBlocks.BLOCK_CCTV_CAMERA.get()) || !(screenPos.m_123331_(camVec) <= blockRange * blockRange)) continue;
                eligible.add(cctvCamera);
            }
            if (eligible.size() > 1) {
                eligible.sort(new Comparator<CCTVCameraBlockEntity>(){

                    @Override
                    public int compare(CCTVCameraBlockEntity var1, CCTVCameraBlockEntity var2) {
                        return var1.getInternalId() - var2.getInternalId();
                    }
                });
            }
        }
        return eligible;
    }

    private void setupNewCamera(Player player, MirrorBlockEntity chosenMirror, Camera Camera2, ViewportEvent.ComputeCameraAngles event) {
        DummyEntity mirrorCamera;
        if (this.currentMirrorCamera != null) {
            this.currentMirrorCamera.m_146870_();
        }
        this.currentMirrorCamera = mirrorCamera = new DummyEntity(DummyEntity.DUMMY_ENTITY, (Level)Minecraft.m_91087_().f_91073_);
        float yaw = 0.0f;
        if (chosenMirror.m_58900_().m_60734_() == CustomBlocks.BLOCK_CCTV_SCREEN.get()) {
            List<CCTVCameraBlockEntity> cameras;
            cctvCurrentCamera = null;
            if (CCTVCameraBlockEntity.cctvCameras.size() > 0 && (cameras = ModernLifeClient.eligibleCameras(player, chosenMirror.m_58899_())).size() > 0) {
                BlockPos camPos;
                int camNo = chosenMirror.cctvScreenCurrentCamera % cameras.size();
                if (camNo < 0) {
                    camNo = cameras.size() + camNo;
                }
                chosenMirror.cctvScreenCurrentCameraDisplayValue = camNo;
                cctvCurrentCamera = cameras.get(camNo);
                BlockState state = cctvCurrentCamera.m_58900_();
                if (state.m_60713_((Block)CustomBlocks.BLOCK_CCTV_CAMERA.get()) && (camPos = cctvCurrentCamera.m_58899_()) != null) {
                    double camX = (double)camPos.m_123341_() + 0.5;
                    double camY = (double)camPos.m_123342_() - 1.0;
                    double camZ = (double)camPos.m_123343_() + 0.5;
                    Direction facing = (Direction)state.m_61143_((Property)CCTVCameraBlock.FACING);
                    yaw = facing.m_122435_();
                    double viewOffset = 0.08;
                    switch (facing) {
                        case EAST: {
                            camX += viewOffset;
                            break;
                        }
                        case SOUTH: {
                            camZ += viewOffset;
                            break;
                        }
                        case WEST: {
                            camX -= viewOffset;
                            break;
                        }
                        case NORTH: {
                            camZ -= viewOffset;
                        }
                    }
                    yaw = this.fixYaw(yaw);
                    mirrorCamera.m_6034_(camX, camY, camZ);
                    mirrorCamera.m_146922_(yaw);
                    mirrorCamera.m_146926_(0.0f);
                    mirrorCamera.m_146867_();
                }
            }
            if (cctvCurrentCamera == null) {
                MirrorBlockEntityRenderer.mirrorFramebuffer.m_83970_();
                return;
            }
        } else {
            BlockPos mirrorPos = chosenMirror.m_58899_();
            double mirrorX = (double)mirrorPos.m_123341_() + 0.5;
            double mirrorY = (double)mirrorPos.m_123342_() - 1.0;
            double mirrorZ = (double)mirrorPos.m_123343_() + 0.5;
            double mirrorStart = 0.4375;
            if (chosenMirror.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_) == Direction.NORTH) {
                mirrorZ += mirrorStart;
            } else if (chosenMirror.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_) == Direction.EAST) {
                mirrorX -= mirrorStart;
            } else if (chosenMirror.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_) == Direction.SOUTH) {
                mirrorZ -= mirrorStart;
            } else if (chosenMirror.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_) == Direction.WEST) {
                mirrorX += mirrorStart;
            }
            float reflectedYaw = this.getMirrorReflectedYaw(player, mirrorX, mirrorZ);
            if (chosenMirror.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_) == Direction.NORTH) {
                yaw = 180.0f - reflectedYaw;
            } else if (chosenMirror.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_) == Direction.EAST) {
                yaw = -90.0f - (reflectedYaw - 90.0f);
            } else if (chosenMirror.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_) == Direction.SOUTH) {
                yaw = 0.0f - (reflectedYaw - 180.0f);
            } else if (chosenMirror.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_) == Direction.WEST) {
                yaw = 90.0f - (reflectedYaw + 90.0f);
            }
            yaw = this.fixYaw(yaw);
            float yBoost = 0.0f;
            if (chosenMirror.m_58900_().m_60734_() != CustomBlocks.BLOCK_MIRROR.get() && chosenMirror.m_58900_().m_60734_() != CustomBlocks.BLOCK_CCTV_SCREEN.get()) {
                yBoost = 0.25f;
            }
            mirrorCamera.m_6034_(mirrorX, mirrorY + (double)yBoost, mirrorZ);
            mirrorCamera.m_146922_(yaw);
            mirrorCamera.m_146926_(0.0f);
            mirrorCamera.m_146867_();
        }
        Camera2.m_90575_((BlockGetter)Minecraft.m_91087_().f_91073_, (Entity)mirrorCamera, false, false, 1.0f);
        if (event != null) {
            event.setYaw(yaw);
            event.setPitch(0.0f);
        }
    }

    @SubscribeEvent
    public void onCameraSetup(ViewportEvent.ComputeCameraAngles event) {
        if (this.isMirrorRendering) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            MirrorBlockEntity chosenMirror = ModernLifeClient.getChosenMirror();
            if (player != null && chosenMirror != null) {
                Camera Camera2 = event.getCamera();
                this.setupNewCamera((Player)player, chosenMirror, Camera2, event);
            }
        }
    }

    @SubscribeEvent
    public void onRenderLevel(RenderLevelStageEvent renderLevelLastEvent) {
        if (renderLevelLastEvent.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            PoseStack matrixStack = renderLevelLastEvent.getPoseStack();
            matrixStack.m_85836_();
            ArrayList<BulletHoleInfo> bulletHolesToRemove = new ArrayList<BulletHoleInfo>();
            try {
                Vec3 cam = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
                matrixStack.m_85837_(-cam.f_82479_, -cam.f_82480_, -cam.f_82481_);
                for (int i = 0; i < bulletHoles.size(); ++i) {
                    boolean timestampExpired;
                    BulletHoleInfo bulletHole = bulletHoles.get(i);
                    if (!Minecraft.m_91087_().f_91074_.m_9236_().m_46472_().m_135782_().toString().equals(bulletHole.dim) || !Minecraft.m_91087_().f_91074_.m_9236_().m_46749_(bulletHole.pos)) continue;
                    long timeDiff = System.currentTimeMillis() - bulletHole.timestamp;
                    boolean bl = timestampExpired = timeDiff > 60000L;
                    if (!Minecraft.m_91087_().f_91074_.m_9236_().m_8055_(bulletHole.pos).m_60795_() && !timestampExpired) {
                        matrixStack.m_85836_();
                        double yBoost = 0.0;
                        matrixStack.m_85837_(bulletHole.loc.f_82479_, bulletHole.loc.f_82480_ + yBoost, bulletHole.loc.f_82481_);
                        RenderSystem.setShader(GameRenderer::m_172817_);
                        ResourceLocation textureResourceLocation = null;
                        textureResourceLocation = bulletHole.holeNo == 0 ? this.BULLET_HOLE_1_TEX : (bulletHole.holeNo == 1 ? this.BULLET_HOLE_2_TEX : this.BULLET_HOLE_3_TEX);
                        if (bulletHole.facing == Direction.EAST) {
                            matrixStack.m_252781_(Axis.f_252436_.m_252977_(270.0f));
                        } else if (bulletHole.facing == Direction.SOUTH) {
                            matrixStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                        } else if (bulletHole.facing == Direction.WEST) {
                            matrixStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                        } else if (bulletHole.facing == Direction.UP) {
                            matrixStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                        } else if (bulletHole.facing == Direction.DOWN) {
                            matrixStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
                        }
                        matrixStack.m_85837_(0.0, 0.0, -0.001);
                        if (bulletHole.randomDepth == null) {
                            double randomAvoidCollision = Math.random() * 0.001;
                            bulletHole.randomDepth = randomAvoidCollision;
                        }
                        matrixStack.m_85837_(0.0, 0.0, -bulletHole.randomDepth.doubleValue());
                        matrixStack.m_85837_(-0.08, -0.08, 0.0);
                        matrixStack.m_85841_(0.005f, 0.005f, 0.005f);
                        int brightness = Minecraft.m_91087_().f_91074_.m_9236_().m_46803_(bulletHole.pos.m_121945_(bulletHole.facing));
                        if (--brightness < 1) {
                            brightness = 1;
                        }
                        if (brightness > 8) {
                            brightness = 8;
                        }
                        float bright = (float)brightness / 15.0f;
                        RenderSystem.setShader(GameRenderer::m_172817_);
                        RenderSystem.setShaderColor((float)bright, (float)bright, (float)bright, (float)1.0f);
                        GuiGraphics graphics = new GuiGraphics(Minecraft.m_91087_(), Minecraft.m_91087_().m_91269_().m_110104_());
                        graphics.m_280168_().m_166856_();
                        graphics.m_280168_().m_252931_(matrixStack.m_85850_().m_252922_());
                        if (textureResourceLocation != null) {
                            graphics.m_280163_(textureResourceLocation, 0, 0, 0.0f, 0.0f, this.BULLET_HOLE_TEX_SIZE, this.BULLET_HOLE_TEX_SIZE, this.BULLET_HOLE_TEX_SIZE, this.BULLET_HOLE_TEX_SIZE);
                        }
                        matrixStack.m_85849_();
                        continue;
                    }
                    bulletHolesToRemove.add(bulletHole);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bulletHolesToRemove.size() > 0) {
                bulletHoles.removeAll(bulletHolesToRemove);
            }
            matrixStack.m_85849_();
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent e) {
        if (e.phase == TickEvent.Phase.START && e.side == LogicalSide.CLIENT) {
            ArrayList<Player> toRemove = new ArrayList<Player>();
            for (Map.Entry<Player, Integer> entry : HandgunItem.firingTickMap.entrySet()) {
                float progress;
                Player player = entry.getKey();
                Integer tickValue = entry.getValue();
                if (player.m_213877_()) {
                    toRemove.add(player);
                    continue;
                }
                if (tickValue == null || tickValue <= 0) continue;
                if (player.m_19879_() == Minecraft.m_91087_().f_91074_.m_19879_() && (progress = (float)(6 - tickValue) / 6.0f) < 0.4f) {
                    player.m_146926_(player.m_146909_() - 0.5f);
                }
                entry.setValue(tickValue - 1);
            }
            if (toRemove.size() > 0) {
                for (int i = 0; i < toRemove.size(); ++i) {
                    HandgunItem.firingTickMap.remove(toRemove.get(i));
                }
            }
            if (HandgunItem.reloadingTick > 0) {
                if (HandgunItem.reloadingTick == 26) {
                    Minecraft.m_91087_().f_91073_.m_5594_((Player)Minecraft.m_91087_().f_91074_, Minecraft.m_91087_().f_91074_.m_20183_(), (SoundEvent)CustomBlocks.SOUND_GUN_RELOAD.get(), SoundSource.BLOCKS, 1.5f, 1.0f);
                }
                --HandgunItem.reloadingTick;
            }
        }
    }

    public void copyFramebufferTexture(int width, int height, int fboIn, int fboOut) {
        RenderSystem.clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        RenderSystem.clear((int)16640, (boolean)false);
        int drawBufferConfigValue = 0;
        Integer drawBufferConfigOption = (Integer)ModernLifeConfig.CLIENT.cctvOptifineDrawbuffer.get();
        if (drawBufferConfigOption != null) {
            drawBufferConfigValue = drawBufferConfigOption;
        }
        GL30.glBindFramebuffer((int)36009, (int)fboOut);
        GL30.glDrawBuffer((int)(36064 + drawBufferConfigValue));
        GL30.glBindFramebuffer((int)36008, (int)fboIn);
        GL30.glReadBuffer((int)36065);
        GL30.glBlitFramebuffer((int)0, (int)0, (int)width, (int)height, (int)0, (int)0, (int)width, (int)height, (int)16384, (int)9728);
    }

    public Frustum prepareCaptureFrustum(PoseStack poseStack, Vec3 pos, Matrix4f fovMatrix) {
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        double d0 = pos.m_7096_();
        double d1 = pos.m_7098_();
        double d2 = pos.m_7094_();
        Frustum cullingFrustum = new Frustum(matrix4f, fovMatrix);
        cullingFrustum.m_113002_(d0, d1, d2);
        return cullingFrustum;
    }

    public LinkedHashSet<Object> getRenderChunks(Object in) {
        Field f = null;
        try {
            f = Class.forName("net.minecraft.client.renderer.LevelRenderer$RenderChunkStorage").getDeclaredField("f_109411_");
        }
        catch (Exception exception) {
            // empty catch block
        }
        LinkedHashSet result = null;
        try {
            if (f == null) {
                f = Class.forName("net.minecraft.client.renderer.LevelRenderer$RenderChunkStorage").getDeclaredField("renderChunks");
            }
            f.setAccessible(true);
            result = (LinkedHashSet)f.get(in);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public ChunkRenderDispatcher.RenderChunk getRenderChunk(Object renderChunkInfo) {
        Field f = null;
        try {
            f = Class.forName("net.minecraft.client.renderer.LevelRenderer$RenderChunkInfo").getDeclaredField("f_109411_");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ChunkRenderDispatcher.RenderChunk result = null;
        try {
            if (f == null) {
                f = Class.forName("net.minecraft.client.renderer.LevelRenderer$RenderChunkInfo").getDeclaredField("chunk");
            }
            f.setAccessible(true);
            result = (ChunkRenderDispatcher.RenderChunk)f.get(renderChunkInfo);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public void appendFrustum(Frustum frustum, ObjectArrayList<Object> renderChunksInFrustum, AtomicReference<Object> renderChunkStorage) {
        renderChunksInFrustum.clear();
        HashSet existingRenderChunks = new HashSet();
        for (Object renderChunk : renderChunksInFrustum) {
            existingRenderChunks.add(renderChunk);
        }
        for (Object levelrenderer$renderchunkinfo : this.getRenderChunks(renderChunkStorage.get())) {
            if (existingRenderChunks.contains(levelrenderer$renderchunkinfo) || !frustum.m_113029_(this.getRenderChunk(levelrenderer$renderchunkinfo).m_202440_())) continue;
            renderChunksInFrustum.add(levelrenderer$renderchunkinfo);
        }
    }

    @SubscribeEvent
    public void prerenderEvent(TickEvent.RenderTickEvent e) {
        if (e.phase == TickEvent.Phase.START && this.renderTicker++ % 3 == 0) {
            this.foundMirror = false;
            Boolean disableMirrorRender = (Boolean)ModernLifeConfig.CLIENT.disableMirrorRendering.get();
            Boolean disableCCTVRender = (Boolean)ModernLifeConfig.CLIENT.disableCCTVRendering.get();
            if (disableMirrorRender != null && disableMirrorRender.booleanValue() && disableCCTVRender != null && disableCCTVRender.booleanValue()) {
                return;
            }
            Boolean configSpectatorMirror = (Boolean)ModernLifeConfig.CLIENT.mirrorRendersInSpectatorMode.get();
            if (configSpectatorMirror != null && !configSpectatorMirror.booleanValue() && Minecraft.m_91087_() != null && Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91074_.m_5833_()) {
                return;
            }
            MirrorBlockEntity chosenMirror = ModernLifeClient.getChosenMirror();
            if (chosenMirror != null) {
                if (chosenMirror.m_58900_().m_60734_() == CustomBlocks.BLOCK_CCTV_SCREEN.get() && disableCCTVRender != null && disableCCTVRender.booleanValue()) {
                    return;
                }
                if (chosenMirror.m_58900_().m_60734_() != CustomBlocks.BLOCK_CCTV_SCREEN.get() && disableMirrorRender != null && disableMirrorRender.booleanValue()) {
                    return;
                }
                this.foundMirror = true;
            }
            RenderTarget mirrorFramebuffer = MirrorBlockEntityRenderer.mirrorFramebuffer;
            int newWidth = Minecraft.m_91087_().m_91268_().m_85441_();
            int newHeight = Minecraft.m_91087_().m_91268_().m_85442_();
            if (mirrorFramebuffer == null) {
                this.capturedWidth = newWidth;
                this.capturedHeight = newHeight;
                mirrorFramebuffer = MirrorBlockEntityRenderer.mirrorFramebuffer = new TextureTarget(newWidth, newHeight, true, ON_OSX);
            } else if (this.capturedWidth != newWidth || this.capturedHeight != newHeight) {
                this.capturedWidth = newWidth;
                this.capturedHeight = newHeight;
                mirrorFramebuffer.m_83941_(this.capturedWidth, this.capturedHeight, ON_OSX);
            }
            if (chosenMirror != null) {
                switch ((Direction)chosenMirror.m_58900_().m_61143_((Property)MirrorBlock.FACING)) {
                    case EAST: {
                        if (Minecraft.m_91087_().f_91074_.m_20183_().m_123341_() >= chosenMirror.m_58899_().m_123341_()) break;
                        return;
                    }
                    case WEST: {
                        if (Minecraft.m_91087_().f_91074_.m_20183_().m_123341_() <= chosenMirror.m_58899_().m_123341_()) break;
                        return;
                    }
                    case NORTH: {
                        if (Minecraft.m_91087_().f_91074_.m_20183_().m_123343_() <= chosenMirror.m_58899_().m_123343_()) break;
                        return;
                    }
                    case SOUTH: {
                        if (Minecraft.m_91087_().f_91074_.m_20183_().m_123343_() >= chosenMirror.m_58899_().m_123343_()) break;
                        return;
                    }
                }
                Minecraft.m_91087_().m_91385_().m_83970_();
                PoseStack posestack = RenderSystem.getModelViewStack();
                posestack.m_85836_();
                mirrorFramebuffer.m_83947_(true);
                long nanos = Util.m_137569_();
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                if (player != null) {
                    BlockPos mirrorPos = chosenMirror.m_58899_();
                    float mirrorX = (float)mirrorPos.m_123341_() + 0.5f;
                    float mirrorY = (float)mirrorPos.m_123342_() + 0.5f;
                    float mirrorZ = (float)mirrorPos.m_123343_() + 0.5f;
                    float xDiff = (float)(player.m_20185_() - (double)mirrorX);
                    float yDiff = (float)(player.m_20188_() - (double)mirrorY);
                    float zDiff = (float)(player.m_20189_() - (double)mirrorZ);
                    Entity camera = Minecraft.m_91087_().m_91288_();
                    if (camera != null) {
                        // empty if block
                    }
                    this.isMirrorRendering = true;
                }
                boolean bobViewOriginal = (Boolean)Minecraft.m_91087_().f_91066_.m_231830_().m_231551_();
                Minecraft.m_91087_().f_91066_.m_231830_().m_231514_((Object)false);
                Double xTransparentOld = 0.0;
                Double yTransparentOld = 0.0;
                Double zTransparentOld = 0.0;
                Entity originalCamera = Minecraft.m_91087_().m_91288_();
                try {
                    Class<?> optShaders = Class.forName("net.optifine.shaders.Shaders");
                    if (this.currentMirrorCamera != null) {
                        Field previousCameraPositionZ;
                        Field previousCameraPositionY;
                        Field previousCameraPositionX = optShaders.getDeclaredField("previousCameraPositionX");
                        if (previousCameraPositionX != null) {
                            previousCameraPositionX.setAccessible(true);
                            previousCameraPositionX.setDouble(null, this.currentMirrorCamera.m_20185_());
                        }
                        if ((previousCameraPositionY = optShaders.getDeclaredField("previousCameraPositionY")) != null) {
                            previousCameraPositionY.setAccessible(true);
                            double newY = this.currentMirrorCamera.m_20186_() + (double)Minecraft.m_91087_().f_91074_.m_20192_();
                            previousCameraPositionY.setDouble(null, newY);
                        }
                        if ((previousCameraPositionZ = optShaders.getDeclaredField("previousCameraPositionZ")) != null) {
                            previousCameraPositionZ.setAccessible(true);
                            previousCameraPositionZ.setDouble(null, this.currentMirrorCamera.m_20189_());
                        }
                    }
                    ModernLifeClient.optifineDisableFastRender();
                }
                catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException optShaders) {
                    // empty catch block
                }
                Object originalFramebuffer = null;
                Field f = null;
                try {
                    f = null;
                    try {
                        f = LevelRenderer.class.getDeclaredField("f_109411_");
                    }
                    catch (Exception previousCameraPositionY) {
                        // empty catch block
                    }
                    if (f == null) {
                        f = LevelRenderer.class.getDeclaredField("entityTarget");
                    }
                    f.setAccessible(true);
                    f.set(Minecraft.m_91087_().f_91060_, null);
                    f = null;
                    try {
                        f = LevelRenderer.class.getDeclaredField("f_109445_");
                    }
                    catch (Exception previousCameraPositionY) {
                        // empty catch block
                    }
                    if (f == null) {
                        f = LevelRenderer.class.getDeclaredField("xTransparentOld");
                    }
                    f.setAccessible(true);
                    xTransparentOld = (Double)f.get(Minecraft.m_91087_().f_91060_);
                    f = null;
                    try {
                        f = LevelRenderer.class.getDeclaredField("f_109446_");
                    }
                    catch (Exception previousCameraPositionY) {
                        // empty catch block
                    }
                    if (f == null) {
                        f = LevelRenderer.class.getDeclaredField("yTransparentOld");
                    }
                    f.setAccessible(true);
                    yTransparentOld = (Double)f.get(Minecraft.m_91087_().f_91060_);
                    f = null;
                    try {
                        f = LevelRenderer.class.getDeclaredField("f_109447_");
                    }
                    catch (Exception previousCameraPositionY) {
                        // empty catch block
                    }
                    if (f == null) {
                        f = LevelRenderer.class.getDeclaredField("zTransparentOld");
                    }
                    f.setAccessible(true);
                    zTransparentOld = (Double)f.get(Minecraft.m_91087_().f_91060_);
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e1) {
                    e1.printStackTrace();
                }
                try {
                    Minecraft.m_91087_().f_91063_.m_109093_(e.renderTickTime, nanos, true);
                }
                catch (Exception e1) {
                    // empty catch block
                }
                Minecraft.m_91087_().f_91066_.m_231830_().m_231514_((Object)bobViewOriginal);
                this.isMirrorRendering = false;
                try {
                    Field fDFB;
                    Class<?> optShaders = Class.forName("net.optifine.shaders.Shaders");
                    if (optShaders != null && (fDFB = optShaders.getDeclaredField("dfb")) != null) {
                        fDFB.setAccessible(true);
                        Object dfb = fDFB.get(null);
                        if (dfb != null) {
                            Field fGLFB = dfb.getClass().getDeclaredField("glFramebuffer");
                            if (dfb != null && fGLFB != null) {
                                fGLFB.setAccessible(true);
                                int inputFramebuffer = fGLFB.getInt(dfb);
                                this.copyFramebufferTexture(mirrorFramebuffer.f_83915_, mirrorFramebuffer.f_83916_, inputFramebuffer, mirrorFramebuffer.f_83920_);
                            }
                        }
                    }
                }
                catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException optShaders) {
                    // empty catch block
                }
                mirrorFramebuffer.m_83970_();
                posestack.m_85849_();
                RenderSystem.applyModelViewMatrix();
                if (xTransparentOld != null && yTransparentOld != null && zTransparentOld != null) {
                    f = null;
                    try {
                        f = null;
                        try {
                            f = LevelRenderer.class.getDeclaredField("f_109445_");
                        }
                        catch (Exception optShaders) {
                            // empty catch block
                        }
                        if (f == null) {
                            f = LevelRenderer.class.getDeclaredField("xTransparentOld");
                        }
                        f.setAccessible(true);
                        f.set(Minecraft.m_91087_().f_91060_, xTransparentOld);
                        f = null;
                        try {
                            f = LevelRenderer.class.getDeclaredField("f_109446_");
                        }
                        catch (Exception optShaders) {
                            // empty catch block
                        }
                        if (f == null) {
                            f = LevelRenderer.class.getDeclaredField("yTransparentOld");
                        }
                        f.setAccessible(true);
                        f.set(Minecraft.m_91087_().f_91060_, yTransparentOld);
                        f = null;
                        try {
                            f = LevelRenderer.class.getDeclaredField("f_109447_");
                        }
                        catch (Exception optShaders) {
                            // empty catch block
                        }
                        if (f == null) {
                            f = LevelRenderer.class.getDeclaredField("zTransparentOld");
                        }
                        f.setAccessible(true);
                        f.set(Minecraft.m_91087_().f_91060_, zTransparentOld);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e1) {
                        e1.printStackTrace();
                    }
                }
                Minecraft.m_91087_().m_91385_().m_83947_(true);
            }
        } else if (e.phase == TickEvent.Phase.END && !this.foundMirror) {
            ModernLifeClient.optifineResetFastRenderToNormal();
        }
    }

    public static void optifineDisableFastRender() {
        try {
            Class<?> optConfig = Class.forName("net.optifine.Config");
            if (optConfig != null) {
                Field fGameSettings = optConfig.getDeclaredField("gameSettings");
                fGameSettings.setAccessible(true);
                Object gameSettingsObject = fGameSettings.get(null);
                if (gameSettingsObject != null) {
                    Field fFastRender = gameSettingsObject.getClass().getDeclaredField("ofFastRender");
                    if (originalFastRender == null) {
                        originalFastRender = fFastRender.getBoolean(gameSettingsObject);
                    }
                    fFastRender.setBoolean(gameSettingsObject, false);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void optifineResetFastRenderToNormal() {
        try {
            Class<?> optConfig = Class.forName("net.optifine.Config");
            if (optConfig != null && originalFastRender != null) {
                Field fGameSettings = optConfig.getDeclaredField("gameSettings");
                fGameSettings.setAccessible(true);
                Object gameSettingsObject = fGameSettings.get(null);
                if (gameSettingsObject != null) {
                    Field fFastRender = gameSettingsObject.getClass().getDeclaredField("ofFastRender");
                    ModernLifeCommon.LOGGER.info("reset FR to: " + originalFastRender);
                    fFastRender.setBoolean(gameSettingsObject, originalFastRender);
                    originalFastRender = null;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int materialColorToTintColor(int materialColorRgb) {
        int r = materialColorRgb & 0xFF;
        int g = (materialColorRgb & 0xFF00) >> 8;
        int b = (materialColorRgb & 0xFF0000) >> 16;
        return materialColorRgb & 0xFF000000 | r << 16 | g << 8 | b;
    }

    public int colorWithAlpha(int materialColorRgb, int alpha) {
        int a = alpha << 24;
        return materialColorRgb & 0xFFFFFF | a;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerBlockColors(RegisterColorHandlersEvent.Block event) {
        event.getBlockColors().m_92589_(new BlockColor(){

            public int m_92566_(BlockState paramBlockState, BlockAndTintGetter paramBlockAndTintGetter, BlockPos paramBlockPos, int paramInt) {
                return ModernLifeClient.this.materialColorToTintColor(MapColor.f_283915_.m_284280_(MapColor.Brightness.NORMAL));
            }
        }, new Block[]{(Block)CustomBlocks.BLOCK_HEDGE.get()});
        event.getBlockColors().m_92589_(new BlockColor(){

            public int m_92566_(BlockState paramBlockState, BlockAndTintGetter paramBlockAndTintGetter, BlockPos paramBlockPos, int paramInt) {
                return ModernLifeClient.this.colorWithAlpha(ModernLifeClient.this.materialColorToTintColor(MapColor.f_283864_.m_284280_(MapColor.Brightness.NORMAL)), 127);
            }
        }, new Block[]{(Block)CustomBlocks.BLOCK_TOILET.get(), (Block)CustomBlocks.BLOCK_BATHTUB.get()});
        event.getBlockColors().m_92589_(new BlockColor(){

            public int m_92566_(BlockState paramBlockState, BlockAndTintGetter paramBlockAndTintGetter, BlockPos paramBlockPos, int paramInt) {
                return ModernBookshelfBlockEntityRenderer.renderRgb0;
            }
        }, new Block[]{(Block)CustomBlocks.BLOCK_MODERN_BOOK.get()});
        event.getBlockColors().m_92589_(new BlockColor(){

            public int m_92566_(BlockState paramBlockState, BlockAndTintGetter paramBlockAndTintGetter, BlockPos paramBlockPos, int paramInt) {
                return paramBlockAndTintGetter.m_6171_(paramBlockPos, BiomeColors.f_108789_);
            }
        }, new Block[]{(Block)CustomBlocks.BLOCK_GRASS_RAMP.get()});
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerItemColors(RegisterColorHandlersEvent.Item event) {
        event.getItemColors().m_92689_(new ItemColor(){

            public int m_92671_(ItemStack paramItemStack, int paramInt) {
                return ModernLifeClient.this.materialColorToTintColor(MapColor.f_283915_.m_284280_(MapColor.Brightness.NORMAL));
            }
        }, new ItemLike[]{(ItemLike)CustomBlocks.ITEM_HEDGE.get()});
        event.getItemColors().m_92689_(new ItemColor(){

            public int m_92671_(ItemStack paramItemStack, int paramInt) {
                return ModernLifeClient.this.materialColorToTintColor(MapColor.f_283864_.m_284280_(MapColor.Brightness.NORMAL));
            }
        }, new ItemLike[]{(ItemLike)CustomBlocks.ITEM_TOILET.get()});
        event.getItemColors().m_92689_(new ItemColor(){

            public int m_92671_(ItemStack paramItemStack, int paramInt) {
                if (paramInt == 0) {
                    return ModernBookshelfBlockEntityRenderer.renderRgb0;
                }
                return ModernBookshelfBlockEntityRenderer.renderRgb1;
            }
        }, new ItemLike[]{(ItemLike)CustomBlocks.ITEM_MODERN_BOOK.get()});
        event.getItemColors().m_92689_(new ItemColor(){

            public int m_92671_(ItemStack paramItemStack, int paramInt) {
                return ModernLifeClient.this.materialColorToTintColor(MapColor.f_283824_.m_284280_(MapColor.Brightness.NORMAL));
            }
        }, new ItemLike[]{(ItemLike)CustomBlocks.ITEM_GRASS_RAMP.get()});
    }

    @SubscribeEvent
    public void onClientLogin(ClientPlayerNetworkEvent.LoggingIn e) {
        ModernLifeCommon.LOGGER.info("Client login");
        if (cachedData != null) {
            cachedData.clear();
        }
    }

    @SubscribeEvent
    public void fovModifierEvent(ViewportEvent.ComputeFov fovEvent) {
        if (HandgunItem.originalFov > 0.0) {
            fovEvent.setFOV(fovEvent.getFOV() / 1.2);
        }
        fovEvent.setFOV(fovEvent.getFOV() / (double)cameraZoomFactor);
    }

    @SubscribeEvent
    public void onClientLogout(ClientPlayerNetworkEvent.LoggingOut e) {
        ModernLifeCommon.LOGGER.info("Client logout");
        if (MirrorBlockEntityRenderer.mirrorMap != null) {
            MirrorBlockEntityRenderer.mirrorMap.clear();
        }
        if (PowerReceiverBlockEntity.perChannelPowerReceivers.size() > 0) {
            ModernLifeCommon.LOGGER.debug("Clearing power receivers: size = " + PowerReceiverBlockEntity.perChannelPowerReceivers.size());
            PowerReceiverBlockEntity.perChannelPowerReceivers.clear();
        }
        if (PowerTransmitterBlockEntity.perChannelPowerTransmitters.size() > 0) {
            ModernLifeCommon.LOGGER.debug("Clearing power transmitters: size = " + PowerTransmitterBlockEntity.perChannelPowerTransmitters.size());
            PowerTransmitterBlockEntity.perChannelPowerTransmitters.clear();
        }
        HandgunItem.resetFov();
        bulletHoles.clear();
        HandgunItem.firingTickMap.clear();
        ModernLifeClient.optifineResetFastRenderToNormal();
    }

    private static void purgeOldCanvasData() {
        long currentTimestamp = System.currentTimeMillis();
        for (Map.Entry<Long, CachedCanvasData> entry : cachedData.entrySet()) {
            CachedCanvasData ccd = entry.getValue();
            long timeDiff = currentTimestamp - ccd.timestamp;
            if (timeDiff < 1800000L) continue;
            cachedData.remove(entry.getKey());
        }
    }

    public static void requestUpdateForCanvas(long currentTime, long uniqueId) {
        long timeDiff;
        ModernLifeCommon.LOGGER.info("Request update for canvas: " + uniqueId);
        long timestamp = 0L;
        Long timestampData = uniqueIdToTimestampMap.get(uniqueId);
        if (timestampData != null) {
            timestamp = timestampData;
        }
        if ((timeDiff = currentTime - timestamp) >= 3000L) {
            uniqueIdToTimestampMap.put(uniqueId, currentTime);
            ModernLifeNetwork.INSTANCE.sendToServer((Object)new ServerboundRequestCanvasPacket(uniqueId));
        }
    }

    public static void requestCanvasChecksumValidation(long currentTime, long uniqueId, int checksum) {
        long timeDiff;
        long timestamp = 0L;
        Long timestampData = uniqueIdToTimestampChecksumMap.get(uniqueId);
        if (timestampData != null) {
            timestamp = timestampData;
        }
        if ((timeDiff = currentTime - timestamp) >= 3000L) {
            uniqueIdToTimestampChecksumMap.put(uniqueId, currentTime);
            ModernLifeNetwork.INSTANCE.sendToServer((Object)new ServerboundCanvasChecksumPacket(uniqueId, checksum));
        }
    }

    public static byte[] getCanvasData(long uniqueId) {
        ModernLifeClient.purgeOldCanvasData();
        long currentTime = System.currentTimeMillis();
        CachedCanvasData ccd = cachedData.get(uniqueId);
        if (ccd != null) {
            return ccd.data;
        }
        ServerboundMultipartCameraPacket.PngSizeHolder sizeHolder = new ServerboundMultipartCameraPacket.PngSizeHolder();
        try {
            byte[] data = ServerboundMultipartCameraPacket.loadPng(uniqueId, sizeHolder);
            if (data == null) {
                ModernLifeClient.requestUpdateForCanvas(currentTime, uniqueId);
                return null;
            }
            ccd = ModernLifeClient.putCachedData(currentTime, uniqueId, data, sizeHolder.width, sizeHolder.height);
            if (ccd != null) {
                ModernLifeClient.requestCanvasChecksumValidation(currentTime, uniqueId, ccd.hashCode);
            }
            return data;
        }
        catch (Exception e) {
            ModernLifeCommon.LOGGER.error("Exception while loading canvas data", (Throwable)e);
            return null;
        }
    }

    public static CachedCanvasData putCachedData(long currentTime, long uniqueId, byte[] data, int width, int height) {
        CachedCanvasData ccd = new CachedCanvasData();
        ccd.data = data;
        ccd.timestamp = currentTime;
        ccd.hashCode = ModernLifeCommon.getHashCodeForBytes(data);
        ccd.texWidth = width;
        ccd.texHeight = height;
        cachedData.put(uniqueId, ccd);
        return ccd;
    }

    public static int getCanvasWidth(long uniqueId) {
        CachedCanvasData ccd = cachedData.get(uniqueId);
        if (ccd != null) {
            return ccd.texWidth;
        }
        return 0;
    }

    public static int getCanvasHeight(long uniqueId) {
        CachedCanvasData ccd = cachedData.get(uniqueId);
        if (ccd != null) {
            return ccd.texHeight;
        }
        return 0;
    }

    public static void removeCachedCanvasData(long uniqueId) {
        cachedData.remove(uniqueId);
    }

    public static long getCanvasHashCode(long uniqueId) {
        CachedCanvasData ccd = cachedData.get(uniqueId);
        if (ccd != null) {
            return ccd.hashCode;
        }
        return 0L;
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void renderTooltipEvent(RenderTooltipEvent.GatherComponents tooltipEvent) {
        List components = tooltipEvent.getTooltipElements();
        ItemStack itemStack = tooltipEvent.getItemStack();
        if (itemStack != null && itemStack.m_41720_() == CustomBlocks.ITEM_CANVAS.get()) {
            components.add(0, Either.right((Object)new CanvasPreviewComponent(itemStack)));
        }
    }

    @SubscribeEvent
    public void renderItemInInteractionHandEvent(RenderHandEvent RenderHandEvent2) {
        Integer tickValue;
        ItemStack itemStack;
        if (this.isMirrorRendering) {
            RenderHandEvent2.setCanceled(true);
        }
        if (CameraItem.usingCamera || CameraItem.pendingSnapshot) {
            RenderHandEvent2.setCanceled(true);
        }
        if ((itemStack = RenderHandEvent2.getItemStack()) != null && itemStack.m_41720_() == CustomBlocks.ITEM_HANDGUN.get()) {
            if (Minecraft.m_91087_().f_91074_.m_6117_()) {
                RenderHandEvent2.getPoseStack().m_85837_(-0.38, 0.2, 0.0);
                RenderHandEvent2.getPoseStack().m_252781_(Axis.f_252403_.m_252977_(-4.0f));
                RenderHandEvent2.getPoseStack().m_252781_(Axis.f_252436_.m_252977_(8.0f));
                RenderHandEvent2.getPoseStack().m_252781_(Axis.f_252529_.m_252977_(-10.0f));
            }
            if ((tickValue = HandgunItem.firingTickMap.get(Minecraft.m_91087_().f_91074_)) != null && tickValue > 0) {
                float progress = (float)(6 - tickValue) / 6.0f;
                float upswingProgress = progress / 0.75f;
                if (progress <= 0.75f) {
                    RenderHandEvent2.getPoseStack().m_252781_(Axis.f_252529_.m_252977_(upswingProgress * 35.0f));
                } else {
                    float downswingProgress = (progress - 0.75f) / 0.25f;
                    RenderHandEvent2.getPoseStack().m_252781_(Axis.f_252529_.m_252977_((1.0f - downswingProgress) * 35.0f));
                }
            }
            if (HandgunItem.reloadingTick > 0) {
                RenderHandEvent2.getPoseStack().m_252781_(Axis.f_252436_.m_252977_(45.0f));
            }
        }
        if (Minecraft.m_91087_() != null && Minecraft.m_91087_().f_91074_ != null && itemStack != null && itemStack.m_41720_() == CustomBlocks.ITEM_HANDGUN.get() && (tickValue = HandgunItem.firingTickMap.get(Minecraft.m_91087_().f_91074_)) != null && tickValue > 0) {
            int xOffset = 20;
            int yOffset = 20;
            if (!Minecraft.m_91087_().f_91074_.m_6117_()) {
                xOffset = 80;
                yOffset = 40;
            }
            int x = Minecraft.m_91087_().m_91268_().m_85445_() / 2 + xOffset;
            int y = Minecraft.m_91087_().m_91268_().m_85446_() / 2 + yOffset;
            int w = 20;
            int h = 20;
            GuiGraphics graphics = new GuiGraphics(Minecraft.m_91087_(), Minecraft.m_91087_().m_91269_().m_110104_());
            graphics.m_280168_().m_166856_();
            graphics.m_280168_().m_252931_(RenderHandEvent2.getPoseStack().m_85850_().m_252922_());
            graphics.m_280509_(x, y, x + w, y + h, -256);
        }
    }

    public static void stopUsingCamera() {
        CameraItem.usingCamera = false;
        ModernLifeNetwork.INSTANCE.sendToServer((Object)new ServerboundStopUsingCameraPacket());
        ModernLifeClient.resetCameraZoom();
    }

    public static void resetCameraZoom() {
        cameraZoomFactor = 1.0f;
        originalFov = -1.0;
    }

    @SubscribeEvent
    public void keyInputEvent(InputEvent.Key keyEvent) {
        if (CameraItem.usingCamera && keyEvent.getKey() == 256) {
            this.stopUsingCamera();
            Minecraft.m_91087_().f_91068_.m_90893_(Minecraft.m_91087_().m_91268_().m_85439_(), 256, 256, 1, 0);
        }
    }

    @SubscribeEvent
    public void onDrawHighlight(RenderHighlightEvent highlightEvent) {
        if (CameraItem.usingCamera || CameraItem.pendingSnapshot) {
            highlightEvent.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onInteractEvent(PlayerInteractEvent interactEvent) {
        ItemStack itemStack;
        block5: {
            block7: {
                block6: {
                    if (!CameraItem.usingCamera || interactEvent instanceof PlayerInteractEvent.RightClickItem) break block5;
                    if (interactEvent instanceof PlayerInteractEvent.LeftClickBlock) break block6;
                    if (!(interactEvent instanceof PlayerInteractEvent.LeftClickEmpty)) break block7;
                }
                this.stopUsingCamera();
            }
            if (interactEvent != null && interactEvent.isCancelable()) {
                interactEvent.setCanceled(true);
            }
        }
        if ((itemStack = interactEvent.getEntity().m_21205_()) != null && itemStack.m_41720_() == CustomBlocks.ITEM_HANDGUN.get() && (interactEvent instanceof PlayerInteractEvent.LeftClickBlock || interactEvent instanceof PlayerInteractEvent.LeftClickEmpty) && interactEvent.isCancelable()) {
            interactEvent.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onClick(InputEvent.MouseButton.Pre mouseEvent) {
        if (Minecraft.m_91087_().f_91074_ != null && !Minecraft.m_91087_().f_91074_.m_5833_()) {
            ItemStack item = Minecraft.m_91087_().f_91074_.m_21205_();
            if (mouseEvent.getButton() == 0 && mouseEvent.getAction() == 1 && item != null && item.m_41720_() == CustomBlocks.ITEM_HANDGUN.get() && !Minecraft.m_91087_().m_91104_() && Minecraft.m_91087_().f_91080_ == null) {
                ((HandgunItem)((Object)CustomBlocks.ITEM_HANDGUN.get())).fireGun((Player)Minecraft.m_91087_().f_91074_);
            }
        }
    }

    @SubscribeEvent
    public void mouseScrollEvent(InputEvent.MouseScrollingEvent scrollEvent) {
        if (CameraItem.usingCamera) {
            if (originalFov < 0.0) {
                originalFov = ((Integer)Minecraft.m_91087_().f_91066_.m_231837_().m_231551_()).intValue();
            }
            cameraZoomFactor = scrollEvent.getScrollDelta() > 0.0 ? (cameraZoomFactor += 0.5f) : (cameraZoomFactor -= 0.5f);
            cameraZoomFactor = Math.min(cameraZoomFactor, 4.5f);
            cameraZoomFactor = Math.max(cameraZoomFactor, 1.0f);
            scrollEvent.setCanceled(true);
        }
    }

    private void drawCrosshairLine(GuiGraphics graphics, int x0, int y0, int w0, int h0) {
        int xOffset = x0;
        int yOffset = y0;
        int x = Minecraft.m_91087_().m_91268_().m_85445_() / 2 + xOffset;
        int y = Minecraft.m_91087_().m_91268_().m_85446_() / 2 + yOffset;
        int w = w0;
        int h = h0;
        graphics.m_280509_(x, y, x + w, y + h, -1);
    }

    private void drawSizedCrosshair(GuiGraphics graphics, int size, int lineLength) {
        this.drawCrosshairLine(graphics, size, 0, lineLength, 1);
        this.drawCrosshairLine(graphics, -size - lineLength + 1, 0, lineLength, 1);
        this.drawCrosshairLine(graphics, 0, size, 1, lineLength);
        this.drawCrosshairLine(graphics, 0, -size - lineLength + 1, 1, lineLength);
    }

    @SubscribeEvent
    public void renderPlayerEvent(RenderPlayerEvent.Pre event) {
        ItemStack itemStack = event.getEntity().m_21205_();
        if (itemStack != null && itemStack.m_41720_() == CustomBlocks.ITEM_HANDGUN.get()) {
            ((PlayerModel)event.getRenderer().m_7200_()).f_102816_ = HumanoidModel.ArmPose.CROSSBOW_HOLD;
        }
    }

    @SubscribeEvent
    public void renderOverlayEvent(RenderGuiOverlayEvent.Pre overlayEvent) {
        HitResult hr;
        MotorboatEntity motorboat;
        LivingEntity controller;
        Entity vehicle;
        if (this.isMirrorRendering) {
            return;
        }
        if (overlayEvent.getOverlay() == VanillaGuiOverlay.CROSSHAIR.type() && Minecraft.m_91087_().f_91074_.m_21205_().m_41720_() == CustomBlocks.ITEM_HANDGUN.get()) {
            overlayEvent.setCanceled(true);
            int movementFactor = 0;
            boolean useMovementSpread = true;
            boolean useAdsSpread = true;
            if (useMovementSpread) {
                Vec3 movement = Minecraft.m_91087_().f_91074_.m_20184_();
                movementFactor = (int)((movement.f_82479_ * movement.f_82479_ + movement.f_82481_ * movement.f_82481_) / 0.002);
            }
            GuiGraphics graphics = new GuiGraphics(Minecraft.m_91087_(), Minecraft.m_91087_().m_91269_().m_110104_());
            if (useAdsSpread && !Minecraft.m_91087_().f_91074_.m_6117_()) {
                this.drawSizedCrosshair(overlayEvent.getGuiGraphics(), 5 + movementFactor, 3);
            } else {
                this.drawSizedCrosshair(overlayEvent.getGuiGraphics(), 2 + movementFactor, 3);
            }
        }
        if ((vehicle = Minecraft.m_91087_().f_91074_.m_20202_()) != null && vehicle instanceof MotorboatEntity && overlayEvent.getOverlay() == VanillaGuiOverlay.HOTBAR.type() && (controller = (motorboat = (MotorboatEntity)vehicle).m_6688_()) instanceof Player && motorboat.m_6109_()) {
            float remainingFuel = motorboat.getCurrentFuelLevel();
            float throttlePercent = motorboat.getCurAccel() / motorboat.getMaxAccel();
            if (motorboat.isOutOfFuel() || motorboat.status == MotorboatEntity.Status.ON_LAND) {
                throttlePercent = 0.0f;
            }
            Window window = overlayEvent.getWindow();
            RenderSystem.setShader(GameRenderer::m_172817_);
            int xStart = (int)((double)window.m_85445_() * 0.06) - this.GUI_MOTORBOAT_TEX_SIZE / 2;
            int yStart = (int)((double)window.m_85446_() * 0.65) - this.GUI_MOTORBOAT_TEX_SIZE / 2;
            float xStartTexture = 0.0f;
            float yStartTexture = 0.0f;
            float fuelBarPct = remainingFuel;
            float throttleBarPct = throttlePercent;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            overlayEvent.getGuiGraphics().m_280163_(this.GUI_MOTORBOAT_LOCATION, xStart, yStart, xStartTexture, yStartTexture, this.GUI_MOTORBOAT_TEX_SIZE, this.GUI_MOTORBOAT_BORDER_HEIGHT, this.GUI_MOTORBOAT_TEX_SIZE, this.GUI_MOTORBOAT_TEX_SIZE);
            overlayEvent.getGuiGraphics().m_280163_(this.GUI_MOTORBOAT_LOCATION, xStart, yStart, xStartTexture, (float)this.GUI_MOTORBOAT_BORDER_HEIGHT, 1 + (int)Math.ceil((float)(this.GUI_MOTORBOAT_TEX_SIZE - 2) * fuelBarPct), this.GUI_MOTORBOAT_BORDER_HEIGHT, this.GUI_MOTORBOAT_TEX_SIZE, this.GUI_MOTORBOAT_TEX_SIZE);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            overlayEvent.getGuiGraphics().m_280163_(this.GUI_MOTORBOAT_LOCATION, xStart, yStart, xStartTexture, (float)this.GUI_MOTORBOAT_BORDER_HEIGHT * 2.0f, this.GUI_MOTORBOAT_TEX_SIZE, this.GUI_MOTORBOAT_BORDER_HEIGHT, this.GUI_MOTORBOAT_TEX_SIZE, this.GUI_MOTORBOAT_TEX_SIZE);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int yDiff = 10;
            overlayEvent.getGuiGraphics().m_280163_(this.GUI_MOTORBOAT_LOCATION, xStart, yStart + yDiff, xStartTexture, yStartTexture, this.GUI_MOTORBOAT_TEX_SIZE, this.GUI_MOTORBOAT_BORDER_HEIGHT, this.GUI_MOTORBOAT_TEX_SIZE, this.GUI_MOTORBOAT_TEX_SIZE);
            overlayEvent.getGuiGraphics().m_280163_(this.GUI_MOTORBOAT_LOCATION, xStart, yStart + yDiff, xStartTexture, (float)this.GUI_MOTORBOAT_BORDER_HEIGHT, 1 + (int)Math.ceil((float)(this.GUI_MOTORBOAT_TEX_SIZE - 2) * throttleBarPct), this.GUI_MOTORBOAT_BORDER_HEIGHT, this.GUI_MOTORBOAT_TEX_SIZE, this.GUI_MOTORBOAT_TEX_SIZE);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            overlayEvent.getGuiGraphics().m_280163_(this.GUI_MOTORBOAT_LOCATION, xStart, yStart + yDiff, xStartTexture, (float)this.GUI_MOTORBOAT_BORDER_HEIGHT * 3.0f, this.GUI_MOTORBOAT_TEX_SIZE, this.GUI_MOTORBOAT_BORDER_HEIGHT, this.GUI_MOTORBOAT_TEX_SIZE, this.GUI_MOTORBOAT_TEX_SIZE);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (overlayEvent.getOverlay() == VanillaGuiOverlay.HOTBAR.type() && (hr = Minecraft.m_91087_().f_91077_) instanceof BlockHitResult) {
            BlockHitResult bhr = (BlockHitResult)hr;
            BlockPos pos = bhr.m_82425_();
            BlockState state = Minecraft.m_91087_().f_91074_.m_9236_().m_8055_(pos);
            if (state.m_60734_() instanceof ModernBookshelfBlock) {
                ModernBookshelfBlockEntity bookshelf;
                int hitIndex = -1;
                BlockEntity blockEntity = Minecraft.m_91087_().f_91074_.m_9236_().m_7702_(pos);
                if (blockEntity instanceof ModernBookshelfBlockEntity && (hitIndex = (bookshelf = (ModernBookshelfBlockEntity)blockEntity).getHitIndex((Player)Minecraft.m_91087_().f_91074_, Minecraft.m_91087_().f_91077_)) != -1) {
                    List infoList;
                    IModFile modFile;
                    ItemStack itemStack = bookshelf.m_8020_(hitIndex);
                    String modName = "";
                    IModFileInfo modFileInfo = ModList.get().getModFileById(BuiltInRegistries.f_257033_.m_7981_((Object)itemStack.m_41720_()).m_135827_());
                    if (modFileInfo != null && (modFile = modFileInfo.getFile()) != null && (infoList = modFile.getModInfos()) != null && !infoList.isEmpty()) {
                        modName = ((IModInfo)infoList.get(0)).getDisplayName();
                    }
                    MutableComponent component1 = MutableComponent.m_237204_((ComponentContents)new LiteralContents((String)bookshelf.bookNames.get(hitIndex))).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFF0000)));
                    MutableComponent component2 = MutableComponent.m_237204_((ComponentContents)new LiteralContents(modName)).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFF0000)));
                    overlayEvent.getGuiGraphics().m_280614_(Minecraft.m_91087_().f_91062_, (Component)component1, (int)((float)overlayEvent.getWindow().m_85445_() * 0.3f), (int)((float)overlayEvent.getWindow().m_85446_() * 0.35f), 0, true);
                    overlayEvent.getGuiGraphics().m_280614_(Minecraft.m_91087_().f_91062_, (Component)component2, (int)((float)overlayEvent.getWindow().m_85445_() * 0.3f), (int)((float)overlayEvent.getWindow().m_85446_() * 0.38f), 0, true);
                }
            }
        }
        if (Minecraft.m_91087_() != null && Minecraft.m_91087_().f_91074_ != null && (Minecraft.m_91087_().f_91074_.m_21205_().m_41720_() == CustomBlocks.ITEM_SPEEDOMETER.get() || Minecraft.m_91087_().f_91074_.m_21206_().m_41720_() == CustomBlocks.ITEM_SPEEDOMETER.get()) && overlayEvent.getGuiGraphics() != null && Minecraft.m_91087_() != null && overlayEvent.getWindow() != null && Minecraft.m_91087_().f_91062_ != null) {
            String speedText = String.format("%.1f bps", Float.valueOf(SpeedometerItem.speed));
            MutableComponent component = MutableComponent.m_237204_((ComponentContents)new LiteralContents(speedText)).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFF0000)));
            overlayEvent.getGuiGraphics().m_280614_(Minecraft.m_91087_().f_91062_, (Component)component, (overlayEvent.getWindow().m_85445_() - Minecraft.m_91087_().f_91062_.m_92724_(component.m_7532_())) / 2, (int)((float)overlayEvent.getWindow().m_85446_() * 0.74f), 0, true);
        }
        if (Minecraft.m_91087_() != null && Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91074_.m_21205_().m_41720_() == CustomBlocks.ITEM_HANDGUN.get()) {
            HandgunItem handgun = (HandgunItem)((Object)CustomBlocks.ITEM_HANDGUN.get());
            String speedText = String.format("%d/%d (%d)", handgun.getCurrentMagazineAmmo((Player)Minecraft.m_91087_().f_91074_), handgun.getCurrentMagazineCapacity((Player)Minecraft.m_91087_().f_91074_), handgun.getAmmoTotal((Player)Minecraft.m_91087_().f_91074_));
            MutableComponent component = MutableComponent.m_237204_((ComponentContents)new LiteralContents(speedText)).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFFFFFF)));
            overlayEvent.getGuiGraphics().m_280614_(Minecraft.m_91087_().f_91062_, (Component)component, (int)((float)(overlayEvent.getWindow().m_85445_() - Minecraft.m_91087_().f_91062_.m_92724_(component.m_7532_())) * 0.08f), (int)((float)overlayEvent.getWindow().m_85446_() * 0.85f), 0, true);
        }
        if (CameraItem.pendingSnapshot) {
            CameraItem.pendingSnapshot = false;
            overlayEvent.setCanceled(true);
            CameraItem.takePhoto();
            ModernLifeClient.stopUsingCamera();
        }
        if (CameraItem.usingCamera && Minecraft.m_91087_() != null && Minecraft.m_91087_().f_91074_ != null) {
            if (Minecraft.m_91087_().f_91074_.m_21205_().m_41720_() == CustomBlocks.ITEM_CAMERA.get()) {
                if (overlayEvent.getGuiGraphics() != null && Minecraft.m_91087_() != null && Minecraft.m_91087_().m_91268_() != null && Minecraft.m_91087_().f_91062_ != null) {
                    Window window = Minecraft.m_91087_().m_91268_();
                    if (((Boolean)ModernLifeConfig.CLIENT.enableCameraViewfinder.get()).booleanValue()) {
                        RenderSystem.setShader(GameRenderer::m_172817_);
                        int xStart = (window.m_85445_() - this.CAMERA_VIEWFINDER_WIDTH) / 2;
                        int yStart = (window.m_85446_() - this.CAMERA_VIEWFINDER_HEIGHT) / 2;
                        int xStartTexture = 0;
                        int yStartTexture = 0;
                        if (Minecraft.m_91087_().f_91065_ != null) {
                            overlayEvent.getGuiGraphics().m_280218_(this.CAMERA_VIEWFINDER_LOCATION, xStart, yStart, xStartTexture, yStartTexture, this.CAMERA_VIEWFINDER_WIDTH, this.CAMERA_VIEWFINDER_HEIGHT);
                        }
                        String zoomText = "";
                        zoomText = cameraZoomFactor - (float)((int)cameraZoomFactor) == 0.0f ? String.format("%dx zoom", (int)cameraZoomFactor) : String.format("%.1fx zoom", Float.valueOf(cameraZoomFactor));
                        MutableComponent component = MutableComponent.m_237204_((ComponentContents)new LiteralContents(zoomText)).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x202020)));
                        overlayEvent.getGuiGraphics().m_280614_(Minecraft.m_91087_().f_91062_, (Component)component, (window.m_85445_() - Minecraft.m_91087_().f_91062_.m_92724_(component.m_7532_())) / 2, (int)((float)window.m_85446_() * 0.88f), 0, true);
                    }
                    overlayEvent.setCanceled(true);
                }
            } else {
                ModernLifeClient.stopUsingCamera();
            }
        }
    }

    @SubscribeEvent
    public void inputUpdateEvent(MovementInputUpdateEvent event) {
        if (event != null && event.getInput() != null && event.getEntity() != null) {
            if (event.getEntity().m_6117_()) {
                if (event.getEntity().m_21211_().m_41720_() == CustomBlocks.ITEM_CHAINSAW.get() || event.getEntity().m_21211_().m_41720_() == CustomBlocks.ITEM_FLASHLIGHT.get()) {
                    if (event.getEntity().m_20202_() == null && !((Boolean)ModernLifeConfig.CLIENT.chainsawSlowsMovementWhenUsed.get()).booleanValue()) {
                        event.getInput().f_108567_ *= 5.0f;
                        event.getInput().f_108566_ *= 5.0f;
                    }
                } else if (event.getEntity().m_21211_().m_41720_() == CustomBlocks.ITEM_HANDGUN.get() && event.getEntity().m_20202_() == null) {
                    event.getInput().f_108567_ *= 2.0f;
                    event.getInput().f_108566_ *= 2.0f;
                }
            }
            if (event.getEntity().m_20202_() instanceof BicycleEntity && event.getEntity().m_9236_().m_8055_(event.getEntity().m_20202_().m_20183_().m_7495_()).m_60713_((Block)CustomBlocks.BLOCK_PAVED_ROAD.get())) {
                BicycleEntity bike = (BicycleEntity)event.getEntity().m_20202_();
                event.getInput().f_108567_ = (float)((double)event.getInput().f_108567_ * 1.2);
                event.getInput().f_108566_ *= 1.0f;
                bike.setSpeedBoost(1.2f);
            }
        }
    }

    public static class CanvasPreviewComponent
    implements ClientTooltipComponent,
    TooltipComponent {
        private static ResourceLocation CANVAS_TOOLTIP_LOCATION = new ResourceLocation("modernlife", "textures/gui/canvas_tooltip.png");
        public static int SMALL_CANVAS_TOOLTIP_W = 80;
        public static int CANVAS_TOOLTIP_W = 420;
        private static CanvasData canvasTooltipData = new CanvasData();
        private static DynamicTexture canvasTexture;
        private static ResourceLocation dynamicTextureLocation;
        private static int lastCanvasHashCode;
        private static long lastUniqueId;
        private ItemStack stack;

        CanvasPreviewComponent(ItemStack stack) {
            this.stack = stack;
        }

        public void m_183452_(Font font, int x, int y, GuiGraphics graphics) {
            boolean shouldDrawImage = true;
            ItemStack itemStack = this.stack;
            if (itemStack != null && itemStack.m_41720_() == CustomBlocks.ITEM_CANVAS.get() && itemStack.m_41783_() != null && itemStack.m_41783_().m_128441_("UniqueId")) {
                long uniqueId = itemStack.m_41783_().m_128454_("UniqueId");
                int w = ModernLifeClient.getCanvasWidth(uniqueId);
                int h = ModernLifeClient.getCanvasHeight(uniqueId);
                byte[] compressed = ModernLifeClient.getCanvasData(uniqueId);
                int newHashCode = ModernLifeCommon.getHashCodeForBytes(compressed);
                if (uniqueId != lastUniqueId || compressed != null && newHashCode != lastCanvasHashCode) {
                    RenderSystem.disableBlend();
                    RenderSystem.disableDepthTest();
                    lastUniqueId = uniqueId;
                    lastCanvasHashCode = newHashCode;
                    if (Minecraft.m_91087_().f_91065_ != null) {
                        canvasTooltipData.disable();
                        if (w != 0 && h != 0) {
                            canvasTooltipData.setTextureSize(w, h);
                        } else {
                            canvasTooltipData.setTextureSize(64, 64);
                        }
                        if (itemStack.m_41783_().m_128441_("UniqueId") && compressed != null) {
                            canvasTooltipData.fromCompressedNbt(compressed);
                            canvasTooltipData.initImage();
                            if (canvasTexture != null) {
                                canvasTexture.close();
                                canvasTexture = null;
                            }
                            if (canvasTexture == null) {
                                canvasTexture = new DynamicTexture(canvasTooltipData.textureWidth(), canvasTooltipData.textureHeight(), true);
                                dynamicTextureLocation = Minecraft.m_91087_().f_90987_.m_118490_("artpad/dyn", canvasTexture);
                                canvasTooltipData.reenable();
                                EaselScreen.updateTexture(canvasTooltipData, canvasTexture);
                            }
                        }
                        canvasTooltipData.reenable();
                    }
                }
                RenderSystem.setShader(GameRenderer::m_172817_);
                int blitY = y;
                if (blitY < 2) {
                    blitY = 2;
                }
                float xTexStart = 0.0f;
                float xTexDiff = 0.0f;
                int tooltipW = this.getTooltipWidth(uniqueId);
                int tooltipH = this.getTooltipHeight(uniqueId);
                if (compressed == null) {
                    shouldDrawImage = false;
                    tooltipW = 2;
                    tooltipH = 2;
                }
                graphics.m_280163_(CANVAS_TOOLTIP_LOCATION, x, blitY, xTexStart, xTexDiff, tooltipW, tooltipH, tooltipW, tooltipH);
                if (shouldDrawImage) {
                    int CANVAS_TOOLTIP_DYN_TEX_W = tooltipW - 2;
                    int CANVAS_TOOLTIP_DYN_TEX_H = tooltipH - 2;
                    if (dynamicTextureLocation != null) {
                        RenderSystem.setShader(GameRenderer::m_172817_);
                        graphics.m_280163_(dynamicTextureLocation, x + 1, blitY + 1, xTexStart, xTexDiff, CANVAS_TOOLTIP_DYN_TEX_W, CANVAS_TOOLTIP_DYN_TEX_H, CANVAS_TOOLTIP_DYN_TEX_W, CANVAS_TOOLTIP_DYN_TEX_H);
                    }
                }
                RenderSystem.enableBlend();
                RenderSystem.enableDepthTest();
            }
        }

        private int getTooltipHeight(long uniqueId) {
            byte[] compressed = ModernLifeClient.getCanvasData(uniqueId);
            int w = ModernLifeClient.getCanvasWidth(uniqueId);
            int h = ModernLifeClient.getCanvasHeight(uniqueId);
            if (compressed == null) {
                return 0;
            }
            float aspectRatio = 1.0f;
            if (h != 0) {
                aspectRatio = (float)w / (float)h;
            }
            int tooltipH = (int)((float)CANVAS_TOOLTIP_W / aspectRatio);
            if (w <= 256 && h <= 256) {
                tooltipH = (int)((float)SMALL_CANVAS_TOOLTIP_W / aspectRatio);
            }
            return tooltipH;
        }

        private int getTooltipWidth(long uniqueId) {
            byte[] compressed = ModernLifeClient.getCanvasData(uniqueId);
            int w = ModernLifeClient.getCanvasWidth(uniqueId);
            int h = ModernLifeClient.getCanvasHeight(uniqueId);
            if (compressed == null) {
                return 0;
            }
            int tooltipW = CANVAS_TOOLTIP_W;
            if (w <= 256 && h <= 256) {
                tooltipW = SMALL_CANVAS_TOOLTIP_W;
            }
            return tooltipW;
        }

        public int m_142103_() {
            if (this.stack == null || this.stack == ItemStack.f_41583_ || this.stack.m_41783_() == null || !this.stack.m_41783_().m_128441_("UniqueId")) {
                return 0;
            }
            long uniqueId = this.stack.m_41783_().m_128454_("UniqueId");
            return this.getTooltipHeight(uniqueId);
        }

        public int m_142069_(Font paramFont) {
            if (this.stack == null || this.stack == ItemStack.f_41583_ || this.stack.m_41783_() == null || !this.stack.m_41783_().m_128441_("UniqueId")) {
                return 0;
            }
            long uniqueId = this.stack.m_41783_().m_128454_("UniqueId");
            return this.getTooltipWidth(uniqueId);
        }

        static {
            lastCanvasHashCode = 0;
            lastUniqueId = 0L;
        }
    }

    public static class BulletHoleInfo {
        public BlockPos pos;
        public Vec3 loc;
        public int holeNo;
        public String dim;
        public Direction facing;
        public long timestamp;
        public Double randomDepth;
    }

    private static class CachedCanvasData {
        long timestamp;
        byte[] data;
        int hashCode;
        int texWidth;
        int texHeight;

        private CachedCanvasData() {
        }
    }
}

