/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.blocks.gui.chess;

import com.dairymoose.modernlife.blocks.gui.chess.Piece;
import com.dairymoose.modernlife.blocks.gui.chess.PieceIds;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KingPiece
extends Piece {
    private static final Logger LOGGER = LogManager.getLogger();

    public boolean inCheck() {
        if (this.black) {
            for (Piece p : this.screen.whitePieces) {
                p.ignoreCheckRules = true;
                boolean canKillKing = p.canMove(this.x, this.y);
                p.ignoreCheckRules = false;
                if (!canKillKing) continue;
                return true;
            }
        } else {
            for (Piece p : this.screen.blackPieces) {
                p.ignoreCheckRules = true;
                boolean canKillKing = p.canMove(this.x, this.y);
                p.ignoreCheckRules = false;
                if (!canKillKing) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canMove(int x, int y) {
        int xDiff = x - this.x;
        int yDiff = y - this.y;
        if (Math.abs(xDiff) <= 1 && Math.abs(yDiff) <= 1 && !this.wouldCollide(x, y) && this.canDoMove(x, y)) {
            int originalX = this.x;
            int originalY = this.y;
            this.x = x;
            this.y = y;
            if (this.inCheck()) {
                this.x = originalX;
                this.y = originalY;
                return false;
            }
            this.x = originalX;
            this.y = originalY;
            return true;
        }
        return false;
    }

    @Override
    public int getId() {
        return PieceIds.KING.ordinal();
    }
}

