/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.blocks.gui.chess;

import com.dairymoose.modernlife.blocks.gui.chess.BishopPiece;
import com.dairymoose.modernlife.blocks.gui.chess.CheckState;
import com.dairymoose.modernlife.blocks.gui.chess.ImageButtonXDiff;
import com.dairymoose.modernlife.blocks.gui.chess.InvertedImageButton;
import com.dairymoose.modernlife.blocks.gui.chess.InvertedImageButtonXDiff;
import com.dairymoose.modernlife.blocks.gui.chess.KingPiece;
import com.dairymoose.modernlife.blocks.gui.chess.KnightPiece;
import com.dairymoose.modernlife.blocks.gui.chess.PawnPiece;
import com.dairymoose.modernlife.blocks.gui.chess.Piece;
import com.dairymoose.modernlife.blocks.gui.chess.PieceIds;
import com.dairymoose.modernlife.blocks.gui.chess.QueenPiece;
import com.dairymoose.modernlife.blocks.gui.chess.RookPiece;
import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.core.ModernLifeCommon;
import com.dairymoose.modernlife.core.ModernLifeNetwork;
import com.dairymoose.modernlife.network.play.client.ServerboundChessStatePacket;
import com.dairymoose.modernlife.tileentities.ChessBoardBlockEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ChessScreen
extends Screen {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation CHESS_UI = new ResourceLocation("modernlife", "textures/gui/gui_chess_blank.png");
    final int GUI_WIDTH = 230;
    final int GUI_HEIGHT = 230;
    final int ROW_WIDTH = 23;
    final int ROW_HEIGHT = 23;
    final int BORDERED_ROW_WIDTH = 24;
    final int BORDERED_ROW_HEIGHT = 24;
    public static final int BOARD_WIDTH = 8;
    public static final int BOARD_HEIGHT = 8;
    private static boolean playerCanPlayHimself = false;
    int currentTurn = 0;
    private BlockPos chessBoardPos;
    private String whitePlayer = null;
    private String blackPlayer = null;
    private Button leftCastleButton = null;
    private Button rightCastleButton = null;
    private Button restartButton = null;
    CastleFlags castleFlags = new CastleFlags();
    private Button leftRook;
    private Button rightRook;
    private Button leftBishop;
    private Button rightBishop;
    private Button pawn1;
    private Button leftKnight;
    private Button rightKnight;
    private Button king;
    private Button queen;
    private Piece selectedPiece;
    private Piece movedPiece;
    public boolean playerIsWhite = true;
    private boolean canPlay = true;
    private boolean isWhiteTurn = true;
    private boolean isExpectedPlayer = false;
    CheckState cachedCheckState;
    public List<Piece> blackPieces = new ArrayList<Piece>(16);
    public List<Piece> whitePieces = new ArrayList<Piece>(16);
    public KingPiece whiteKing;
    public KingPiece blackKing;
    private int leftCastleButtonState = 0;
    private int rightCastleButtonState = 0;
    private int restartButtonState = 0;
    private boolean restartingGame = false;
    private static final int UI_BUTTON_WIDTH = 14;
    private static final int UI_BUTTON_HEIGHT = 13;
    int drawSelectionX = -1;
    int drawSelectionY = -1;

    public ChessScreen(BlockPos chessBoardPos) {
        super((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("Chess")).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x404040))));
        this.chessBoardPos = chessBoardPos;
    }

    private void assignNamesAndSubmitTurn() {
        if (this.whitePlayer == null || this.whitePlayer.isEmpty()) {
            this.whitePlayer = Minecraft.m_91087_().f_91074_.m_7755_().getString();
        } else if (this.blackPlayer == null || this.blackPlayer.isEmpty()) {
            this.blackPlayer = Minecraft.m_91087_().f_91074_.m_7755_().getString();
        }
        this.canPlay = false;
        CheckState newCheckState = this.getCheckState();
        ModernLifeNetwork.INSTANCE.sendToServer((Object)new ServerboundChessStatePacket(1, newCheckState.ordinal(), this.whitePlayer, this.blackPlayer, !this.isWhiteTurn, this.chessBoardPos, this.whitePieces, this.blackPieces, this.movedPiece, this.castleFlags));
    }

    public boolean handleMouseEvent(double clickX, double clickY, boolean mouseDown) {
        if (mouseDown && this.selectedPiece != null) {
            int boardX = this.screenXtoBoardX((int)clickX);
            int boardY = this.screenYtoBoardY((int)clickY);
            if ((this.selectedPiece.x != boardX || this.selectedPiece.y != boardY) && this.selectedPiece.move(boardX, boardY)) {
                if (this.selectedPiece.black) {
                    if (this.selectedPiece.getId() == PieceIds.ROOK.ordinal()) {
                        if (this.selectedPiece.x == 0 && this.selectedPiece.y == 7) {
                            this.castleFlags.blackLeftRookHasMoved = true;
                        } else if (this.selectedPiece.x == 7 && this.selectedPiece.y == 7) {
                            this.castleFlags.blackRightRookHasMoved = true;
                        }
                    } else if (this.selectedPiece.getId() == PieceIds.KING.ordinal()) {
                        this.castleFlags.blackKingHasMoved = true;
                    }
                } else if (this.selectedPiece.getId() == PieceIds.ROOK.ordinal()) {
                    if (this.selectedPiece.x == 0 && this.selectedPiece.y == 7) {
                        this.castleFlags.whiteLeftRookHasMoved = true;
                    } else if (this.selectedPiece.x == 7 && this.selectedPiece.y == 7) {
                        this.castleFlags.whiteRightRookHasMoved = true;
                    }
                } else if (this.selectedPiece.getId() == PieceIds.KING.ordinal()) {
                    this.castleFlags.whiteKingHasMoved = true;
                }
                this.movedPiece = this.selectedPiece;
                this.selectedPiece = null;
                this.assignNamesAndSubmitTurn();
                return true;
            }
        }
        return false;
    }

    public boolean m_7979_(double dragX, double dragY, int p_231045_5_, double p_231045_6_, double p_231045_8_) {
        if (p_231045_5_ == 0) {
            this.handleMouseEvent(dragX, dragY, true);
        }
        return super.m_7979_(dragX, dragY, p_231045_5_, p_231045_6_, p_231045_8_);
    }

    public boolean m_6375_(double clickX, double clickY, int p_231044_5_) {
        if (p_231044_5_ == 0) {
            this.m_7897_(true);
            if (this.handleMouseEvent(clickX, clickY, true)) {
                return false;
            }
        }
        return super.m_6375_(clickX, clickY, p_231044_5_);
    }

    public boolean m_6348_(double clickX, double clickY, int p_231044_5_) {
        this.m_7897_(false);
        if (p_231044_5_ == 0) {
            this.handleMouseEvent(clickX, clickY, false);
        }
        return super.m_6348_(clickX, clickY, p_231044_5_);
    }

    protected Button addSingularPiece(boolean black, int p_i51134_1_, int p_i51134_2_, int p_i51134_3_, int p_i51134_4_, int p_i51134_5_, int p_i51134_6_, int p_i51134_7_, ResourceLocation p_i51134_8_, Button.OnPress p_i51134_9_) {
        if (!black) {
            return new InvertedImageButton(p_i51134_1_, p_i51134_2_, p_i51134_3_, p_i51134_4_, p_i51134_5_, p_i51134_6_, p_i51134_7_, p_i51134_8_, p_i51134_9_);
        }
        return new ImageButton(p_i51134_1_, p_i51134_2_, p_i51134_3_, p_i51134_4_, p_i51134_5_, p_i51134_6_, p_i51134_7_, p_i51134_8_, p_i51134_9_);
    }

    protected Button addSingularPieceXDiff(boolean black, int p_i51134_1_, int p_i51134_2_, int p_i51134_3_, int p_i51134_4_, int p_i51134_5_, int p_i51134_6_, int p_i51134_7_, ResourceLocation p_i51134_8_, Button.OnPress p_i51134_9_) {
        if (!black) {
            return new InvertedImageButtonXDiff(p_i51134_1_, p_i51134_2_, p_i51134_3_, p_i51134_4_, p_i51134_5_, p_i51134_6_, p_i51134_7_, p_i51134_8_, p_i51134_9_);
        }
        return new ImageButtonXDiff(p_i51134_1_, p_i51134_2_, p_i51134_3_, p_i51134_4_, p_i51134_5_, p_i51134_6_, p_i51134_7_, p_i51134_8_, p_i51134_9_);
    }

    protected int getBottomStartX() {
        return (this.f_96543_ - 230) / 2 + 20;
    }

    protected int getBottomStartY() {
        return (this.f_96544_ - 230) / 2 + 188;
    }

    protected int getTopStartX() {
        return (this.f_96543_ - 230) / 2 + 20;
    }

    protected int getTopStartY() {
        return (this.f_96544_ - 230) / 2 + 20;
    }

    public int screenXtoBoardX(int screenX) {
        if (screenX < this.getTopStartX()) {
            return -1;
        }
        return (screenX - this.getTopStartX()) / 24;
    }

    public int screenYtoBoardY(int screenY) {
        if (screenY < this.getTopStartY()) {
            return -1;
        }
        return (screenY - this.getTopStartY()) / 24;
    }

    public int boardXtoScreenX(int boardX) {
        return boardX * 24 + this.getTopStartX();
    }

    public int boardYtoScreenY(int boardY) {
        return boardY * 24 + this.getTopStartY();
    }

    public Piece getPieceAt(int x, int y) {
        for (Piece p : this.whitePieces) {
            if (p.x != x || p.y != y) continue;
            return p;
        }
        for (Piece p : this.blackPieces) {
            if (p.x != x || p.y != y) continue;
            return p;
        }
        return null;
    }

    protected CheckState getCheckState() {
        if (this.blackKing.inCheck()) {
            int moveCount = this.blackAvailableMoveCount();
            if (moveCount == 0) {
                return CheckState.BLACK_CHECKMATE;
            }
            return CheckState.BLACK_CHECK;
        }
        if (this.whiteKing.inCheck()) {
            int moveCount = this.whiteAvailableMoveCount();
            if (moveCount == 0) {
                return CheckState.WHITE_CHECKMATE;
            }
            return CheckState.WHITE_CHECK;
        }
        return CheckState.NONE;
    }

    protected void initPieceXandY() {
        for (Piece p : this.whitePieces) {
            if (p.button == null) continue;
            p.x = this.screenXtoBoardX(p.button.m_252754_());
            p.y = this.screenYtoBoardY(p.button.m_252907_());
            p.screen = this;
            p.black = false;
            p.top = !this.playerIsWhite;
        }
        for (Piece p : this.blackPieces) {
            if (p.button == null) continue;
            p.x = this.screenXtoBoardX(p.button.m_252754_());
            p.y = this.screenYtoBoardY(p.button.m_252907_());
            p.screen = this;
            p.black = true;
            p.top = this.playerIsWhite;
        }
    }

    protected void initPieceInitialXY() {
        for (Piece p : this.whitePieces) {
            p.initialX = p.x;
            p.initialY = p.y;
        }
        for (Piece p : this.blackPieces) {
            p.initialX = p.x;
            p.initialY = p.y;
        }
    }

    protected int getTexOffsetX(Piece p) {
        if (p.getId() == PieceIds.QUEEN.ordinal()) {
            return 0;
        }
        return 233;
    }

    protected int getTexOffsetY(Piece p) {
        if (p.getId() == PieceIds.QUEEN.ordinal()) {
            return 233;
        }
        return 46 * p.getId();
    }

    protected void addPieceWithButton(Piece p, boolean top, boolean black, int boardX, int boardY) {
        if (p instanceof QueenPiece) {
            Button b;
            ButtonPressResult press = new ButtonPressResult(p, top, black);
            press.piece.button = b = (Button)this.m_142416_((GuiEventListener)this.addSingularPieceXDiff(black, this.boardXtoScreenX(boardX), this.boardYtoScreenY(boardY), 23, 23, this.getTexOffsetX(p), this.getTexOffsetY(p), 23, CHESS_UI, press));
        } else {
            Button b;
            ButtonPressResult press = new ButtonPressResult(p, top, black);
            press.piece.button = b = (Button)this.m_142416_((GuiEventListener)this.addSingularPiece(black, this.boardXtoScreenX(boardX), this.boardYtoScreenY(boardY), 23, 23, this.getTexOffsetX(p), this.getTexOffsetY(p), 23, CHESS_UI, press));
        }
    }

    protected void addPieces(boolean black, boolean top) {
        int startX = this.getBottomStartX();
        int startY = this.getBottomStartY();
        if (top) {
            startX = this.getTopStartX();
            startY = this.getTopStartY();
        }
        int rowSwitch = -24;
        if (top) {
            rowSwitch = 24;
        }
        ButtonPressResult press = null;
        press = new ButtonPressResult(new RookPiece(), top, black);
        press.piece.button = this.leftRook = (Button)this.m_142416_((GuiEventListener)this.addSingularPiece(black, startX + 0, startY, 23, 23, 233, 0, 23, CHESS_UI, press));
        press = new ButtonPressResult(new RookPiece(), top, black);
        press.piece.button = this.rightRook = (Button)this.m_142416_((GuiEventListener)this.addSingularPiece(black, startX + 168, startY, 23, 23, 233, 0, 23, CHESS_UI, press));
        press = new ButtonPressResult(new BishopPiece(), top, black);
        press.piece.button = this.leftBishop = (Button)this.m_142416_((GuiEventListener)this.addSingularPiece(black, startX + 48, startY, 23, 23, 233, 46, 23, CHESS_UI, press));
        press = new ButtonPressResult(new BishopPiece(), top, black);
        press.piece.button = this.rightBishop = (Button)this.m_142416_((GuiEventListener)this.addSingularPiece(black, startX + 120, startY, 23, 23, 233, 46, 23, CHESS_UI, press));
        for (int p = 0; p < 8; ++p) {
            press = new ButtonPressResult(new PawnPiece(), top, black);
            press.piece.button = this.pawn1 = (Button)this.m_142416_((GuiEventListener)this.addSingularPiece(black, startX + 24 * p, startY + rowSwitch, 23, 23, 233, 92, 23, CHESS_UI, press));
        }
        press = new ButtonPressResult(new KnightPiece(), top, black);
        press.piece.button = this.leftKnight = (Button)this.m_142416_((GuiEventListener)this.addSingularPiece(black, startX + 24, startY, 23, 23, 233, 138, 23, CHESS_UI, press));
        press = new ButtonPressResult(new KnightPiece(), top, black);
        press.piece.button = this.rightKnight = (Button)this.m_142416_((GuiEventListener)this.addSingularPiece(black, startX + 144, startY, 23, 23, 233, 138, 23, CHESS_UI, press));
        press = new ButtonPressResult(new KingPiece(), top, black);
        press.piece.button = this.king = (Button)this.m_142416_((GuiEventListener)this.addSingularPiece(black, startX + 96, startY, 23, 23, 233, 184, 23, CHESS_UI, press));
        press = new ButtonPressResult(new QueenPiece(), top, black);
        press.piece.button = this.queen = (Button)this.m_142416_((GuiEventListener)this.addSingularPieceXDiff(black, startX + 72, startY, 23, 23, 0, 233, 23, CHESS_UI, press));
        this.initPieceXandY();
        this.initPieceInitialXY();
    }

    protected void mirrorBoard() {
        for (Piece p : this.whitePieces) {
            p.absMoveTo(7 - p.x, 7 - p.y);
        }
        for (Piece p : this.blackPieces) {
            p.absMoveTo(7 - p.x, 7 - p.y);
        }
        if (this.movedPiece != null) {
            this.movedPiece.x = 7 - this.movedPiece.x;
            this.movedPiece.y = 7 - this.movedPiece.y;
        }
    }

    protected void addPieces() {
        CheckState checkState;
        boolean addedPieces = false;
        if (!this.restartingGame) {
            ChessBoardBlockEntity chessBoard;
            ItemStack itemStack;
            BlockEntity tileEntity = this.getMinecraft().f_91073_.m_7702_(this.chessBoardPos);
            if (tileEntity instanceof ChessBoardBlockEntity && (itemStack = (chessBoard = (ChessBoardBlockEntity)tileEntity).m_8020_(0)).m_41720_() == CustomBlocks.ITEM_CHESS_BOARD.get() && itemStack.m_41783_() != null && itemStack.m_41783_().m_128441_("BoardState")) {
                addedPieces = true;
                ServerboundChessStatePacket packet = ServerboundChessStatePacket.fromNbt(itemStack.m_41783_());
                this.castleFlags.blackKingHasMoved = packet.castleFlags.blackKingHasMoved;
                this.castleFlags.blackLeftRookHasMoved = packet.castleFlags.blackLeftRookHasMoved;
                this.castleFlags.blackRightRookHasMoved = packet.castleFlags.blackRightRookHasMoved;
                this.castleFlags.whiteKingHasMoved = packet.castleFlags.whiteKingHasMoved;
                this.castleFlags.whiteLeftRookHasMoved = packet.castleFlags.whiteLeftRookHasMoved;
                this.castleFlags.whiteRightRookHasMoved = packet.castleFlags.whiteRightRookHasMoved;
                this.whitePieces.clear();
                this.blackPieces.clear();
                this.currentTurn = packet.currentTurn;
                this.whitePlayer = packet.whitePlayer;
                this.blackPlayer = packet.blackPlayer;
                this.isWhiteTurn = packet.isWhiteTurn;
                this.movedPiece = packet.movedPiece;
                this.assignWhitePlayer();
                for (Piece p : packet.whitePieces) {
                    this.addPieceWithButton(p, !this.playerIsWhite, false, p.x, p.y);
                }
                for (Piece p : packet.blackPieces) {
                    this.addPieceWithButton(p, this.playerIsWhite, true, p.x, p.y);
                }
                this.initPieceXandY();
                if (this.isExpectedPlayer) {
                    this.mirrorBoard();
                }
            }
        } else {
            this.restartingGame = false;
        }
        if (!addedPieces) {
            this.assignWhitePlayer();
            if (this.playerIsWhite) {
                this.addPieces(false, false);
                this.addPieces(true, true);
            } else {
                this.addPieces(true, false);
                this.addPieces(false, true);
            }
        }
        this.assignKingReferences();
        this.cachedCheckState = checkState = this.getCheckState();
        if (checkState == CheckState.BLACK_CHECKMATE || checkState == CheckState.WHITE_CHECKMATE) {
            this.canPlay = false;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void assignWhitePlayer() {
        block9: {
            block12: {
                block10: {
                    block11: {
                        block8: {
                            if (this.whitePlayer != null && !this.whitePlayer.isEmpty()) break block8;
                            ModernLifeCommon.LOGGER.debug("white null");
                            this.playerIsWhite = true;
                            this.isExpectedPlayer = true;
                            break block9;
                        }
                        if (this.blackPlayer != null && !this.blackPlayer.isEmpty()) break block10;
                        if (ChessScreen.playerCanPlayHimself) break block11;
                        v0 = this;
                        if (this.whitePlayer.equals(v0.f_96541_.m_91087_().f_91074_.m_7755_().getString())) break block10;
                    }
                    ModernLifeCommon.LOGGER.debug("black null");
                    this.playerIsWhite = false;
                    this.isExpectedPlayer = true;
                    break block9;
                }
                if (!this.isWhiteTurn) break block12;
                v1 = this;
                if (!this.whitePlayer.equals(v1.f_96541_.m_91087_().f_91074_.m_7755_().getString())) break block12;
                ModernLifeCommon.LOGGER.debug("white name match");
                this.playerIsWhite = true;
                this.isExpectedPlayer = true;
                break block9;
            }
            if (this.isWhiteTurn) ** GOTO lbl-1000
            v2 = this;
            if (this.blackPlayer.equals(v2.f_96541_.m_91087_().f_91074_.m_7755_().getString())) {
                ModernLifeCommon.LOGGER.debug("black name match");
                this.playerIsWhite = false;
                this.isExpectedPlayer = true;
            } else lbl-1000:
            // 2 sources

            {
                v3 = this;
                if (this.whitePlayer.equals(v3.f_96541_.m_91087_().f_91074_.m_7755_().getString())) {
                    ModernLifeCommon.LOGGER.debug("player is white");
                    this.playerIsWhite = true;
                } else {
                    v4 = this;
                    if (this.blackPlayer.equals(v4.f_96541_.m_91087_().f_91074_.m_7755_().getString())) {
                        ModernLifeCommon.LOGGER.debug("player is black");
                        this.playerIsWhite = false;
                    }
                }
                this.canPlay = false;
            }
        }
        if (this.playerIsWhite && !this.isWhiteTurn) {
            this.canPlay = false;
        } else if (!this.playerIsWhite && this.isWhiteTurn) {
            this.canPlay = false;
        }
    }

    private void assignKingReferences() {
        for (Piece p : this.whitePieces) {
            if (!(p instanceof KingPiece)) continue;
            this.whiteKing = (KingPiece)p;
        }
        for (Piece p : this.blackPieces) {
            if (!(p instanceof KingPiece)) continue;
            this.blackKing = (KingPiece)p;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canCastleLeftCheckInternal(KingPiece king) {
        int kingX = king.x;
        int kingY = king.y;
        try {
            if (king.inCheck()) {
                boolean bl = false;
                return bl;
            }
            int checkX = king.x;
            --checkX;
            while (checkX > 0) {
                Piece p = this.getPieceAt(checkX, king.y);
                if (p != null) {
                    boolean bl = false;
                    return bl;
                }
                --checkX;
            }
            int newKingX = king.x;
            --newKingX;
            while (newKingX > 1) {
                if (!king.canMove(newKingX, kingY)) {
                    boolean bl = false;
                    return bl;
                }
                king.move(newKingX, kingY);
                --newKingX;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            king.absMoveTo(kingX, kingY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canCastleRightCheckInternal(KingPiece king) {
        int kingX = king.x;
        int kingY = king.y;
        try {
            if (king.inCheck()) {
                boolean bl = false;
                return bl;
            }
            int checkX = king.x;
            ++checkX;
            while (checkX < 7) {
                Piece p = this.getPieceAt(checkX, king.y);
                if (p != null) {
                    boolean bl = false;
                    return bl;
                }
                ++checkX;
            }
            int newKingX = king.x;
            ++newKingX;
            while (newKingX < 7) {
                if (!king.canMove(newKingX, kingY)) {
                    boolean bl = false;
                    return bl;
                }
                king.move(newKingX, kingY);
                ++newKingX;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            king.absMoveTo(kingX, kingY);
        }
    }

    private boolean canCastleLeft() {
        if (this.canPlay) {
            if (this.playerIsWhite) {
                if (!this.castleFlags.whiteKingHasMoved && !this.castleFlags.whiteLeftRookHasMoved) {
                    return this.canCastleLeftCheckInternal(this.whiteKing);
                }
            } else if (!this.castleFlags.blackKingHasMoved && !this.castleFlags.blackLeftRookHasMoved) {
                return this.canCastleLeftCheckInternal(this.blackKing);
            }
        }
        return false;
    }

    private boolean canCastleRight() {
        if (this.canPlay) {
            if (this.playerIsWhite) {
                if (!this.castleFlags.whiteKingHasMoved && !this.castleFlags.whiteRightRookHasMoved) {
                    return this.canCastleRightCheckInternal(this.whiteKing);
                }
            } else if (!this.castleFlags.blackKingHasMoved && !this.castleFlags.blackRightRookHasMoved) {
                return this.canCastleRightCheckInternal(this.blackKing);
            }
        }
        return false;
    }

    private boolean canCastle() {
        return this.canCastleLeft() || this.canCastleRight();
    }

    /*
     * Unable to fully structure code
     */
    private boolean canRestart() {
        if (this.whitePlayer == null) ** GOTO lbl-1000
        v0 = this;
        if (this.whitePlayer.equals(v0.f_96541_.m_91087_().f_91074_.m_7755_().getString())) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = currentClientIsWhitePlayer = false;
        }
        if (this.blackPlayer == null) ** GOTO lbl-1000
        v2 = this;
        if (this.blackPlayer.equals(v2.f_96541_.m_91087_().f_91074_.m_7755_().getString())) {
            v3 = true;
        } else lbl-1000:
        // 2 sources

        {
            v3 = false;
        }
        currentClientIsBlackPlayer = v3;
        return (currentClientIsWhitePlayer != false || currentClientIsBlackPlayer != false) && this.currentTurn > 0;
    }

    protected void m_7856_() {
        this.addPieces();
        int startX = (this.f_96543_ - 230) / 2 + 230 - 3 - 42;
        int startY = (this.f_96544_ - 230) / 2 + 216;
        final ChessScreen thisScreen = this;
        if (this.canCastleLeft()) {
            this.leftCastleButton = (Button)this.m_142416_((GuiEventListener)new ImageButton(startX, startY, 14, 13, 47, 230, 13, CHESS_UI, new Button.OnPress(){

                public void m_93750_(Button arg0) {
                    if (!ChessScreen.this.canPlay) {
                        return;
                    }
                    if (ChessScreen.this.leftCastleButtonState == 0) {
                        ChessScreen.this.restartButtonState = 0;
                        ChessScreen.this.rightCastleButtonState = 0;
                        ChessScreen.this.leftCastleButtonState = 1;
                        Minecraft.m_91087_().f_91074_.m_5661_((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("Click again to confirm")), false);
                    } else if (ChessScreen.this.leftCastleButtonState == 1) {
                        Piece rookPiece;
                        KingPiece kingPiece = null;
                        kingPiece = ChessScreen.this.playerIsWhite ? thisScreen.whiteKing : thisScreen.blackKing;
                        if (kingPiece != null && kingPiece instanceof KingPiece && (rookPiece = thisScreen.getPieceAt(0, 7)) != null && rookPiece instanceof RookPiece) {
                            kingPiece.absMoveTo(kingPiece.x - 2, kingPiece.y);
                            rookPiece.absMoveTo(kingPiece.x + 1, kingPiece.y);
                            if (ChessScreen.this.playerIsWhite) {
                                ChessScreen.this.castleFlags.whiteKingHasMoved = true;
                            } else {
                                ChessScreen.this.castleFlags.blackKingHasMoved = true;
                            }
                            ChessScreen.this.movedPiece = kingPiece;
                            ChessScreen.this.assignNamesAndSubmitTurn();
                        }
                    }
                }
            }));
        }
        if (this.canCastleRight()) {
            this.rightCastleButton = (Button)this.m_142416_((GuiEventListener)new ImageButton(startX + 1 + 14, startY, 14, 13, 61, 230, 13, CHESS_UI, new Button.OnPress(){

                public void m_93750_(Button arg0) {
                    if (!ChessScreen.this.canPlay) {
                        return;
                    }
                    if (ChessScreen.this.rightCastleButtonState == 0) {
                        ChessScreen.this.restartButtonState = 0;
                        ChessScreen.this.leftCastleButtonState = 0;
                        ChessScreen.this.rightCastleButtonState = 1;
                        Minecraft.m_91087_().f_91074_.m_5661_((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("Click again to confirm")), false);
                    } else if (ChessScreen.this.rightCastleButtonState == 1) {
                        Piece rookPiece;
                        KingPiece kingPiece = null;
                        kingPiece = ChessScreen.this.playerIsWhite ? thisScreen.whiteKing : thisScreen.blackKing;
                        if (kingPiece != null && kingPiece instanceof KingPiece && (rookPiece = thisScreen.getPieceAt(7, 7)) != null && rookPiece instanceof RookPiece) {
                            kingPiece.absMoveTo(kingPiece.x + 2, kingPiece.y);
                            rookPiece.absMoveTo(kingPiece.x - 1, kingPiece.y);
                            if (ChessScreen.this.playerIsWhite) {
                                ChessScreen.this.castleFlags.whiteKingHasMoved = true;
                            } else {
                                ChessScreen.this.castleFlags.blackKingHasMoved = true;
                            }
                            ChessScreen.this.movedPiece = kingPiece;
                            ChessScreen.this.assignNamesAndSubmitTurn();
                        }
                    }
                }
            }));
        }
        if (this.canRestart()) {
            this.restartButton = (Button)this.m_142416_((GuiEventListener)new ImageButton(startX + 2 + 28, startY, 14, 13, 75, 230, 13, CHESS_UI, new Button.OnPress(){

                public void m_93750_(Button arg0) {
                    if (ChessScreen.this.canRestart()) {
                        ChessBoardBlockEntity chessBoard;
                        ItemStack itemStack;
                        BlockEntity tileEntity;
                        if (ChessScreen.this.restartButtonState == 0) {
                            ChessScreen.this.leftCastleButtonState = 0;
                            ChessScreen.this.rightCastleButtonState = 0;
                            ChessScreen.this.restartButtonState = 1;
                            Minecraft.m_91087_().f_91074_.m_5661_((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("Click again to confirm")), false);
                        } else if (ChessScreen.this.restartButtonState == 1 && (tileEntity = Minecraft.m_91087_().f_91073_.m_7702_(ChessScreen.this.chessBoardPos)) instanceof ChessBoardBlockEntity && (itemStack = (chessBoard = (ChessBoardBlockEntity)tileEntity).m_8020_(0)).m_41720_() == CustomBlocks.ITEM_CHESS_BOARD.get() && itemStack.m_41783_() != null && itemStack.m_41783_().m_128441_("BoardState")) {
                            itemStack.m_41751_(new CompoundTag());
                            thisScreen.whitePieces.clear();
                            thisScreen.blackPieces.clear();
                            thisScreen.movedPiece = null;
                            thisScreen.m_169413_();
                            ChessScreen.this.restartingGame = true;
                            ChessScreen.this.whitePlayer = null;
                            ChessScreen.this.blackPlayer = null;
                            thisScreen.m_7856_();
                            ChessScreen.this.castleFlags = new CastleFlags();
                            CheckState newCheckState = thisScreen.getCheckState();
                            ChessScreen.this.mirrorBoard();
                            ModernLifeNetwork.INSTANCE.sendToServer((Object)new ServerboundChessStatePacket(0, newCheckState.ordinal(), ChessScreen.this.whitePlayer, ChessScreen.this.blackPlayer, true, ChessScreen.this.chessBoardPos, thisScreen.whitePieces, thisScreen.blackPieces, ChessScreen.this.movedPiece, ChessScreen.this.castleFlags));
                        }
                    }
                }
            }));
        }
    }

    public boolean m_7043_() {
        return false;
    }

    private void drawCenteredString(GuiGraphics graphics, Font font, Component p_238472_2_, int p_238472_3_, int p_238472_4_, int p_238472_5_) {
        FormattedCharSequence lvt_6_1_ = p_238472_2_.m_7532_();
        graphics.drawString(font, lvt_6_1_, (float)(p_238472_3_ - font.m_92724_(lvt_6_1_) / 2), (float)p_238472_4_, p_238472_5_, false);
    }

    int availableMoveCount(Piece p) {
        int moveCount = 0;
        int x = 0;
        while (true) {
            if (x >= 8) break;
            int y = 0;
            while (true) {
                if (y >= 8) break;
                if (p.canMove(x, y)) {
                    ++moveCount;
                }
                ++y;
            }
            ++x;
        }
        return moveCount;
    }

    int whiteAvailableMoveCount() {
        int moveCount = 0;
        for (Piece p : this.whitePieces) {
            moveCount += this.availableMoveCount(p);
        }
        return moveCount;
    }

    int blackAvailableMoveCount() {
        int moveCount = 0;
        for (Piece p : this.blackPieces) {
            moveCount += this.availableMoveCount(p);
        }
        return moveCount;
    }

    public void showTooltipForPiece(GuiGraphics graphics, Piece p) {
        String pieceName = "";
        if (p instanceof RookPiece) {
            pieceName = "Rook";
        } else if (p instanceof BishopPiece) {
            pieceName = "Bishop";
        } else if (p instanceof PawnPiece) {
            pieceName = "Pawn";
        } else if (p instanceof KnightPiece) {
            pieceName = "Knight";
        } else if (p instanceof KingPiece) {
            pieceName = "King";
        } else if (p instanceof QueenPiece) {
            pieceName = "Queen";
        }
        graphics.m_280557_(Minecraft.m_91087_().f_91062_, (Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents(pieceName)), this.boardXtoScreenX(p.x), this.boardYtoScreenY(p.y));
    }

    public void m_88315_(GuiGraphics graphics, int p_230430_2_, int p_230430_3_, float p_230430_4_) {
        CheckState checkState;
        this.m_280273_(graphics);
        int xStart = (this.f_96543_ - 230) / 2;
        int yStart = (this.f_96544_ - 230) / 2;
        graphics.m_280218_(CHESS_UI, xStart, yStart, 0, 0, 230, 230);
        if (this.movedPiece != null) {
            int screenX = this.boardXtoScreenX(this.movedPiece.x);
            int screenY = this.boardYtoScreenY(this.movedPiece.y);
            graphics.m_280024_(screenX, screenY, screenX + 23 - 1, screenY + 23 - 1, 1348134655, 1348134655);
        }
        if (this.drawSelectionX != -1 && this.drawSelectionY != -1 && this.selectedPiece != null) {
            graphics.m_280024_(this.drawSelectionX, this.drawSelectionY, this.drawSelectionX + 23 - 1, this.drawSelectionY + 23 - 1, 0x50FF0000, 0x50000000);
            int x = 0;
            while (true) {
                if (x >= 8) break;
                int y = 0;
                while (true) {
                    if (y >= 8) break;
                    if (this.selectedPiece.canMove(x, y)) {
                        int screenX = this.boardXtoScreenX(x);
                        int screenY = this.boardYtoScreenY(y);
                        graphics.m_280024_(screenX, screenY, screenX + 23 - 1, screenY + 23 - 1, 0x5000FF00, 0x50000000);
                    }
                    ++y;
                }
                ++x;
            }
        }
        if ((checkState = this.cachedCheckState) == CheckState.BLACK_CHECKMATE || checkState == CheckState.WHITE_CHECKMATE) {
            String toDisplay = "";
            if (checkState == CheckState.BLACK_CHECKMATE) {
                toDisplay = "WHITE WINS!  Black checkmate";
            } else if (checkState == CheckState.WHITE_CHECKMATE) {
                toDisplay = "BLACK WINS!  White checkmate";
            }
            this.drawCenteredString(graphics, this.f_96541_.f_91062_, (Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents(toDisplay)).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)-65536))), xStart + 115, yStart + 2, 0);
        } else if (checkState != CheckState.NONE) {
            String toDisplay = "";
            if (checkState == CheckState.BLACK_CHECK) {
                toDisplay = "BLACK CHECK";
            } else if (checkState == CheckState.WHITE_CHECK) {
                toDisplay = "WHITE CHECK";
            }
            this.drawCenteredString(graphics, this.f_96541_.f_91062_, (Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents(toDisplay)).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)-65536))), xStart + 115, yStart + 2, 0);
        }
        if (this.canPlay) {
            String turnText = "It's your turn";
            this.drawCenteredString(graphics, this.f_96541_.f_91062_, (Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents(turnText)).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)-1))), xStart + 115, yStart + 230 - 13, 0);
        }
        for (Piece p : this.whitePieces) {
            if (!p.button.m_198029_()) continue;
            this.showTooltipForPiece(graphics, p);
        }
        for (Piece p : this.blackPieces) {
            if (!p.button.m_198029_()) continue;
            this.showTooltipForPiece(graphics, p);
        }
        if (this.leftCastleButton != null && this.leftCastleButton.m_198029_()) {
            graphics.m_280557_(Minecraft.m_91087_().f_91062_, (Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("Castle Left (Special Move)")), this.leftCastleButton.m_252754_(), this.leftCastleButton.m_252907_());
        }
        if (this.rightCastleButton != null && this.rightCastleButton.m_198029_()) {
            graphics.m_280557_(Minecraft.m_91087_().f_91062_, (Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("Castle Right (Special Move)")), this.rightCastleButton.m_252754_(), this.rightCastleButton.m_252907_());
        }
        if (this.restartButton != null && this.restartButton.m_198029_()) {
            graphics.m_280557_(Minecraft.m_91087_().f_91062_, (Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("Restart Game")), this.restartButton.m_252754_(), this.restartButton.m_252907_());
        }
        super.m_88315_(graphics, p_230430_2_, p_230430_3_, p_230430_4_);
    }

    public static class CastleFlags {
        public boolean whiteKingHasMoved = false;
        public boolean whiteLeftRookHasMoved = false;
        public boolean whiteRightRookHasMoved = false;
        public boolean blackKingHasMoved = false;
        public boolean blackLeftRookHasMoved = false;
        public boolean blackRightRookHasMoved = false;
    }

    public class ButtonPressResult
    implements Button.OnPress {
        Piece piece;
        boolean top;
        boolean black;

        ButtonPressResult(Piece piece, boolean top, boolean black) {
            this.piece = piece;
            this.top = top;
            this.black = black;
            if (this.black) {
                ChessScreen.this.blackPieces.add(piece);
            } else {
                ChessScreen.this.whitePieces.add(piece);
            }
        }

        public void m_93750_(Button button) {
            if (!ChessScreen.this.canPlay) {
                return;
            }
            if (!this.top) {
                if (ChessScreen.this.selectedPiece == this.piece) {
                    ChessScreen.this.selectedPiece = null;
                } else {
                    ChessScreen.this.drawSelectionX = button.m_252754_();
                    ChessScreen.this.drawSelectionY = button.m_252907_();
                    ChessScreen.this.selectedPiece = this.piece;
                }
            }
        }
    }
}

