/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.blocks.gui;

import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.core.ModernLifeCommon;
import com.dairymoose.modernlife.core.ModernLifeNetwork;
import com.dairymoose.modernlife.items.GuitarItem;
import com.dairymoose.modernlife.network.play.client.ServerboundGuitarPacket;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class GuitarScreen
extends Screen {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation GUITAR_GUI = new ResourceLocation("modernlife", "textures/gui/mc_guitar_keys_full.png");
    final int GUI_WIDTH = 256;
    final int GUI_HEIGHT = 134;
    private Level world;
    private Player player;
    GuitarItem.Tuning string = GuitarItem.Tuning.STRING_E;
    int lastPlayedFret = -1;
    int counter = 1;
    char[] fretKeys = new char[]{'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I', 'O', 'P', 'A', 'S', 'D', 'F', 'G', 'H', 'J', 'K', 'L', 'Z', 'X', 'C', 'V', 'B', 'N'};
    char[] stringKeys = new char[]{'1', '2', '3', '4', '5', '6'};

    public GuitarScreen(Level world, Player player) {
        super((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("Guitar")).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x404040))));
        this.world = world;
        this.player = player;
    }

    protected void m_7856_() {
        ModernLifeCommon.LOGGER.debug("in init!");
        int startX = (this.f_96543_ - 256) / 2;
        int startY = (this.f_96544_ - 134) / 2;
    }

    public boolean m_7043_() {
        return false;
    }

    private boolean areaContainsAmplifier(BlockPos pos) {
        BlockState state = this.world.m_8055_(pos);
        if (state.m_60713_((Block)CustomBlocks.BLOCK_GUITAR_AMPLIFIER.get())) {
            return true;
        }
        state = this.world.m_8055_(pos.m_7494_());
        if (state.m_60713_((Block)CustomBlocks.BLOCK_GUITAR_AMPLIFIER.get())) {
            return true;
        }
        state = this.world.m_8055_(pos.m_7495_());
        return state.m_60713_((Block)CustomBlocks.BLOCK_GUITAR_AMPLIFIER.get());
    }

    public boolean isNearAmplifier(Level world, BlockPos pos) {
        if (world == null || pos == null) {
            return false;
        }
        for (int x = -6; x < 6; ++x) {
            for (int z = -6; z < 6; ++z) {
                BlockPos searchPos = pos.m_122030_(x);
                if (!this.areaContainsAmplifier(searchPos = searchPos.m_122020_(z))) continue;
                return true;
            }
        }
        return false;
    }

    public void applyGuitarStringChange(int stringNo) {
        if (stringNo == 1) {
            this.string = GuitarItem.Tuning.STRING_E;
        } else if (stringNo == 2) {
            this.string = GuitarItem.Tuning.STRING_A;
        } else if (stringNo == 3) {
            this.string = GuitarItem.Tuning.STRING_D;
        } else if (stringNo == 4) {
            this.string = GuitarItem.Tuning.STRING_G;
        } else if (stringNo == 5) {
            this.string = GuitarItem.Tuning.STRING_B;
        } else if (stringNo == 6) {
            this.string = GuitarItem.Tuning.STRING_HI_E;
        }
    }

    public int getGuitarStringNo() {
        if (this.string == GuitarItem.Tuning.STRING_E) {
            return 1;
        }
        if (this.string == GuitarItem.Tuning.STRING_A) {
            return 2;
        }
        if (this.string == GuitarItem.Tuning.STRING_D) {
            return 3;
        }
        if (this.string == GuitarItem.Tuning.STRING_G) {
            return 4;
        }
        if (this.string == GuitarItem.Tuning.STRING_B) {
            return 5;
        }
        if (this.string == GuitarItem.Tuning.STRING_HI_E) {
            return 6;
        }
        return 1;
    }

    public boolean m_6050_(double a, double b, double c) {
        int currentStringNo = this.getGuitarStringNo();
        if (c > 0.0) {
            this.applyGuitarStringChange(currentStringNo - 1);
        } else {
            this.applyGuitarStringChange(currentStringNo + 1);
        }
        return super.m_6050_(a, b, c);
    }

    public boolean m_7933_(int key, int p_231046_2_, int p_231046_3_) {
        ModernLifeCommon.LOGGER.debug("key press: " + key);
        int keyIndex = ArrayUtils.indexOf((char[])this.stringKeys, (char)((char)key));
        if (keyIndex != -1) {
            int stringNo = keyIndex + 1;
            this.applyGuitarStringChange(stringNo);
        }
        keyIndex = ArrayUtils.indexOf((char[])this.fretKeys, (char)((char)key));
        boolean distorted = this.isNearAmplifier(this.world, this.player.m_20183_());
        if (keyIndex != -1) {
            int fret = keyIndex + 1;
            if (this.player != null && this.world != null) {
                ServerboundGuitarPacket.playGuitarSound(this.world, this.player, this.player.m_20183_(), ServerboundGuitarPacket.getSoundEvent(this.string, distorted), distorted, fret);
            }
            ServerboundGuitarPacket packet = new ServerboundGuitarPacket(this.string, fret, distorted);
            ModernLifeNetwork.INSTANCE.sendToServer((Object)packet);
            this.lastPlayedFret = fret - 1;
        }
        return super.m_7933_(key, p_231046_2_, p_231046_3_);
    }

    private void drawCenteredStringNoShadow(GuiGraphics graphics, Font font, Component p_238472_2_, int p_238472_3_, int p_238472_4_, int p_238472_5_) {
        FormattedCharSequence lvt_6_1_ = p_238472_2_.m_7532_();
        graphics.drawString(font, lvt_6_1_, (float)(p_238472_3_ - font.m_92724_(lvt_6_1_) / 2), (float)p_238472_4_, p_238472_5_, false);
    }

    private String numberSuffix(int fret) {
        int lastDigit = fret % 10;
        if (fret == 11) {
            return "th";
        }
        if (fret == 12) {
            return "th";
        }
        if (fret == 13) {
            return "th";
        }
        if (lastDigit == 1) {
            return "st";
        }
        if (lastDigit == 2) {
            return "nd";
        }
        if (lastDigit == 3) {
            return "rd";
        }
        return "th";
    }

    public void m_88315_(GuiGraphics graphics, int p_230430_2_, int p_230430_3_, float p_230430_4_) {
        int lvt_5_1_ = (this.f_96543_ - 256) / 2;
        int lvt_6_1_ = (this.f_96544_ - 134) / 2;
        graphics.m_280218_(GUITAR_GUI, lvt_5_1_, lvt_6_1_, 0, 0, 256, 134);
        String stringText = "";
        if (this.string == GuitarItem.Tuning.STRING_E) {
            stringText = "E String";
        } else if (this.string == GuitarItem.Tuning.STRING_A) {
            stringText = "A String";
        } else if (this.string == GuitarItem.Tuning.STRING_D) {
            stringText = "D String";
        } else if (this.string == GuitarItem.Tuning.STRING_G) {
            stringText = "G String";
        } else if (this.string == GuitarItem.Tuning.STRING_B) {
            stringText = "B String";
        } else if (this.string == GuitarItem.Tuning.STRING_HI_E) {
            stringText = "High E String";
        }
        this.drawCenteredStringNoShadow(graphics, this.f_96541_.f_91062_, (Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents(stringText)).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFFFFFF))), lvt_5_1_ + 128, lvt_6_1_ + 53, 0);
        if (this.lastPlayedFret != -1) {
            String fretText = this.lastPlayedFret + this.numberSuffix(this.lastPlayedFret) + " fret";
            this.drawCenteredStringNoShadow(graphics, this.f_96541_.f_91062_, (Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents(fretText)).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFFFFFF))), lvt_5_1_ + 128, lvt_6_1_ + 140, 0);
        }
        super.m_88315_(graphics, p_230430_2_, p_230430_3_, p_230430_4_);
    }
}

