/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.blocks;

import com.dairymoose.modernlife.tileentities.WinchBlockEntity;
import com.dairymoose.modernlife.util.ModernLifeUtil;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChainBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class WinchBlock
extends FaceAttachedHorizontalDirectionalBlock
implements EntityBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    protected static final VoxelShape SHAPE_FLOOR_SOUTH = Stream.of(Block.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)1.0, (double)12.0), Block.m_49796_((double)4.0, (double)1.0, (double)5.0, (double)14.0, (double)2.0, (double)6.0), Block.m_49796_((double)0.5, (double)1.0, (double)5.0, (double)4.0, (double)5.0, (double)11.0), Block.m_49796_((double)10.0, (double)5.0, (double)6.0, (double)14.5, (double)6.0, (double)10.0), Block.m_49796_((double)3.5, (double)5.0, (double)10.0, (double)14.5, (double)6.0, (double)11.0), Block.m_49796_((double)3.5, (double)5.0, (double)6.0, (double)6.0, (double)6.0, (double)10.0), Block.m_49796_((double)3.5, (double)5.0, (double)5.0, (double)14.5, (double)6.0, (double)6.0), Block.m_49796_((double)14.0, (double)1.0, (double)5.0, (double)15.0, (double)5.0, (double)11.0), Block.m_49796_((double)15.0, (double)1.0, (double)6.0, (double)16.0, (double)4.0, (double)10.0), Block.m_49796_((double)8.0, (double)0.0, (double)6.5, (double)8.0, (double)5.0, (double)9.5), Block.m_49796_((double)6.5, (double)0.0, (double)8.0, (double)9.5, (double)5.0, (double)8.0), Block.m_49796_((double)4.0, (double)1.0, (double)10.0, (double)14.0, (double)2.0, (double)11.0), Block.m_49796_((double)6.0, (double)5.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0), Block.m_49796_((double)4.75, (double)1.0, (double)8.0, (double)7.75, (double)6.0, (double)8.0), Block.m_49796_((double)6.603553390593274, (double)1.0, (double)6.353553390593273, (double)6.603553390593274, (double)6.0, (double)9.353553390593273), Block.m_49796_((double)7.0732233047033635, (double)1.0, (double)12.75, (double)10.073223304703363, (double)6.0, (double)12.75), Block.m_49796_((double)8.926776695296637, (double)1.0, (double)11.103553390593273, (double)8.926776695296637, (double)6.0, (double)14.103553390593273), Block.m_49796_((double)9.75, (double)1.0, (double)13.0, (double)12.75, (double)6.0, (double)13.0), Block.m_49796_((double)11.603553390593273, (double)1.0, (double)11.353553390593273, (double)11.603553390593273, (double)6.0, (double)14.353553390593273)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected final VoxelShape SHAPE_FLOOR_WEST = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_FLOOR_SOUTH);
    protected final VoxelShape SHAPE_FLOOR_NORTH = ModernLifeUtil.RotateVoxelShapeClockwise(this.SHAPE_FLOOR_WEST);
    protected final VoxelShape SHAPE_FLOOR_EAST = ModernLifeUtil.RotateVoxelShapeClockwise(this.SHAPE_FLOOR_NORTH);
    protected final VoxelShape SHAPE_WALL_SOUTH = ModernLifeUtil.RotateVoxelShapeXAxis(SHAPE_FLOOR_SOUTH);
    protected final VoxelShape SHAPE_WALL_WEST = ModernLifeUtil.RotateVoxelShapeClockwise(this.SHAPE_WALL_SOUTH);
    protected final VoxelShape SHAPE_WALL_NORTH = ModernLifeUtil.RotateVoxelShapeClockwise(this.SHAPE_WALL_WEST);
    protected final VoxelShape SHAPE_WALL_EAST = ModernLifeUtil.RotateVoxelShapeClockwise(this.SHAPE_WALL_NORTH);
    protected final VoxelShape SHAPE_CEILING_SOUTH = ModernLifeUtil.RotateVoxelShapeXAxis(this.SHAPE_WALL_SOUTH);
    protected final VoxelShape SHAPE_CEILING_WEST = ModernLifeUtil.RotateVoxelShapeClockwise(this.SHAPE_CEILING_SOUTH);
    protected final VoxelShape SHAPE_CEILING_NORTH = ModernLifeUtil.RotateVoxelShapeClockwise(this.SHAPE_CEILING_WEST);
    protected final VoxelShape SHAPE_CEILING_EAST = ModernLifeUtil.RotateVoxelShapeClockwise(this.SHAPE_CEILING_NORTH);

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack itemStack, @Nullable BlockGetter blockReader, List<Component> list, TooltipFlag tooltipFlag) {
        list.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("Requires redstone power to operate")));
    }

    public WinchBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_53179_, (Comparable)AttachFace.CEILING)).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return state;
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state;
    }

    public static int getLightLevel(BlockState state) {
        if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
            return 15;
        }
        return 0;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        boolean signal = false;
        BlockPos pos = context.m_8083_();
        signal = context.m_43725_().m_276867_(pos);
        BlockState superState = super.m_5573_(context);
        if (superState == null) {
            superState = this.m_49966_();
        }
        return (BlockState)superState.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(signal));
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos neighborPos, boolean p_220069_6_) {
        boolean signal = world.m_276867_(pos);
        if (block != this && signal != (Boolean)state.m_61143_((Property)POWERED)) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(signal)), 2);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_53179_, f_54117_, POWERED});
    }

    public MenuProvider m_7246_(BlockState state, final Level level, final BlockPos blockPos) {
        return new MenuProvider(){

            public AbstractContainerMenu m_7208_(int paramInt, Inventory paramInventory, Player paramPlayer) {
                BlockEntity tileEntity = level.m_7702_(blockPos);
                if (tileEntity instanceof WinchBlockEntity) {
                    WinchBlockEntity winchBlockEntity = (WinchBlockEntity)tileEntity;
                    ChestMenu chest = new ChestMenu(MenuType.f_39957_, paramInt, paramInventory, (Container)winchBlockEntity, 1);
                    if (!paramPlayer.m_9236_().f_46443_) {
                        // empty if block
                    }
                    return chest;
                }
                return null;
            }

            public Component m_5446_() {
                return MutableComponent.m_237204_((ComponentContents)new LiteralContents("Winch"));
            }
        };
    }

    public void m_6810_(BlockState p_51538_, Level p_51539_, BlockPos p_51540_, BlockState p_51541_, boolean p_51542_) {
        if (!p_51538_.m_60713_(p_51541_.m_60734_())) {
            BlockEntity blockentity = p_51539_.m_7702_(p_51540_);
            if (blockentity instanceof Container) {
                Containers.m_19002_((Level)p_51539_, (BlockPos)p_51540_, (Container)((Container)blockentity));
                p_51539_.m_46717_(p_51540_, (Block)this);
            }
            super.m_6810_(p_51538_, p_51539_, p_51540_, p_51541_, p_51542_);
        }
    }

    public InteractionResult m_6227_(BlockState blockState, Level world, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult rayTrace) {
        if (!world.f_46443_) {
            int chainSlot;
            WinchBlockEntity winch;
            BlockEntity blockEntity;
            ItemStack itemStack = player.m_21120_(hand);
            if (itemStack.m_150930_(Items.f_42026_)) {
                WinchBlockEntity winch2;
                BlockEntity blockEntity2 = world.m_7702_(blockPos);
                if (blockEntity2 instanceof WinchBlockEntity && (winch2 = (WinchBlockEntity)blockEntity2).canExpandChain()) {
                    BlockPos pos = winch2.getExpandedChainBlockPos();
                    if (world.m_8055_(pos).m_60795_()) {
                        itemStack.m_41774_(1);
                        AttachFace face = (AttachFace)blockEntity2.m_58900_().m_61143_((Property)f_53179_);
                        Direction facing = (Direction)blockEntity2.m_58900_().m_61143_((Property)f_54117_);
                        if (face == AttachFace.CEILING || face == AttachFace.FLOOR) {
                            world.m_7731_(pos, (BlockState)Blocks.f_50184_.m_49966_().m_61124_((Property)ChainBlock.f_55923_, (Comparable)Direction.Axis.Y), 2);
                        } else if (face == AttachFace.WALL && (facing == Direction.EAST || facing == Direction.WEST)) {
                            world.m_7731_(pos, (BlockState)Blocks.f_50184_.m_49966_().m_61124_((Property)ChainBlock.f_55923_, (Comparable)Direction.Axis.X), 2);
                        } else {
                            world.m_7731_(pos, (BlockState)Blocks.f_50184_.m_49966_().m_61124_((Property)ChainBlock.f_55923_, (Comparable)Direction.Axis.Z), 2);
                        }
                    }
                    world.m_46597_(blockPos, blockState);
                    ((ServerLevel)world).m_7260_(blockPos, blockState, blockState, 2);
                }
            } else if (player.m_20161_() && (blockEntity = world.m_7702_(blockPos)) instanceof WinchBlockEntity && (winch = (WinchBlockEntity)blockEntity).getInventoryChainCount() > 0 && (chainSlot = winch.getNextChainSlot()) != -1) {
                ItemStack chainItem = winch.m_8020_(chainSlot);
                ItemStack copiedChain = chainItem.m_41777_();
                copiedChain.m_41764_(1);
                chainItem.m_41774_(1);
                player.m_36356_(copiedChain);
            }
        }
        return InteractionResult.CONSUME;
    }

    public VoxelShape m_5940_(BlockState bs, BlockGetter reader, BlockPos pos, CollisionContext sel) {
        switch ((AttachFace)bs.m_61143_((Property)f_53179_)) {
            case CEILING: {
                switch ((Direction)bs.m_61143_((Property)f_54117_)) {
                    case NORTH: {
                        return this.SHAPE_CEILING_NORTH;
                    }
                    case EAST: {
                        return this.SHAPE_CEILING_EAST;
                    }
                    case WEST: {
                        return this.SHAPE_CEILING_WEST;
                    }
                    case SOUTH: {
                        return this.SHAPE_CEILING_SOUTH;
                    }
                }
            }
            case WALL: {
                switch ((Direction)bs.m_61143_((Property)f_54117_)) {
                    case NORTH: {
                        return this.SHAPE_WALL_NORTH;
                    }
                    case EAST: {
                        return this.SHAPE_WALL_EAST;
                    }
                    case WEST: {
                        return this.SHAPE_WALL_WEST;
                    }
                    case SOUTH: {
                        return this.SHAPE_WALL_SOUTH;
                    }
                }
            }
            case FLOOR: {
                switch ((Direction)bs.m_61143_((Property)f_54117_)) {
                    case NORTH: {
                        return this.SHAPE_FLOOR_NORTH;
                    }
                    case EAST: {
                        return this.SHAPE_FLOOR_EAST;
                    }
                    case WEST: {
                        return this.SHAPE_FLOOR_WEST;
                    }
                    case SOUTH: {
                        return SHAPE_FLOOR_SOUTH;
                    }
                }
            }
        }
        return this.SHAPE_FLOOR_NORTH;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> type) {
        return ModernLifeUtil.createTickerHelper(type, WinchBlockEntity.WINCH, WinchBlockEntity::tick);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        WinchBlockEntity toReturn = (WinchBlockEntity)WinchBlockEntity.WINCH.m_155264_(pos, state);
        return toReturn;
    }
}

