/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.blocks;

import com.dairymoose.modernlife.blocks.LightBulbBlock;
import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.core.ModernLifeConfig;
import com.dairymoose.modernlife.tileentities.WarningAlarmBlockEntity;
import com.dairymoose.modernlife.util.ModernLifeUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class WarningAlarmBlock
extends LightBulbBlock
implements EntityBlock {
    public static final IntegerProperty ALARM_TYPE = IntegerProperty.m_61631_((String)"alarm_type", (int)0, (int)5);
    static List<AlarmType> alarmTypes = new ArrayList<AlarmType>();

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack itemStack, @Nullable BlockGetter blockReader, List<Component> list, TooltipFlag tooltipFlag) {
        list.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("Sounds an alarm when powered by redstone; right-click with empty mainhand to change alarm sound")));
    }

    @Override
    public VoxelShape m_5940_(BlockState bs, BlockGetter reader, BlockPos pos, CollisionContext sel) {
        return super.m_5940_(bs, reader, pos, sel);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_53179_, f_54117_, POWERED, ALARM_TYPE});
    }

    public WarningAlarmBlock(BlockBehaviour.Properties props) {
        super(props, WarningAlarmBlock::getLightLevel, new BlockBehaviour.StatePredicate(){

            public boolean m_61035_(BlockState state, BlockGetter reader, BlockPos pos) {
                return false;
            }
        });
        this.SHAPE_CEILING = Shapes.m_83048_((double)0.4, (double)0.75, (double)0.4, (double)0.6, (double)1.0, (double)0.6);
        this.SHAPE_WALL_NORTH = ModernLifeUtil.RotateVoxelShapeXAxis(this.SHAPE_CEILING);
        this.SHAPE_WALL_EAST = ModernLifeUtil.RotateVoxelShapeClockwise(this.SHAPE_WALL_NORTH);
        this.SHAPE_WALL_SOUTH = ModernLifeUtil.RotateVoxelShapeClockwise(this.SHAPE_WALL_EAST);
        this.SHAPE_WALL_WEST = ModernLifeUtil.RotateVoxelShapeClockwise(this.SHAPE_WALL_SOUTH);
        this.SHAPE_FLOOR = ModernLifeUtil.RotateVoxelShapeXAxis(this.SHAPE_WALL_NORTH);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_53179_, (Comparable)AttachFace.CEILING)).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ALARM_TYPE, (Comparable)Integer.valueOf(1)));
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState placeState = super.m_5573_(context);
        return placeState;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult p_60508_) {
        if (!level.f_46443_ && hand == InteractionHand.MAIN_HAND && player.m_21120_(hand).m_41619_()) {
            BlockState newAlarmType = (BlockState)state.m_61122_((Property)ALARM_TYPE);
            level.m_7731_(blockPos, newAlarmType, 3);
            switch ((Integer)newAlarmType.m_61143_((Property)ALARM_TYPE)) {
                case 0: {
                    player.m_213846_((Component)Component.m_237113_((String)"Silent alarm"));
                    break;
                }
                case 1: {
                    player.m_213846_((Component)Component.m_237113_((String)"Alarm 1"));
                    break;
                }
                case 2: {
                    player.m_213846_((Component)Component.m_237113_((String)"Alarm 2"));
                    break;
                }
                case 3: {
                    player.m_213846_((Component)Component.m_237113_((String)"Alarm 3"));
                    break;
                }
                case 4: {
                    player.m_213846_((Component)Component.m_237113_((String)"Alarm 4"));
                    break;
                }
                case 5: {
                    player.m_213846_((Component)Component.m_237113_((String)"Alarm 5"));
                }
            }
        }
        return super.m_6227_(state, level, blockPos, player, hand, p_60508_);
    }

    public static int getLightLevel(BlockState state) {
        if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
            return 15;
        }
        return 0;
    }

    @Override
    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos neighborPos, boolean p_220069_6_) {
        boolean initialPowered = (Boolean)state.m_61143_((Property)POWERED);
        super.m_6861_(state, level, pos, block, neighborPos, p_220069_6_);
        BlockState newState = level.m_8055_(pos);
    }

    public void soundAlarmIfPowered(WarningAlarmBlockEntity entity, BlockState state, Level level, BlockPos pos) {
        if (level.f_46443_ && ((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
            this.soundAlarm(entity, state, level, pos);
        }
    }

    private void soundAlarm(WarningAlarmBlockEntity entity, BlockState state, Level level, BlockPos pos) {
        double x = pos.m_123341_();
        double y = pos.m_123342_();
        double z = pos.m_123343_();
        double vertDistParticle = 0.25;
        double horzDistParticle = 0.2;
        if (state.m_61143_((Property)f_53179_) == AttachFace.CEILING) {
            x += 0.5;
            y += 1.0 - vertDistParticle;
            z += 0.5;
        } else if (state.m_61143_((Property)f_53179_) == AttachFace.FLOOR) {
            x += 0.5;
            y += vertDistParticle;
            z += 0.5;
        } else if (state.m_61143_((Property)f_53179_) == AttachFace.WALL) {
            Direction facing = (Direction)state.m_61143_((Property)f_54117_);
            if (facing == Direction.NORTH) {
                x += 0.5;
                y += 0.5;
                z += 1.0 - horzDistParticle;
            } else if (facing == Direction.EAST) {
                x += horzDistParticle;
                y += 0.5;
                z += 0.5;
            } else if (facing == Direction.SOUTH) {
                x += 0.5;
                y += 0.5;
                z += horzDistParticle;
            }
            if (facing == Direction.WEST) {
                x += 1.0 - horzDistParticle;
                y += 0.5;
                z += 0.5;
            }
        }
        AlarmType alarmType = alarmTypes.get((Integer)state.m_61143_((Property)ALARM_TYPE));
        if (alarmType.tickPeriod > 0) {
            entity.alarmCooldownTicks = alarmType.tickPeriod;
            if (((Boolean)ModernLifeConfig.CLIENT.alarmCreatesParticles.get()).booleanValue()) {
                level.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, x, y, z, 0.05, 0.05, 0.05);
            }
            if (alarmType.sound != null) {
                level.m_245747_(pos, alarmType.sound, SoundSource.BLOCKS, ((Double)ModernLifeConfig.CLIENT.alarmVolume.get()).floatValue(), ((Double)ModernLifeConfig.CLIENT.alarmPitch.get()).floatValue(), false);
            }
        }
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        WarningAlarmBlockEntity toReturn = (WarningAlarmBlockEntity)WarningAlarmBlockEntity.WARNING_ALARM.m_155264_(pos, state);
        return toReturn;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return ModernLifeUtil.createTickerHelper(type, WarningAlarmBlockEntity.WARNING_ALARM, WarningAlarmBlockEntity::tick);
    }

    static {
        alarmTypes.add(new AlarmType(null, 20));
        alarmTypes.add(new AlarmType((SoundEvent)CustomBlocks.SOUND_WARNINGALARM_BIGWARNING.get(), 25));
        alarmTypes.add(new AlarmType((SoundEvent)CustomBlocks.SOUND_WARNINGALARM_SIREN.get(), 125));
        alarmTypes.add(new AlarmType((SoundEvent)CustomBlocks.SOUND_WARNINGALARM_WARN1.get(), 25));
        alarmTypes.add(new AlarmType((SoundEvent)CustomBlocks.SOUND_WARNINGALARM_WARN2.get(), 30));
        alarmTypes.add(new AlarmType((SoundEvent)CustomBlocks.SOUND_WARNINGALARM_WARN3.get(), 20));
    }

    private static class AlarmType {
        SoundEvent sound;
        int tickPeriod;

        public AlarmType(SoundEvent sound, int tickPeriod) {
            this.sound = sound;
            this.tickPeriod = tickPeriod;
        }
    }
}

