/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.blocks;

import com.dairymoose.modernlife.tileentities.WallShelfBlockEntity;
import com.dairymoose.modernlife.util.ModernLifeUtil;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class WallShelfBlock
extends Block
implements EntityBlock {
    protected static final VoxelShape SHAPE_SOUTH = Stream.of(Block.m_49796_((double)0.0, (double)4.5, (double)0.0, (double)16.0, (double)9.0, (double)6.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape SHAPE_WEST = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_SOUTH);
    protected static final VoxelShape SHAPE_NORTH = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_WEST);
    protected static final VoxelShape SHAPE_EAST = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_NORTH);
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;

    public WallShelfBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.SOUTH));
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        if (super.getFlammability(state, world, pos, face) > 0) {
            return 20;
        }
        return 0;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        if (super.getFlammability(state, world, pos, face) > 0) {
            return 5;
        }
        return 0;
    }

    public InteractionResult m_6227_(BlockState blockState, Level world, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult rayTrace) {
        if (!world.f_46443_) {
            ItemStack itemStack = player.m_21120_(hand);
            BlockEntity tileEntity = world.m_7702_(blockPos);
            WallShelfBlockEntity wallShelfBlockEntity = null;
            if (tileEntity instanceof WallShelfBlockEntity) {
                wallShelfBlockEntity = (WallShelfBlockEntity)tileEntity;
            }
            boolean tookItem = false;
            boolean placedItem = false;
            if (wallShelfBlockEntity != null) {
                int slot;
                if (!player.m_20161_() && !itemStack.m_41619_()) {
                    if (!wallShelfBlockEntity.isFull()) {
                        ItemStack oneItem = itemStack.m_41620_(1);
                        wallShelfBlockEntity.placeItem(oneItem);
                        placedItem = true;
                    }
                } else if (player.m_20161_() && !wallShelfBlockEntity.m_7983_() && (slot = wallShelfBlockEntity.getNextOccupiedSlot()) != -1) {
                    player.m_36356_(wallShelfBlockEntity.m_8020_(slot).m_41777_());
                    wallShelfBlockEntity.m_6836_(slot, ItemStack.f_41583_);
                    tookItem = true;
                }
                wallShelfBlockEntity.m_6596_();
            }
            world.m_7260_(blockPos, blockState, blockState, 2);
        }
        return InteractionResult.CONSUME;
    }

    public void m_6810_(BlockState p_196243_1_, Level p_196243_2_, BlockPos p_196243_3_, BlockState p_196243_4_, boolean p_196243_5_) {
        if (!p_196243_1_.m_60713_(p_196243_4_.m_60734_())) {
            BlockEntity lvt_6_1_ = p_196243_2_.m_7702_(p_196243_3_);
            if (lvt_6_1_ instanceof WallShelfBlockEntity) {
                Containers.m_19002_((Level)p_196243_2_, (BlockPos)p_196243_3_, (Container)((WallShelfBlockEntity)lvt_6_1_));
                p_196243_2_.m_46717_(p_196243_3_, (Block)this);
            }
            super.m_6810_(p_196243_1_, p_196243_2_, p_196243_3_, p_196243_4_, p_196243_5_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack itemStack, @Nullable BlockGetter blockReader, List<Component> list, TooltipFlag tooltipFlag) {
        list.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("Right click to place an item on the shelf")));
        list.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("Shift-right-click with an empty hand to remove an item")));
    }

    public BlockState m_7417_(BlockState p_196271_1_, Direction p_196271_2_, BlockState p_196271_3_, LevelAccessor p_196271_4_, BlockPos p_196271_5_, BlockPos p_196271_6_) {
        return ((Direction)p_196271_1_.m_61143_((Property)FACING)).m_122424_() == p_196271_2_ && !p_196271_1_.m_60710_((LevelReader)p_196271_4_, p_196271_5_) ? Blocks.f_50016_.m_49966_() : super.m_7417_(p_196271_1_, p_196271_2_, p_196271_3_, p_196271_4_, p_196271_5_, p_196271_6_);
    }

    public VoxelShape m_5940_(BlockState bs, BlockGetter reader, BlockPos pos, CollisionContext sel) {
        switch ((Direction)bs.m_61143_((Property)FACING)) {
            case NORTH: {
                return SHAPE_NORTH;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
            case EAST: {
                return SHAPE_EAST;
            }
            case WEST: {
                return SHAPE_WEST;
            }
        }
        return SHAPE_NORTH;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        WallShelfBlockEntity toReturn = (WallShelfBlockEntity)WallShelfBlockEntity.WALL_SHELF.m_155264_(pos, state);
        return toReturn;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public boolean m_7898_(BlockState p_196260_1_, LevelReader p_196260_2_, BlockPos p_196260_3_) {
        return FaceAttachedHorizontalDirectionalBlock.m_53196_((LevelReader)p_196260_2_, (BlockPos)p_196260_3_, (Direction)((Direction)p_196260_1_.m_61143_((Property)FACING)).m_122424_());
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        for (Direction lvt_5_1_ : context.m_6232_()) {
            BlockState lvt_6_2_;
            if (lvt_5_1_.m_122434_() == Direction.Axis.Y || !(lvt_6_2_ = (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)lvt_5_1_.m_122424_())).m_60710_((LevelReader)context.m_43725_(), context.m_8083_())) continue;
            return lvt_6_2_;
        }
        return this.m_49966_();
    }
}

