/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.blocks;

import com.dairymoose.modernlife.blocks.StandardHorizontalBlock;
import com.dairymoose.modernlife.util.ModernLifeUtil;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TurntableBlock
extends StandardHorizontalBlock {
    protected static final VoxelShape SHAPE_NORTH = Stream.of(Block.m_49796_((double)8.7, (double)0.0, (double)7.585786437626905, (double)9.0, (double)15.0, (double)8.414213562373096), Block.m_49796_((double)6.408701060962736, (double)15.0, (double)0.0, (double)9.591298939037264, (double)16.0, (double)7.0), Block.m_49796_((double)6.408701060962736, (double)15.0, (double)0.0, (double)9.591298939037264, (double)15.975000000000001, (double)7.0), Block.m_49796_((double)6.408701060962736, (double)15.0, (double)0.0, (double)9.591298939037264, (double)16.0, (double)7.0), Block.m_49796_((double)6.408701060962736, (double)15.0, (double)0.0, (double)9.591298939037264, (double)15.975000000000001, (double)7.0), Block.m_49796_((double)6.408701060962736, (double)15.0, (double)0.0, (double)9.591298939037264, (double)16.0, (double)7.0), Block.m_49796_((double)6.408701060962736, (double)15.0, (double)9.0, (double)9.591298939037264, (double)16.0, (double)16.0), Block.m_49796_((double)6.408701060962736, (double)15.0, (double)9.0, (double)9.591298939037264, (double)15.975000000000001, (double)16.0), Block.m_49796_((double)6.408701060962736, (double)15.0, (double)9.0, (double)9.591298939037264, (double)16.0, (double)16.0), Block.m_49796_((double)6.408701060962736, (double)15.0, (double)9.0, (double)9.591298939037264, (double)15.975000000000001, (double)16.0), Block.m_49796_((double)6.408701060962736, (double)15.0, (double)9.0, (double)9.591298939037264, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)15.0, (double)6.408701060962736, (double)7.0, (double)15.975000000000001, (double)9.591298939037264), Block.m_49796_((double)0.0, (double)15.0, (double)6.408701060962736, (double)7.0, (double)16.0, (double)9.591298939037264), Block.m_49796_((double)0.0, (double)15.0, (double)6.408701060962736, (double)7.0, (double)15.975000000000001, (double)9.591298939037264), Block.m_49796_((double)9.0, (double)15.0, (double)6.408701060962736, (double)16.0, (double)15.975000000000001, (double)9.591298939037264), Block.m_49796_((double)9.0, (double)15.0, (double)6.408701060962736, (double)16.0, (double)16.0, (double)9.591298939037264), Block.m_49796_((double)9.0, (double)15.0, (double)6.408701060962736, (double)16.0, (double)15.975000000000001, (double)9.591298939037264), Block.m_49796_((double)4.5, (double)15.5, (double)4.5, (double)11.5, (double)16.002, (double)11.5), Block.m_49796_((double)7.585786437626905, (double)0.0, (double)7.0, (double)8.414213562373096, (double)15.0, (double)7.3), Block.m_49796_((double)7.585786437626905, (double)0.0, (double)7.0, (double)8.414213562373096, (double)15.0, (double)7.3), Block.m_49796_((double)7.585786437626905, (double)0.0, (double)8.7, (double)8.414213562373096, (double)15.0, (double)9.0), Block.m_49796_((double)7.585786437626905, (double)0.0, (double)8.7, (double)8.414213562373096, (double)15.0, (double)9.0), Block.m_49796_((double)7.0, (double)0.0, (double)7.585786437626905, (double)7.3, (double)15.0, (double)8.414213562373096), Block.m_49796_((double)7.0, (double)0.0, (double)7.585786437626905, (double)7.3, (double)15.0, (double)8.414213562373096), Block.m_49796_((double)8.7, (double)0.0, (double)7.585786437626905, (double)9.0, (double)15.0, (double)8.414213562373096)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape SHAPE_EAST = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_NORTH);
    protected static final VoxelShape SHAPE_SOUTH = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_EAST);
    protected static final VoxelShape SHAPE_WEST = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_SOUTH);
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack itemStack, @Nullable BlockGetter blockReader, List<Component> list, TooltipFlag tooltipFlag) {
        list.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("Rotates clockwise when powered by redstone")));
    }

    public TurntableBlock(BlockBehaviour.Properties p_i48377_1_) {
        super(p_i48377_1_);
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos neighborPos, boolean p_220069_6_) {
        boolean signal = world.m_276867_(pos);
        Boolean currentPoweredState = (Boolean)state.m_61143_((Property)POWERED);
        if (block != this && signal != currentPoweredState) {
            BlockState newFacing = state;
            if (signal) {
                List aboveEntities;
                Direction currentFacing;
                Direction turntableFacing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
                turntableFacing = turntableFacing.m_122427_();
                newFacing = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)turntableFacing);
                BlockPos abovePos = pos.m_7494_();
                BlockState aboveState = world.m_8055_(abovePos);
                if (aboveState.m_60713_(Blocks.f_50039_)) {
                    world.m_7731_(abovePos, (BlockState)aboveState.m_61124_((Property)BlockStateProperties.f_61432_, (Comparable)Boolean.valueOf(false)), 2);
                }
                if (aboveState.m_61145_((Property)BlockStateProperties.f_61374_).isPresent()) {
                    currentFacing = (Direction)aboveState.m_61143_((Property)BlockStateProperties.f_61374_);
                    currentFacing = currentFacing.m_122427_();
                    aboveState = (BlockState)aboveState.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)currentFacing);
                    world.m_7731_(abovePos, aboveState, 2);
                }
                if (aboveState.m_61145_((Property)BlockStateProperties.f_61372_).isPresent()) {
                    if (aboveState.m_61143_((Property)BlockStateProperties.f_61372_) == Direction.UP) {
                        world.m_7731_(abovePos, (BlockState)aboveState.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Direction.DOWN), 2);
                    } else if (aboveState.m_61143_((Property)BlockStateProperties.f_61372_) == Direction.DOWN) {
                        world.m_7731_(abovePos, (BlockState)aboveState.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Direction.UP), 2);
                    } else {
                        currentFacing = (Direction)aboveState.m_61143_((Property)BlockStateProperties.f_61372_);
                        currentFacing = currentFacing.m_122427_();
                        aboveState = (BlockState)aboveState.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)currentFacing);
                        world.m_7731_(abovePos, aboveState, 2);
                    }
                }
                if (aboveState.m_61145_((Property)BlockStateProperties.f_61373_).isPresent() && (currentFacing = (Direction)aboveState.m_61143_((Property)BlockStateProperties.f_61373_)) != Direction.DOWN) {
                    currentFacing = currentFacing.m_122427_();
                    aboveState = (BlockState)aboveState.m_61124_((Property)BlockStateProperties.f_61373_, (Comparable)currentFacing);
                    world.m_7731_(abovePos, aboveState, 2);
                }
                if ((aboveEntities = world.m_45933_(null, AABB.m_165882_((Vec3)new Vec3((double)abovePos.m_123341_() + 0.5, (double)abovePos.m_123342_() + 0.5, (double)abovePos.m_123343_() + 0.5), (double)1.0, (double)1.0, (double)1.0))) != null && aboveEntities.size() > 0) {
                    for (Entity entity : aboveEntities) {
                        double centX = (double)abovePos.m_123341_() + 0.5;
                        double centY = abovePos.m_123342_();
                        double centZ = (double)abovePos.m_123343_() + 0.5;
                        double distToCenter = Math.sqrt(entity.m_20275_(centX, centY, centZ));
                        double xDiff = entity.m_20185_() - centX;
                        double zDiff = entity.m_20189_() - centZ;
                        double entityAngle = Math.toDegrees(Math.atan2(zDiff, xDiff));
                        entityAngle = (entityAngle + 90.0) % 360.0;
                        entity.m_146922_(entity.m_7890_(Rotation.CLOCKWISE_90) % 360.0f);
                        double newX = centX + distToCenter * Math.cos(Math.toRadians(entityAngle));
                        double newZ = centZ + distToCenter * Math.sin(Math.toRadians(entityAngle));
                        entity.m_6021_(newX, entity.m_20186_(), newZ);
                    }
                }
            }
            world.m_7731_(pos, (BlockState)newFacing.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(signal)), 2);
        }
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, POWERED});
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)super.m_5573_(context).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(context.m_43725_().m_276867_(context.m_8083_())));
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter p_220053_2_, BlockPos p_220053_3_, CollisionContext p_220053_4_) {
        switch ((Direction)blockState.m_61143_((Property)f_54117_)) {
            case NORTH: {
                return SHAPE_NORTH;
            }
            case SOUTH: {
                return SHAPE_NORTH;
            }
            case EAST: {
                return SHAPE_NORTH;
            }
            case WEST: {
                return SHAPE_NORTH;
            }
        }
        return SHAPE_NORTH;
    }
}

