/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.blocks;

import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SmallTableBlock
extends Block {
    protected static final VoxelShape SHAPE_NORMAL = Stream.of(Block.m_49796_((double)0.01, (double)0.0, (double)0.01, (double)15.99, (double)16.0, (double)15.99)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    public static final EnumProperty<TableType> TYPE = EnumProperty.m_61587_((String)"type", TableType.class);

    public SmallTableBlock(BlockBehaviour.Properties p_i48377_1_) {
        super(p_i48377_1_);
        this.m_49959_((BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)((Object)TableType.single)));
    }

    public SmallTableBlock(BlockBehaviour.Properties p_i48377_1_, boolean skipDefaultState) {
        super(p_i48377_1_);
        if (!skipDefaultState) {
            this.m_49959_((BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)((Object)TableType.single)));
        }
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        if (super.getFlammability(state, world, pos, face) > 0) {
            return 20;
        }
        return 0;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        if (super.getFlammability(state, world, pos, face) > 0) {
            return 5;
        }
        return 0;
    }

    public BlockState m_7417_(BlockState state, Direction dir, BlockState updater, LevelAccessor world, BlockPos pos, BlockPos updaterPos) {
        return this.getNewState(world, pos);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{TYPE});
    }

    protected BlockState getNewState(LevelAccessor world, BlockPos pos) {
        BlockState nState = world.m_8055_(pos.m_122012_());
        BlockState eState = world.m_8055_(pos.m_122029_());
        BlockState sState = world.m_8055_(pos.m_122019_());
        BlockState wState = world.m_8055_(pos.m_122024_());
        int adjacentTableCount = 0;
        boolean nTable = nState.m_60713_((Block)this);
        boolean eTable = eState.m_60713_((Block)this);
        boolean sTable = sState.m_60713_((Block)this);
        boolean wTable = wState.m_60713_((Block)this);
        if (nTable) {
            ++adjacentTableCount;
        }
        if (eTable) {
            ++adjacentTableCount;
        }
        if (sTable) {
            ++adjacentTableCount;
        }
        if (wTable) {
            ++adjacentTableCount;
        }
        if (adjacentTableCount >= 2) {
            if (nTable && eTable && !sTable && !wTable) {
                return (BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)((Object)TableType.sw_corner));
            }
            if (nTable && wTable && !sTable && !eTable) {
                return (BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)((Object)TableType.se_corner));
            }
            if (sTable && eTable && !nTable && !wTable) {
                return (BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)((Object)TableType.nw_corner));
            }
            if (sTable && wTable && !nTable && !eTable) {
                return (BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)((Object)TableType.ne_corner));
            }
            return (BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)((Object)TableType.mid));
        }
        if (adjacentTableCount == 1) {
            if (nTable) {
                return (BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)((Object)TableType.s_end));
            }
            if (eTable) {
                return (BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)((Object)TableType.w_end));
            }
            if (sTable) {
                return (BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)((Object)TableType.n_end));
            }
            if (wTable) {
                return (BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)((Object)TableType.e_end));
            }
        }
        return this.m_49966_();
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return this.getNewState((LevelAccessor)context.m_43725_(), context.m_8083_());
    }

    public VoxelShape m_5940_(BlockState bs, BlockGetter reader, BlockPos pos, CollisionContext sel) {
        return SHAPE_NORMAL;
    }

    public static enum TableType implements StringRepresentable
    {
        single,
        mid,
        s_end,
        w_end,
        n_end,
        e_end,
        ne_corner,
        se_corner,
        nw_corner,
        sw_corner;


        public String m_7912_() {
            return this.name().toLowerCase();
        }
    }
}

