/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.blocks;

import com.dairymoose.modernlife.blocks.AbstractWallBlock;
import com.dairymoose.modernlife.tileentities.ShowerHeadBlockEntity;
import com.dairymoose.modernlife.util.ModernLifeUtil;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ShowerHeadBlock
extends AbstractWallBlock
implements EntityBlock {
    protected static final VoxelShape SHAPE_NORTH = Stream.of(Block.m_49796_((double)6.5, (double)9.0, (double)10.75, (double)9.5, (double)12.0, (double)16.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape SHAPE_EAST = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_NORTH);
    protected static final VoxelShape SHAPE_SOUTH = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_EAST);
    protected static final VoxelShape SHAPE_WEST = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_SOUTH);

    public ShowerHeadBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.SOUTH));
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return ModernLifeUtil.createTickerHelper(type, ShowerHeadBlockEntity.SHOWER_HEAD, ShowerHeadBlockEntity::tick);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ShowerHeadBlockEntity.SHOWER_HEAD.m_155264_(pos, state);
    }

    public InteractionResult m_6227_(BlockState blockState, Level world, BlockPos pos, Player Player2, InteractionHand hand, BlockHitResult rayTrace) {
        BlockEntity tileEntity = world.m_7702_(pos);
        if (tileEntity instanceof ShowerHeadBlockEntity) {
            ShowerHeadBlockEntity showerHead = (ShowerHeadBlockEntity)tileEntity;
            if (!showerHead.isRunning()) {
                showerHead.startRunning();
            } else {
                showerHead.stopRunning();
            }
            if (!world.f_46443_) {
                ((ServerLevel)world).m_7260_(pos, blockState, blockState, 2);
            }
        }
        return InteractionResult.CONSUME;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public VoxelShape m_5940_(BlockState bs, BlockGetter reader, BlockPos pos, CollisionContext sel) {
        switch ((Direction)bs.m_61143_((Property)FACING)) {
            case NORTH: {
                return SHAPE_NORTH;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
            case EAST: {
                return SHAPE_EAST;
            }
            case WEST: {
                return SHAPE_WEST;
            }
        }
        return SHAPE_NORTH;
    }
}

