/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.blocks;

import com.dairymoose.modernlife.blocks.gui.RadiatorScreen;
import com.dairymoose.modernlife.tileentities.RadiatorBlockEntity;
import com.dairymoose.modernlife.util.ModernLifeUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;

public class RadiatorBlock
extends Block
implements SimpleWaterloggedBlock,
EntityBlock {
    protected static final VoxelShape SHAPE_NORTH = Block.m_49796_((double)2.0, (double)0.0, (double)5.0, (double)15.0, (double)13.0, (double)12.0);
    protected static final VoxelShape SHAPE_EAST = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_NORTH);
    protected static final VoxelShape SHAPE_SOUTH = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_EAST);
    protected static final VoxelShape SHAPE_WEST = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_SOUTH);
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<HeatType> HEAT = EnumProperty.m_61587_((String)"heat", HeatType.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public RadiatorBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60918_(SoundType.f_56743_).m_60913_(3.5f, 10.0f).m_60953_(RadiatorBlock::getLightValueInternal));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(HEAT, (Comparable)((Object)HeatType.off))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    public boolean m_7898_(BlockState p_196260_1_, LevelReader p_196260_2_, BlockPos p_196260_3_) {
        return !p_196260_2_.m_46859_(p_196260_3_.m_7495_());
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public FluidState m_5888_(BlockState p_204507_1_) {
        return (Boolean)p_204507_1_.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(p_204507_1_);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return ModernLifeUtil.createTickerHelper(type, RadiatorBlockEntity.RADIATOR, RadiatorBlockEntity::tick);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return RadiatorBlockEntity.RADIATOR.m_155264_(pos, state);
    }

    public BlockState m_7417_(BlockState p_196271_1_, Direction p_196271_2_, BlockState p_196271_3_, LevelAccessor p_196271_4_, BlockPos p_196271_5_, BlockPos p_196271_6_) {
        if (((Boolean)p_196271_1_.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            p_196271_4_.m_186469_(p_196271_5_, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)p_196271_4_));
        }
        return super.m_7417_(p_196271_1_, p_196271_2_, p_196271_3_, p_196271_4_, p_196271_5_, p_196271_6_);
    }

    public InteractionResult m_6227_(BlockState p_225533_1_, final Level p_225533_2_, final BlockPos p_225533_3_, Player p_225533_4_, InteractionHand p_225533_5_, BlockHitResult p_225533_6_) {
        if (p_225533_2_.f_46443_) {
            DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> new Runnable(){

                @Override
                public void run() {
                    RadiatorScreen screen = new RadiatorScreen(p_225533_2_, p_225533_3_);
                    Minecraft.m_91087_().m_91152_((Screen)screen);
                }
            });
        }
        return InteractionResult.CONSUME;
    }

    public static int getLightValueInternal(BlockState state) {
        if (state.m_61143_(HEAT) == HeatType.low) {
            return 3;
        }
        if (state.m_61143_(HEAT) == HeatType.medium) {
            return 5;
        }
        if (state.m_61143_(HEAT) == HeatType.high) {
            return 7;
        }
        return 0;
    }

    public int m_7753_(BlockState state, BlockGetter world, BlockPos pos) {
        return RadiatorBlock.getLightValueInternal(state);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack itemStack, @Nullable BlockGetter blockReader, List<Component> list, TooltipFlag tooltipFlag) {
        list.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("Right click placed radiator to activate")));
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isEmissiveRendering(BlockState blockState) {
        if (blockState.m_61143_(HEAT) == HeatType.low) {
            return true;
        }
        if (blockState.m_61143_(HEAT) == HeatType.medium) {
            return true;
        }
        return blockState.m_61143_(HEAT) == HeatType.high;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, HEAT, WATERLOGGED});
    }

    public VoxelShape m_5940_(BlockState bs, BlockGetter reader, BlockPos pos, CollisionContext sel) {
        switch ((Direction)bs.m_61143_((Property)FACING)) {
            case NORTH: {
                return SHAPE_NORTH;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
            case EAST: {
                return SHAPE_EAST;
            }
            case WEST: {
                return SHAPE_WEST;
            }
        }
        return SHAPE_NORTH;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
    }

    public static enum HeatType implements StringRepresentable
    {
        off,
        low,
        medium,
        high;


        public String m_7912_() {
            return this.name().toLowerCase();
        }
    }
}

