/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.blocks;

import com.dairymoose.modernlife.blocks.gui.WirelessPowerScreen;
import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.core.ModernLifeCommon;
import com.dairymoose.modernlife.tileentities.IChannelHolder;
import com.dairymoose.modernlife.tileentities.PowerTransmitterBlockEntity;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;

public class PowerTransmitterBlock
extends Block
implements EntityBlock {
    public static final IntegerProperty POWER;
    public static final DirectionProperty FACING;
    private int maxUpdatesPerTick = 100;
    private Map<BlockPos, Integer> updatesThisTickMap = new HashMap<BlockPos, Integer>();
    private long lastUpdatedTick = 0L;

    public PowerTransmitterBlock(BlockBehaviour.Properties p_i48377_1_) {
        super(p_i48377_1_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack itemStack, @Nullable BlockGetter blockReader, List<Component> list, TooltipFlag tooltipFlag) {
        list.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("Transmits power on the selected channel to all receivers")));
        list.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("Right click block to change current channel")));
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public InteractionResult m_6227_(BlockState p_225533_1_, final Level p_225533_2_, final BlockPos p_225533_3_, Player p_225533_4_, InteractionHand p_225533_5_, BlockHitResult p_225533_6_) {
        if (p_225533_2_.f_46443_) {
            DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> new Runnable(){

                @Override
                public void run() {
                    BlockEntity tileEntity = p_225533_2_.m_7702_(p_225533_3_);
                    if (tileEntity instanceof IChannelHolder) {
                        IChannelHolder channelHolder = (IChannelHolder)tileEntity;
                        WirelessPowerScreen screen = new WirelessPowerScreen(p_225533_3_, channelHolder.getCurrentChannel());
                        Minecraft.m_91087_().m_91152_((Screen)screen);
                    }
                }
            });
        }
        return InteractionResult.CONSUME;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        BlockEntity tileEntity;
        if (!world.f_46443_ && (tileEntity = world.m_7702_(pos)) instanceof PowerTransmitterBlockEntity) {
            PowerTransmitterBlockEntity transmitter = (PowerTransmitterBlockEntity)tileEntity;
            transmitter.setCurrentChannel(0);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, POWER});
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return PowerTransmitterBlockEntity.POWER_TRANSMITTER.m_155264_(pos, state);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter blockReader, BlockPos blockPos, CollisionContext ctx) {
        return super.m_5939_(state, blockReader, blockPos, ctx);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState p_196243_4_, boolean p_196243_5_) {
        BlockEntity entity = world.m_7702_(pos);
        if (entity instanceof PowerTransmitterBlockEntity) {
            PowerTransmitterBlockEntity transmitter = (PowerTransmitterBlockEntity)entity;
            ModernLifeCommon.LOGGER.debug("remove transmitter from channel: " + transmitter.getCurrentChannel());
            transmitter.removeFromChannel(transmitter.getCurrentChannel());
            transmitter.updateReceivers(world);
        }
        super.m_6810_(state, world, pos, p_196243_4_, p_196243_5_);
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos neighbor, boolean p_220069_6_) {
        BlockEntity entity;
        if (world.m_8055_(neighbor).m_60713_((Block)CustomBlocks.BLOCK_POWER_RECEIVER.get())) {
            return;
        }
        if (state.m_60713_((Block)CustomBlocks.BLOCK_POWER_TRANSMITTER.get()) && (entity = world.m_7702_(pos)) instanceof PowerTransmitterBlockEntity) {
            boolean isNewTick = ModernLifeCommon.serverTickCounter != this.lastUpdatedTick;
            int updatesThisTick = this.updatesThisTickMap.computeIfAbsent(pos, blockPos -> 0);
            if (isNewTick || updatesThisTick < this.maxUpdatesPerTick) {
                if (isNewTick) {
                    this.updatesThisTickMap.clear();
                    updatesThisTick = 0;
                }
                this.updatesThisTickMap.put(pos, ++updatesThisTick);
                this.lastUpdatedTick = ModernLifeCommon.serverTickCounter;
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)POWER, (Comparable)Integer.valueOf(world.m_277086_(pos))), 2);
                PowerTransmitterBlockEntity transmitter = (PowerTransmitterBlockEntity)entity;
                ModernLifeCommon.LOGGER.debug("add transmitter to channel: " + transmitter.getCurrentChannel());
                transmitter.addToChannel(transmitter.getCurrentChannel());
                transmitter.updateReceivers(world);
            }
        }
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_())).m_61124_((Property)POWER, (Comparable)Integer.valueOf(context.m_43725_().m_277086_(context.m_8083_())));
    }

    public VoxelShape m_5940_(BlockState p_220053_1_, BlockGetter p_220053_2_, BlockPos p_220053_3_, CollisionContext p_220053_4_) {
        return Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    }

    static {
        FACING = BlockStateProperties.f_61374_;
        POWER = BlockStateProperties.f_61426_;
    }
}

