/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.blocks;

import com.dairymoose.modernlife.blocks.gui.WirelessPowerScreen;
import com.dairymoose.modernlife.core.ModernLifeCommon;
import com.dairymoose.modernlife.tileentities.IChannelHolder;
import com.dairymoose.modernlife.tileentities.PowerReceiverBlockEntity;
import com.dairymoose.modernlife.tileentities.PowerTransmitterBlockEntity;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;

public class PowerReceiverBlock
extends Block
implements EntityBlock {
    protected static final VoxelShape SHAPE = Stream.of(Block.m_49796_((double)6.5, (double)2.0, (double)6.5, (double)9.5, (double)5.0, (double)9.5), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.m_49796_((double)2.0, (double)4.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0), Block.m_49796_((double)4.0, (double)8.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0), Block.m_49796_((double)6.0, (double)12.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack itemStack, @Nullable BlockGetter blockReader, List<Component> list, TooltipFlag tooltipFlag) {
        list.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("Receives power on the selected channel from all transmitters")));
        list.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("Right click block to change current channel")));
    }

    public PowerReceiverBlock(BlockBehaviour.Properties p_i48377_1_) {
        super(p_i48377_1_);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.SOUTH)).m_61124_((Property)POWERED, (Comparable)Boolean.FALSE));
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public InteractionResult m_6227_(BlockState p_225533_1_, final Level p_225533_2_, final BlockPos p_225533_3_, Player p_225533_4_, InteractionHand p_225533_5_, BlockHitResult p_225533_6_) {
        if (p_225533_2_.f_46443_) {
            DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> new Runnable(){

                @Override
                public void run() {
                    BlockEntity tileEntity = p_225533_2_.m_7702_(p_225533_3_);
                    if (tileEntity instanceof IChannelHolder) {
                        IChannelHolder channelHolder = (IChannelHolder)tileEntity;
                        WirelessPowerScreen screen = new WirelessPowerScreen(p_225533_3_, channelHolder.getCurrentChannel());
                        Minecraft.m_91087_().m_91152_((Screen)screen);
                    }
                }
            });
        }
        return InteractionResult.CONSUME;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        BlockEntity tileEntity;
        if (!world.f_46443_ && (tileEntity = world.m_7702_(pos)) instanceof PowerReceiverBlockEntity) {
            PowerReceiverBlockEntity receiver = (PowerReceiverBlockEntity)tileEntity;
            receiver.setCurrentChannel(0);
        }
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return PowerReceiverBlockEntity.POWER_RECEIVER.m_155264_(pos, state);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState p_196243_4_, boolean p_196243_5_) {
        BlockEntity entity = world.m_7702_(pos);
        if (entity instanceof PowerReceiverBlockEntity) {
            PowerReceiverBlockEntity receiver = (PowerReceiverBlockEntity)entity;
            ModernLifeCommon.LOGGER.debug("remove receiver from channel: " + receiver.getCurrentChannel());
            receiver.removeFromChannel(receiver.getCurrentChannel());
        }
        if (!p_196243_5_ && !state.m_60713_(p_196243_4_.m_60734_())) {
            this.updateNeighbours(state, world, pos);
            super.m_6810_(state, world, pos, p_196243_4_, p_196243_5_);
        }
    }

    private int getPowerFromTransmitter(BlockPos pos, BlockGetter reader) {
        BlockEntity entity = reader.m_7702_(pos);
        ModernLifeCommon.LOGGER.debug("get power: " + entity);
        if (entity instanceof PowerReceiverBlockEntity) {
            ModernLifeCommon.LOGGER.debug("entity is instance");
            PowerReceiverBlockEntity receiver = (PowerReceiverBlockEntity)entity;
            Set<PowerTransmitterBlockEntity> transmitters = PowerTransmitterBlockEntity.perChannelPowerTransmitters.get(receiver.getCurrentChannel());
            int powerSum = 0;
            if (transmitters != null) {
                ModernLifeCommon.LOGGER.debug("found " + transmitters.size() + " transmitters for channel " + receiver.getCurrentChannel());
                for (PowerTransmitterBlockEntity transmitter : transmitters) {
                    BlockState state = transmitter.m_58900_();
                    powerSum += ((Integer)state.m_61143_((Property)BlockStateProperties.f_61426_)).intValue();
                }
                if (powerSum > 15) {
                    powerSum = 15;
                }
                ModernLifeCommon.LOGGER.debug("got power sum = " + powerSum);
            } else {
                ModernLifeCommon.LOGGER.debug("transmitters is null for channel " + receiver.getCurrentChannel());
            }
            return powerSum;
        }
        return 0;
    }

    public boolean m_7899_(BlockState p_60571_) {
        return true;
    }

    public boolean m_7923_(BlockState p_220074_1_) {
        return true;
    }

    public int m_6378_(BlockState state, BlockGetter reader, BlockPos pos, Direction p_180656_4_) {
        ModernLifeCommon.LOGGER.debug("getSignal for state=" + state + " and pos=" + pos);
        return this.getPowerFromTransmitter(pos, reader);
    }

    public int m_6376_(BlockState p_176211_1_, BlockGetter p_176211_2_, BlockPos p_176211_3_, Direction p_176211_4_) {
        ModernLifeCommon.LOGGER.debug("getDirectSignal");
        return this.getPowerFromTransmitter(p_176211_3_, p_176211_2_);
    }

    private void updateNeighbours(BlockState p_196378_1_, Level p_196378_2_, BlockPos p_196378_3_) {
        p_196378_2_.m_46672_(p_196378_3_, (Block)this);
        p_196378_2_.m_46672_(p_196378_3_.m_121945_(((Direction)p_196378_1_.m_61143_((Property)FACING)).m_122424_()), (Block)this);
    }

    public VoxelShape m_5940_(BlockState bs, BlockGetter reader, BlockPos pos, CollisionContext sel) {
        return SHAPE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, POWERED});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        for (Direction lvt_5_1_ : context.m_6232_()) {
            BlockState lvt_6_2_;
            if (lvt_5_1_.m_122434_() == Direction.Axis.Y || !(lvt_6_2_ = (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)lvt_5_1_.m_122424_())).m_60710_((LevelReader)context.m_43725_(), context.m_8083_())) continue;
            return lvt_6_2_;
        }
        return this.m_49966_();
    }
}

