/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.blocks;

import com.dairymoose.modernlife.tileentities.NightStandBlockEntity;
import com.dairymoose.modernlife.util.ModernLifeUtil;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class NightStandBlock
extends Block
implements EntityBlock {
    protected static final VoxelShape SHAPE_SOUTH = Stream.of(Block.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)16.0, (double)14.0), Block.m_49796_((double)5.0, (double)11.6, (double)15.0, (double)11.0, (double)12.6, (double)16.0), Block.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)1.0), Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)1.0, (double)2.0, (double)14.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)2.0, (double)1.0), Block.m_49796_((double)15.0, (double)0.0, (double)13.0, (double)16.0, (double)2.0, (double)14.0), Block.m_49796_((double)5.0, (double)5.475, (double)14.0, (double)6.0, (double)6.475, (double)15.0), Block.m_49796_((double)5.0, (double)5.475, (double)15.0, (double)11.0, (double)6.475, (double)16.0), Block.m_49796_((double)10.0, (double)5.475, (double)14.0, (double)11.0, (double)6.475, (double)15.0), Block.m_49796_((double)5.0, (double)11.6, (double)14.0, (double)6.0, (double)12.6, (double)15.0), Block.m_49796_((double)10.0, (double)11.6, (double)14.0, (double)11.0, (double)12.6, (double)15.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape SHAPE_WEST = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_SOUTH);
    protected static final VoxelShape SHAPE_NORTH = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_WEST);
    protected static final VoxelShape SHAPE_EAST = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_NORTH);
    protected String containerDisplayLabel = "Night Stand";
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack itemStack, @Nullable BlockGetter blockReader, List<Component> list, TooltipFlag tooltipFlag) {
        list.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("Stores up to 18 items")));
    }

    public NightStandBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_60918_(SoundType.f_56736_).m_60978_(1.5f));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.SOUTH));
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        if (super.getFlammability(state, world, pos, face) > 0) {
            return 20;
        }
        return 0;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        if (super.getFlammability(state, world, pos, face) > 0) {
            return 5;
        }
        return 0;
    }

    public NightStandBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.SOUTH));
    }

    public void m_6810_(BlockState p_196243_1_, Level p_196243_2_, BlockPos p_196243_3_, BlockState p_196243_4_, boolean p_196243_5_) {
        if (!p_196243_1_.m_60713_(p_196243_4_.m_60734_())) {
            BlockEntity lvt_6_1_ = p_196243_2_.m_7702_(p_196243_3_);
            if (lvt_6_1_ instanceof NightStandBlockEntity) {
                Containers.m_19002_((Level)p_196243_2_, (BlockPos)p_196243_3_, (Container)((NightStandBlockEntity)lvt_6_1_));
                p_196243_2_.m_46717_(p_196243_3_, (Block)this);
            }
            super.m_6810_(p_196243_1_, p_196243_2_, p_196243_3_, p_196243_4_, p_196243_5_);
        }
    }

    public MenuProvider m_7246_(BlockState p_220052_1_, final Level p_220052_2_, final BlockPos p_220052_3_) {
        return new MenuProvider(){

            public AbstractContainerMenu m_7208_(int paramInt, Inventory paramInventory, Player paramPlayer) {
                BlockEntity tileEntity = p_220052_2_.m_7702_(p_220052_3_);
                if (tileEntity instanceof NightStandBlockEntity) {
                    NightStandBlockEntity nightStandBlockEntity = (NightStandBlockEntity)tileEntity;
                    return new ChestMenu(MenuType.f_39958_, paramInt, paramInventory, (Container)nightStandBlockEntity, 2);
                }
                return null;
            }

            public Component m_5446_() {
                return MutableComponent.m_237204_((ComponentContents)new LiteralContents(NightStandBlock.this.containerDisplayLabel));
            }
        };
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        NightStandBlockEntity toReturn = (NightStandBlockEntity)NightStandBlockEntity.NIGHT_STAND.m_155264_(pos, state);
        return toReturn;
    }

    public InteractionResult m_6227_(BlockState p_225533_1_, Level p_225533_2_, BlockPos p_225533_3_, Player p_225533_4_, InteractionHand p_225533_5_, BlockHitResult p_225533_6_) {
        MenuProvider lvt_7_1_ = this.m_7246_(p_225533_1_, p_225533_2_, p_225533_3_);
        if (lvt_7_1_ != null) {
            p_225533_4_.m_5893_(lvt_7_1_);
        }
        return InteractionResult.CONSUME;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public VoxelShape m_5940_(BlockState bs, BlockGetter reader, BlockPos pos, CollisionContext sel) {
        switch ((Direction)bs.m_61143_((Property)FACING)) {
            case NORTH: {
                return SHAPE_NORTH;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
            case EAST: {
                return SHAPE_EAST;
            }
            case WEST: {
                return SHAPE_WEST;
            }
        }
        return SHAPE_NORTH;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }
}

