/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.blocks;

import com.dairymoose.modernlife.blocks.gui.EaselScreen;
import com.dairymoose.modernlife.blocks.gui.EaselSizeScreen;
import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.core.ModernLifeClient;
import com.dairymoose.modernlife.core.ModernLifeCommon;
import com.dairymoose.modernlife.core.ModernLifeConfig;
import com.dairymoose.modernlife.tileentities.EaselBlockEntity;
import com.dairymoose.modernlife.util.ModernLifeUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;

public class EaselBlock
extends Block
implements EntityBlock {
    protected static final VoxelShape SHAPE_NORTH = Block.m_49796_((double)3.5, (double)0.0, (double)3.2, (double)14.0, (double)23.0, (double)12.8);
    protected static final VoxelShape SHAPE_EAST = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_NORTH);
    protected static final VoxelShape SHAPE_SOUTH = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_EAST);
    protected static final VoxelShape SHAPE_WEST = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_SOUTH);
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty EMPTY = BooleanProperty.m_61465_((String)"empty");

    public EaselBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_60918_(SoundType.f_56736_).m_60913_(2.5f, 0.0f));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)EMPTY, (Comparable)Boolean.TRUE));
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        if (super.getFlammability(state, world, pos, face) > 0) {
            return 20;
        }
        return 0;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        if (super.getFlammability(state, world, pos, face) > 0) {
            return 5;
        }
        return 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack itemStack, @Nullable BlockGetter blockReader, List<Component> list, TooltipFlag tooltipFlag) {
        list.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("Place a canvas on it to begin painting")));
    }

    public boolean m_7898_(BlockState p_196260_1_, LevelReader p_196260_2_, BlockPos p_196260_3_) {
        return !p_196260_2_.m_46859_(p_196260_3_.m_7495_()) && !p_196260_2_.m_8055_(p_196260_3_.m_7495_()).m_60713_((Block)CustomBlocks.BLOCK_EASEL.get());
    }

    public void m_6810_(BlockState p_196243_1_, Level p_196243_2_, BlockPos p_196243_3_, BlockState p_196243_4_, boolean p_196243_5_) {
        if (!p_196243_1_.m_60713_(p_196243_4_.m_60734_())) {
            BlockEntity lvt_6_1_ = p_196243_2_.m_7702_(p_196243_3_);
            if (lvt_6_1_ instanceof Container) {
                Containers.m_19002_((Level)p_196243_2_, (BlockPos)p_196243_3_, (Container)((Container)lvt_6_1_));
                p_196243_2_.m_46717_(p_196243_3_, (Block)this);
            }
            super.m_6810_(p_196243_1_, p_196243_2_, p_196243_3_, p_196243_4_, p_196243_5_);
        }
    }

    public InteractionResult m_6227_(BlockState p_225533_1_, final Level p_225533_2_, final BlockPos p_225533_3_, Player p_225533_4_, InteractionHand p_225533_5_, BlockHitResult p_225533_6_) {
        if (p_225533_4_.m_21205_().m_41720_() == CustomBlocks.ITEM_CANVAS.get()) {
            if (((Boolean)p_225533_1_.m_61143_((Property)EMPTY)).booleanValue()) {
                BlockEntity tileEntity;
                if (!p_225533_2_.f_46443_ && (tileEntity = p_225533_2_.m_7702_(p_225533_3_)) instanceof EaselBlockEntity) {
                    EaselBlockEntity easelBlockEntity = (EaselBlockEntity)tileEntity;
                    if (p_225533_2_ instanceof ServerLevel && easelBlockEntity != null) {
                        easelBlockEntity.m_6836_(0, p_225533_4_.m_21205_().m_41777_());
                        p_225533_4_.m_21205_().m_41764_(0);
                        BlockState newState = (BlockState)p_225533_1_.m_61124_((Property)EMPTY, (Comparable)Boolean.valueOf(false));
                        p_225533_2_.m_46597_(p_225533_3_, newState);
                        ((ServerLevel)p_225533_2_).m_7260_(p_225533_3_, p_225533_1_, newState, 2);
                    }
                }
                return InteractionResult.CONSUME;
            }
        } else if (p_225533_4_.m_21205_().m_41720_() == Items.f_41852_ && p_225533_4_.m_20161_()) {
            if (!((Boolean)p_225533_1_.m_61143_((Property)EMPTY)).booleanValue()) {
                if (!p_225533_2_.f_46443_) {
                    BlockEntity tileEntity = p_225533_2_.m_46745_(p_225533_3_).m_7702_(p_225533_3_);
                    ModernLifeCommon.LOGGER.debug("tileEntity = " + tileEntity);
                    if (tileEntity instanceof EaselBlockEntity) {
                        EaselBlockEntity easelBlockEntity = (EaselBlockEntity)tileEntity;
                        if (p_225533_2_ instanceof ServerLevel && easelBlockEntity != null) {
                            Object image = null;
                            ItemStack canvasItem = easelBlockEntity.m_8020_(0).m_41777_();
                            easelBlockEntity.m_6836_(0, ItemStack.f_41583_);
                            p_225533_2_.m_46597_(p_225533_3_, (BlockState)p_225533_1_.m_61124_((Property)EMPTY, (Comparable)Boolean.valueOf(true)));
                            ItemStack itemStack = canvasItem;
                            if (itemStack != null) {
                                p_225533_4_.m_21008_(InteractionHand.MAIN_HAND, itemStack);
                            }
                        }
                    }
                }
                return InteractionResult.CONSUME;
            }
        } else if (!((Boolean)p_225533_1_.m_61143_((Property)EMPTY)).booleanValue()) {
            if (p_225533_2_.f_46443_) {
                DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> new Runnable(){

                    @Override
                    public void run() {
                        EaselScreen screen = new EaselScreen(p_225533_2_, p_225533_3_);
                        BlockEntity tileEntity = p_225533_2_.m_7702_(p_225533_3_);
                        ModernLifeCommon.LOGGER.debug("tileEntity = " + tileEntity);
                        if (tileEntity instanceof EaselBlockEntity) {
                            EaselBlockEntity easelBlockEntity = (EaselBlockEntity)tileEntity;
                            ItemStack item = easelBlockEntity.m_8020_(0);
                            ModernLifeCommon.LOGGER.debug("item = " + item);
                            if (item.m_41720_() == CustomBlocks.ITEM_CANVAS.get()) {
                                ModernLifeCommon.LOGGER.debug("canvas = " + tileEntity);
                                if (item.m_41782_() && item.m_41783_().m_128441_("UniqueId")) {
                                    long uniqueId = item.m_41783_().m_128454_("UniqueId");
                                    byte[] imageData = ModernLifeClient.getCanvasData(uniqueId);
                                    if (imageData != null && imageData.length > 0) {
                                        int texW = 0;
                                        int texH = 0;
                                        texW = ModernLifeClient.getCanvasWidth(uniqueId);
                                        texH = ModernLifeClient.getCanvasHeight(uniqueId);
                                        screen.setTextureSize(texW, texH);
                                        screen.setInitialData(imageData);
                                        ModernLifeCommon.LOGGER.debug("initialData = " + imageData.length);
                                    }
                                } else {
                                    if (((Boolean)ModernLifeConfig.CLIENT.showEaselResolutionScreen.get()).booleanValue()) {
                                        EaselSizeScreen sizeScreen = new EaselSizeScreen(p_225533_2_, p_225533_3_);
                                        Minecraft.m_91087_().m_91152_((Screen)sizeScreen);
                                        return;
                                    }
                                    ModernLifeCommon.LOGGER.debug("empty canvas size = " + ModernLifeConfig.CLIENT.emptyCanvasEaselSize.get());
                                    screen.setTextureSize((Integer)ModernLifeConfig.CLIENT.emptyCanvasEaselSize.get(), (Integer)ModernLifeConfig.CLIENT.emptyCanvasEaselSize.get());
                                }
                            }
                        }
                        screen.setBlockPos(p_225533_3_);
                        Minecraft.m_91087_().m_91152_((Screen)screen);
                    }
                });
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        EaselBlockEntity toReturn = (EaselBlockEntity)EaselBlockEntity.EASEL.m_155264_(pos, state);
        return toReturn;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, EMPTY});
    }

    public VoxelShape m_5940_(BlockState bs, BlockGetter reader, BlockPos pos, CollisionContext sel) {
        switch ((Direction)bs.m_61143_((Property)FACING)) {
            case NORTH: {
                return SHAPE_NORTH;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
            case EAST: {
                return SHAPE_EAST;
            }
            case WEST: {
                return SHAPE_WEST;
            }
        }
        return SHAPE_NORTH;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_());
    }
}

